static char rcsid[] = "$Id: windows.c,v 1.3 1992/01/27 14:47:13 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  windows.c:
 *
 *    CreateTitleBar() :	Create title bar.
 *    CreateFileLabel() :	Create file label in file window (static).
 *    CreateLineLabel() :	Create line label in file window (static).
 *    CreateFileWindow() :	Create file window (static).
 *    CreateFunctionLabel:      Create a label for the current function (static).
 *    CreateMessageWindow() :	Create message window (static).
 *    CreateDisplayWindow() :	Create display window (static).
 *    CreateSubWindows() :	Create the subwindows.
 *    UpdateFileLabel() :	Update file label.
 *    UpdateLineLabel() :	Update line label.
 *    UpdateMessageWindow() :	Update message window.
 *    SelectVar():              Callback for symbol selection if display 
 *                              (static).
 *    CreateInfoDialog():       Create the info popup dialog (static).
 *    CreateFileSelectionDialog(): Create the file selection box (static).
 *    CreateExitDialog():       Create the exit question dialog (static).
 *    Info():                   Manage the info dialog (static).
 *    HelpQuitActivate():       Quit the help dialog (static).
 *    HelpUpActivate():         Go up a level in the help dialog (static).
 *    ManageQuit():             Manage the quit dialog (static).
 */

#include "global.h"
#include "bitmaps.h"
#include "MB.h"

#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/CascadeB.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>

static void CreateFunctionLabel(Widget);
static void CreateFileLabel(Widget);
static void CreateLineLabel(Widget);
static void CreateFileWindow(Widget);
static void CreateMessageWindow(Widget);
static void SelectVar(Widget, XEvent*, String*, Cardinal*);
static void CreateDisplayWindow(Widget);
static void CreateInfoDialog(Widget);
static void CreateFileSelectionDialog(Widget);
static void CreateExitDialog(Widget);
static void Info(Widget, XtPointer, XmPushButtonCallbackStruct*);
static void HelpQuitActivate(Widget, XtPointer, XmPushButtonCallbackStruct*);
static void HelpUpActivate(Widget, XtPointer, XmArrowButtonCallbackStruct*);
static void ManageQuit(Widget, XtPointer, XmPushButtonCallbackStruct*);

Widget	fileWindow,			/* parent of fileLabel and lineLabel */
	messageWindow,			/* window for displaying messages */
	separator,			/* separator in vpane */
	displayWindow,			/* area for displaying variables */
        fileSel,
        displayFD,
        topMenuBar,
        topForm,
        fileCButton, commandsCButton,
        filePMenu, commandPMenu, infoFD,
        filePbutton, searchPbutton, quitPbutton,
        runningCbutton, helpPMenu, helpCButton,
        helpFD;

Widget vpane, exitWarning;

static Widget 	fileLabel,		/* filename of displayed text */
		lineLabel,		/* line number of caret position */
                functionLabel;          /* current function name */
/*
 *  Private routines for creating various subwindows for mxgdb.
 */

static void CreateFunctionLabel(parent)
     Widget parent;
{
  
  functionLabel = XtCreateManagedWidget("functionLabel", xmLabelWidgetClass,
					parent, NULL, 0);
}
static void CreateFileLabel(parent)
     Widget parent;
{
  fileLabel = XtCreateManagedWidget("fileLabel", xmLabelWidgetClass, 
				    parent, NULL, 0);
}

static void CreateLineLabel(parent)
     Widget parent;
{
  lineLabel = XtCreateManagedWidget("lineLabel", xmLabelWidgetClass, 
				    parent, NULL, 0);
}

static void CreateFileWindow(parent)
Widget parent;
{
    Arg 	args[MAXARGS];
    Dimension   height;

    fileWindow = XtCreateManagedWidget("fileWindow", xmFormWidgetClass,
				      parent, NULL, 0);


    XtSetArg(args[0], XmNheight, &height);
    XtGetValues(fileWindow, args, 1);
    XtSetArg(args[0], XmNpaneMinimum, height);
    XtSetArg(args[1], XmNpaneMaximum, height); 
    XtSetValues(fileWindow, args, 2);
    CreateFunctionLabel(fileWindow);
    CreateLineLabel(fileWindow);
    CreateFileLabel(fileWindow);

}

static void CreateMessageWindow(parent)
Widget parent;
{
    Arg 	args[MAXARGS];
	
    Dimension   height;

    messageWindow = XtCreateManagedWidget("messageWindow", xmLabelWidgetClass,
					  parent, NULL, 0);

    XtSetArg(args[0], XmNheight, &height);
    XtGetValues(messageWindow, args, 1);
    XtSetArg(args[0], XmNpaneMinimum, height);
    XtSetArg(args[1], XmNpaneMaximum, height); 
    XtSetValues(messageWindow, args, 2);
    
}

static void SelectVar(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
  char *displayString, *term1, *term2;
  XmTextPosition pos, bottom, left, right;
  
  displayString = (char *) XmTextGetString(w);
  pos = XmTextGetInsertionPosition(w);
  bottom = XmTextGetLastPosition(w);

  if(displayString && *displayString)
    {
      left = pos;
      right = pos;
      while(left > 0 && displayString[left-1] != '\n') left--;
      while(right <=  bottom && displayString[right] != '\n') right++;
      
      XmTextSetSelection(w, left, right, 0);
    }
  if(displayString) XtFree(displayString);
}

/*  Create a window for displaying variables as specified by the display
 *  command in gdb.
 */
static void CreateDisplayWindow(parent)
Widget parent;
{
    static XtActionsRec display_actions[] = {
	{"SelectVar", 	(XtActionProc) SelectVar},
        {NULL, NULL}
    };

    displayFD = XmCreateFormDialog(parent, "displayWindowFD", 
				   NULL, 0);
    displayWindow = (Widget) XmCreateScrolledText(displayFD, "displayWindow",
                                          NULL, 0);
    XtManageChild(displayWindow);
    XtAppAddActions(app_context, display_actions, XtNumber(display_actions));
}

static void CreateInfoDialog(parent)
Widget parent;
{
  infoFD = XmCreateInformationDialog(parent, "infoWindow", NULL, 0);
  XtUnmanageChild(XmMessageBoxGetChild(infoFD, XmDIALOG_HELP_BUTTON));
}

/* Callback for the Help*Info menu selection */
static void Info(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XmPushButtonCallbackStruct *call_data;
{
  XtManageChild(infoFD);
}

static void HelpQuitActivate(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XmPushButtonCallbackStruct *call_data;
{
  XtUnmanageChild(helpFD);
}

				/* ActivationCallback for the up button in  */
				/* the help popup dialog */
static void HelpUpActivate(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XmArrowButtonCallbackStruct *call_data;
{
  char command[LINESIZ];
  extern int helpstackidx;
  extern char helpstack[HELP_LEVELS][HELP_SIZE];
  extern char help_buttons_use_flag;

  --helpstackidx;		/* decrement the help stack pointer */
  sprintf(command, "help %s\n", helpstack[helpstackidx]);

  help_buttons_use_flag=1;	/* Ugly: set this flag to tell the handler */
  query_gdb(command);		/* that this is a request from the up button */
  help_buttons_use_flag=0;
}

static void ManageQuit(w, client_data, call_data)
     Widget w;
     XtPointer client_data;
     XmPushButtonCallbackStruct *call_data;
{
  XtManageChild(exitWarning);
}

/* These are used in gdb_handler help_handler */
Widget helpselectscroll, helpupbutton, helpupbuttonlabel;

static void CreateHelpWindow(parent)
Widget parent;
{
  Widget helpquitbutton, scrollW;

  helpFD = XmCreateFormDialog(parent, "helpWindow", NULL, 0);
  scrollW = XtCreateManagedWidget("scrollHW", 
				  xmScrolledWindowWidgetClass,
				  helpFD, NULL, 0);

  helpselectscroll = XtCreateManagedWidget("scrollHWForm",
					   xmFormWidgetClass,
					   scrollW, NULL, 0);
  XmScrolledWindowSetAreas(scrollW, NULL, NULL, helpselectscroll);

  XtCreateManagedWidget("separatorHW", xmSeparatorWidgetClass,  
			helpFD, NULL, 0);

  helpupbutton = (Widget) XmCreateArrowButton(helpFD, "upbuttonHW", 
					       NULL, 0);
  XtAddCallback(helpupbutton, XmNactivateCallback, HelpUpActivate, NULL);
  helpupbuttonlabel = XtCreateWidget("uplabelHW",
				     xmLabelWidgetClass,
				     helpFD, NULL, 0);
  helpquitbutton = XtCreateManagedWidget("quitbuttonHW", 
					 xmPushButtonWidgetClass, 
					 helpFD, NULL, 0);
  XtAddCallback(helpquitbutton, XmNactivateCallback, HelpQuitActivate, NULL);
}

static MenuButtonStruct fileButtons[] = {
  { NULL, "File...", "", "filePbutton", File, "Ctrl <Key> f", "!f" },
  { NULL, "Search...", "", "searchPbutton", PopupSearch, "Ctrl <Key> w", 
      "!w" },
  { NULL, "Commands...", "", "commandsPbutton", PopupCommands, "", "" },
  { NULL, "Xtty...", "", "xttyPbutton", XttyCallback, "", "" },
  { NULL, "Exit...", "", "quitPbutton", ManageQuit, "Ctrl <Key> e", "!e" },
};

static MenuButtonStruct helpButtons[] = {
  { NULL, "Gdb Help...", "", "helpPMB", Help, "Ctrl <Key> h", "!h" },
  { NULL, "Info...", "", "infoPMB", Info, "", "" },
};

static MenuButtonStruct runningButtons[] = {
  { NULL, "Run", "run\n", "runPMB", DoIt, "Ctrl <Key> r", "!r" },
  { NULL, "Continue", "cont\n", "contPMB", DoIt, "", "" },
  { NULL, "Next", "next\n", "nextPMB", DoIt, "Ctrl <Key> n", "!n" },
  { NULL, "Step", "step\n", "stepPMB", DoIt, "Ctrl <Key> s", "!s" },
  { NULL, "Finish", "finish\n", "finishPMB", DoIt, "", "" },
};

static MenuButtonStruct dataButtons[] = {
  { NULL, "Print", "", "printPMB", Print, "Ctrl <Key> p", "!p"},
  { NULL, "Display...", "", "displayPMB", Display_, "", ""},
  { NULL, "Undisplay", "", "undisplayPMB", Undisplay, "", "" },
};

static MenuButtonStruct breakpointsButtons[] = {
  { NULL, "Break", "break", "breakPMB", Break, "Ctrl <Key> b", "!b" },
  { NULL, "Clear", "", "clearPMB", Clear, "", "" },
  { NULL, "Tbreak", "tbreak", "tbreakPMB", Break, "", ""},
};

static MenuButtonStruct stackButtons[] = {
  { NULL, "Up", "up\n", "upPMB", DoIt, "Ctrl <Key> g", "!g" },
  { NULL, "Down", "down\n", "downPMB", DoIt, "Ctrl <Key> j", "!j" },
};

static MenuButtonStruct infoButtons[] = {
  { NULL, "Locals", "info locals\n", "ilocalsPMB", DoIt, "", "" },
  { NULL, "Args", "info args\n", "iargsPMB", DoIt, "", "" },
  { NULL, "Stack", "info stack\n", "istackPMB", DoIt, "", "" },
};

static PMCBStruct commandMB[] = {
  { NULL, NULL, "Running", "runningPM", "runningCB", runningButtons, 5, 'R'},
  { NULL, NULL, "Data", "dataPM", "dataCB", dataButtons, 3, 'D' },
  { NULL, NULL, "Breakpoints", "breakpointsPM", "breakpointsCB", 
      breakpointsButtons, 3, 'B' },
  { NULL, NULL, "Stack", "stackPM", "stackCB", stackButtons, 2, 'S' },
  { NULL, NULL, "Info", "infoPM", "infoCB", infoButtons, 3, 'I' },
};

static PMCBStruct topMenuMB[] = {
  { NULL, NULL, "File", "filePM", "fileCB", fileButtons, 5, 'F'},
  { NULL, NULL, "Commands", "commandsPM", "commandsCB", NULL, 0, 'C'},
  { NULL, NULL, "Help", "helpPM", "helpCB", helpButtons, 2, 'H'},
};

static void CreateMenuPane(parent)
Widget parent;
{
  Arg args[MAXARGS];
  
  topForm = XtCreateManagedWidget("topForm", xmFormWidgetClass, parent,
				  NULL, 0);
  
  topMenuBar = XmCreateMenuBar(topForm, "topMenuBar", NULL, 0);
  XtManageChild(topMenuBar);

  XtSetArg(args[0], XmNtopWidget, topMenuBar);
  XtSetArg(args[1], XmNtopAttachment, XmATTACH_WIDGET);
  vpane = XtCreateManagedWidget( "vpane", xmPanedWindowWidgetClass,
				    topForm, args, 2);

  CreatePulldownMenu(topMenuBar, topMenuMB, 3);
  CreatePulldownMenu(topMenuMB[1].PM, commandMB, 5);
}

static void CreateFileSelectionDialog(parent)
Widget parent;
{
  fileSel = (Widget) XmCreateFileSelectionDialog(parent, 
						 "fileSelectorBox", 
						 NULL, 0);
  XtAddCallback(fileSel, XmNokCallback, OKCallBack, NULL);
  XtAddCallback(fileSel, XmNcancelCallback, CancelCallBack, NULL);
}

static void CreateExitDialog(parent)
Widget parent;
{
  exitWarning = XmCreateQuestionDialog(parent, "exitQD", NULL, 0);
  XtAddCallback(exitWarning, XmNokCallback, Quit, NULL);
  XtUnmanageChild(XmMessageBoxGetChild(exitWarning, XmDIALOG_HELP_BUTTON));
}

/*
 *  Top level function for creating all the mxgdb subwindows.
 */
void CreateSubWindows(parent)
Widget parent;
{
  CreateMenuPane(parent);
  CreateFileWindow(vpane);
  CreateSourceWindow(vpane);
  CreateMessageWindow(vpane);
  CreateDialogWindow(vpane);
  CreateFileSelectionDialog(toplevel);
  CreateDisplayWindow(toplevel);
  CreateHelpWindow(toplevel);
  CreateSearchPopup(toplevel);
  CreateInfoDialog(toplevel);
  CreateExitDialog(toplevel);
} 

/*
 *  Routines for updating fields for the filename and line number
 *  in the file window, and the execution status in the message window.
 */

void UpdateFileLabel(string)
char *string;
{
    Arg 	args[MAXARGS];

    XtSetArg(args[0], XmNlabelString, XmStrMk(string)); 
    XtSetValues(fileLabel, args, 1);
}

void UpdateFunctionLabel(string)
     char *string;
{
  Arg args[MAXARGS];

  XtSetArg(args[0], XmNlabelString, XmStrMk(string)); 
  XtSetValues(functionLabel, args, 1);
 
}

void UpdateLineLabel(line)
Cardinal line;
{
    Arg 	args[MAXARGS];
    Cardinal 	n;
    char 	string[10];

    n = 0;
    if (line > 0)
    	sprintf(string, "%d", line);
    else
	strcpy(string, "");
    XtSetArg(args[0], XmNlabelString, XmStrMk(string)); 
    XtSetValues(lineLabel, args, 1);
}

void UpdateMessageWindow(format, arg)
     char *format, *arg;
{
  char *message;
  char string[LINESIZ];
  int fulllength;
  Arg 	args[MAXARGS];
  
  fulllength = strlen ("  ") + strlen (format) + 1
    + ((arg == NULL) ? 0 : strlen (arg));

  if (fulllength > LINESIZ)
    message = (char*) XtMalloc (fulllength);
  else
    message = string;
  
  strcpy(message, "  ");
  sprintf(message + strlen(message), format, arg);

  XtSetArg(args[0], XmNlabelString, XmStrMk(message)); 
  XtSetValues(messageWindow, args, 1);
  
  if (fulllength > LINESIZ)
    XtFree(message);
}
