/* $Id: MB.h,v 1.1.1.1 1992/01/10 18:29:37 jtsillas Exp $ */

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

#ifndef XmStrMk
#define XmStrMk(x)	XmStringCreateLtoR((x), XmSTRING_DEFAULT_CHARSET)
#endif

typedef struct {		/* Structure which defines a button */
  Widget Button;		/* within the pulldown menu heirarchy  */
  char *Label;			/* in the menu bar. This is used by */
  char *Argument;		/* the Command heirarchy and the Help */
  char *RN;			/* heirarchy. Button specifies the  */
  void (*CB)();			/* widget, Label is text placed in the */
  char *accel;			/* button, Argument is passed to the */
  char *acceltext;		/* callback (CB XmNactivateCallback), */
} MenuButtonStruct;		/* RN is the resource name, accel and */
				/* acceltext are the accelerator KeyPress */
				/* and text, respectively. */

typedef struct {		/* Structure which defines a pulldown menu */
  Widget CB;			/* pane within the oulldown menu heirarchy. */
  Widget PM;			/* CB is the CascadeButton widget, PM is the */
  char *Label;			/* PM is the PulldownMenu, Label is the */
  char *RNPM;			/* button's label, RNPM and RNCB are the */
  char *RNCB;			/* resource names for the PM and CB, Buttons */
  MenuButtonStruct *Buttons;	/* points to a MenuButton Struct for the */
  int Nbuttons;			/* child buttons, Nbuttons is the number of */
  char mnemonic;		/* button children, mnemonic is the mnemonic */
} PMCBStruct;			/* KeySym. */

void CreateMenuButton(Widget, MenuButtonStruct*, int);
void CreatePulldownMenu(Widget, PMCBStruct*, int);

