/* test16.c - test CPU16 background mode drivers
 * Copyright (C) 1992 by Scott Howard, all rights reserved
 * Permission is hereby granted to freely copy and use this code or derivations thereof
 * as long as no charge is made to anyone for its use
 */

char *TargetName = "CPU16";

#include	"textio.h"
#include	"newline.h"
#include	"regs-16.h"
#include	"bdmcalls.h"

void DumpRegisters (void)
{
	int Stopped = StopChip ();
	unsigned SR, Counter;
	LONG Temp;

	printf (
	"ACCD   %04X\tACCM %01X.%04X%04X" NEWLINE
	"ACCE   %04X\tHR     %04X" NEWLINE
	"IX   %01X %04X\tIR     %04X" NEWLINE
	"IY   %01X %04X\tXMSK   %04X" NEWLINE
	"IZ   %01X %04X\tYMSK   %04X" NEWLINE
	"SP   %01X %04X" NEWLINE
	"PC   %01X %04X" NEWLINE
	"K      %04X" NEWLINE ,
		(WORD) GetReg (REG_D),
		(WORD) GetReg (REG_AM2 & 0xf),
		(WORD) GetReg (REG_AM1),
		(WORD) GetReg (REG_AM0),
		(WORD) GetReg (REG_E),
		(WORD) GetReg (REG_H),
		(WORD) (GetReg (REG_K) & 0xf00) >> 8,
		(WORD) GetReg (REG_IX),
		(WORD) GetReg (REG_I),
		(WORD) (GetReg (REG_K) & 0xf0) >> 4,
		(WORD) GetReg (REG_IY),
		(WORD) GetReg (REG_XMYM) >> 8,
		(WORD) (GetReg (REG_K) & 0xf),
		(WORD) GetReg (REG_IZ),
		(WORD) GetReg (REG_XMYM) & 0xff,
		(WORD) GetReg (REG_SK),
		(WORD) GetReg (REG_SP),
		(WORD) GetReg (REG_PK),
		(WORD) GetReg (REG_PC),
		(WORD) GetReg (REG_K));
	printf ("       SMHENZVC210S-PK-" NEWLINE "CCR    ");
	Temp = GetReg (REG_CCR);
	SR = 0x8000;
	for (Counter = 0; Counter < 16; Counter++)
	{
		putchar ((Temp & SR) ? '1' : '0');
		SR >>= 1;
	}
	puts ( NEWLINE );
	if (Stopped) RunChip (0);
}
