#ifndef _WIDGET_H_
#define _WIDGET_H_
/*
 *	The producer/consumer programs produce and consume widgets.
 *	The structure of widgets, and operations on them are
 *	descriibed below.
 */

#define MAX_WIDGET_NAME  10
#define WIDGET_ROOT_ENTRY "widget_file"

extern int		global_bufgroup;
extern VOLID	global_volid;
extern TID		global_tid;

typedef struct {
	char	producerName[MAX_WIDGET_NAME+1];
	int		widgetNum;
	unsigned char	filler[1];
} widget_t;

extern int findWidgetVolume();

extern int getWidgetFile(FID* fid, char* name);

extern int destroyWidgetFile(FID* fid);

extern int produce(FID* widgetFid, int numWidgets, int widgetSize,
	               char* producerName);

extern int consume(FID* widgetFid, int numWidgets, 
	               char* producerName);

#endif /* _WIDGET_H_ */
