/*
 * $RCSfile: indexloadscan.c,v $
 * $Revision: 1.11 $
 * $Date: 1993/05/04 15:06:21 $
 */
#include "sm_client.h"
#include <stdlib.h>

#include <strings.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#ifdef __cplusplus
#	include <osfcn.h>
#else
	extern char		*malloc();
	extern char		*getenv();
#endif

TID tid;
int bufGroup;
VOLID volid;

int testIntIndex(int keyCount);
int testDoubleIndex(int keyCount);

/*
 * ErrorCheck( ) is a simple routine for checking
 * Storage Manager return codes.
 */
 int
ErrorCheck (
    int    e,              /* error return code */
    char   *routine        /* the routine that caused an error */
)
{
    if (e < 0) {
        fprintf(stderr, "Got a Storage Manager error from %s\n", routine);
        fprintf(stderr, "Error = %s\n", sm_Error(sm_errno));
        exit(1);
    }
    return(0);
}


main (int argc, char** argv)
{
	int e;
	char    *errorMsg;

    /*
     *  Read the default configuration files to
     *  have the bufpages option set.
     */
    e = sm_ReadConfigFile(NULL, argv[0], &errorMsg);
    if (e != esmNOERROR) {
        fprintf(stderr, "Configuration file error: %s\n", errorMsg);
        ErrorCheck(e, "sm_ReadConfigFile");
        exit(0);
    }

    /*
     *  Set any options from the command line
     */
    e = sm_ParseCommandLine(&argc, argv, &errorMsg);
    if (e != esmNOERROR) {
        fprintf(stderr, "command line error: %s\n", errorMsg);
        ErrorCheck(e, "sm_PargeCommandLine");
        exit(0);
    }
	
	/* check for the proper number of arguments */
    if (argc != 2) {
		fprintf(stderr,"usage: %s keycount\n", argv[0]);
		exit(-1);
    }

	/*
	 *	get the parameters of the test
	 */
	int keyCount = atoi(argv[1]);

    /*
     * Initialize the storage manager.
     */
    e = sm_Initialize();
	ErrorCheck(e, "sm_Initialize");

	/*
	 *	get the disk volume id
	 */
	char* volidStr = getenv("EVOLID");
	if (volidStr == NULL) {
		printf("Please set the EVOLID environment variable\n");
		exit(1);
	}
    volid = atoi(volidStr);

    /*
     * Open a small buffer group.
     */
	printf("Open a buffer group\n");
    e = sm_OpenBufferGroup(100, BF_LRU, &bufGroup, NOFLAGS);
	ErrorCheck(e, "sm_OpenBufferGroup");


	testIntIndex(keyCount);
	testDoubleIndex(keyCount);

    printf("Finished\n");


    /*
     * Shut everything down.
     */
    e = sm_CloseBufferGroup(bufGroup);
	ErrorCheck(e, "sm_CloseBufferGroup");


    e = sm_ShutDown();
	ErrorCheck(e, "sm_ShutDown");

    exit(0);
}


int testIntIndex(int keyCount)
{
	int e;

	/*
	 *	start the transation
	 */
	printf("Start a transaction\n");
	e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	/*
	 * Create Index object
	 */
	printf("creating index object\n");
	IID ndx;
	e = sm_CreateIndex(volid, bufGroup, SM_BTREENDX, SM_int,
									sizeof(int), sizeof(OID), TRUE, &ndx);
	ErrorCheck(e, "sm_CreateIndex"); 


	int buff;
	KEY key;
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	OID	oid;
	bzero((char *)&oid, (int)sizeof(oid));

	printf("Insert %d integer keys into a unique index\n", keyCount);
	for (int i = 0; i < keyCount; i++)   {
		buff = i;

		e = sm_InsertEntry(&ndx, bufGroup, &key, &oid);
		ErrorCheck(e, "sm_InsertEntry");
    	}

    /*
     *	Commit the transaction
     */
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");

	printf("Finished\n");


    /*
     *  start the transation
     */
    printf("Start a new transaction\n");
    e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	printf("Looking up everything inserted so far (serial) \n");
	buff = 0;
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	KEY keyEnd;
	keyEnd.length = sizeof(buff);
	keyEnd.valuePtr = &keyCount;
	SMCURSOR cursor;
	e = sm_FetchInit(&ndx, bufGroup, &key, SM_EQ, &keyEnd, SM_LEQ, &cursor);
	ErrorCheck(e, "sm_FetchInit");
	for (i = 0; i < keyCount; i++)  {
		int e;
		BOOL eof;

		e = sm_FetchNext(&cursor, &key, &oid, &eof);
		ErrorCheck(e, "sm_FetchNext");
		if (eof)  {
			printf("unexpected EOF\n");
			exit(-1);
			}
		if (buff != i)  {
			printf("index inconsistent\n");
			exit(-1);
			}
		}
	printf("Successful.\n");


    /*
     *  Commit the transaction
     */
	printf("Commit the transaction\n");
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");
	

    /*
     *  start the transation
     */
    printf("Start a new transaction\n");
    e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	printf("Remove everything inserted so far (serial) \n");
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	for (i = 0; i < keyCount; i++)  {

		buff = i;

		e = sm_RemoveEntry(&ndx, bufGroup, &key, &oid);
		ErrorCheck(e, "sm_RemoveEntry");
		}

	e = sm_DestroyIndex(&ndx, bufGroup);
	ErrorCheck(e, "sm_DestroyIndex"); 

    /*
     *  Commit the transaction
     */
	printf("Commit the transaction\n");
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");
	
	printf("Successful.\n");
	return(0);
}


int testDoubleIndex(int keyCount)
{
	int e;

	/*
	 *	start the transation
	 */
	printf("Start a transaction\n");
	e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	/*
	 * Create Index object
	 */
	printf("creating index object\n");
	IID ndx;
	e = sm_CreateIndex(volid, bufGroup, SM_BTREENDX, SM_double,
									sizeof(double), sizeof(OID), TRUE, &ndx);
	ErrorCheck(e, "sm_CreateIndex"); 


	double buff;
	KEY key;
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	OID	oid;
	bzero((char *)&oid, (int)sizeof(oid));

	printf("Insert %d double keys into a unique index\n", keyCount);
	for (int i = 0; i < keyCount; i++)   {
		buff = i;

		e = sm_InsertEntry(&ndx, bufGroup, &key, &oid);
		ErrorCheck(e, "sm_InsertEntry");
    	}

    /*
     *	Commit the transaction
     */
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");

	printf("Finished\n");


    /*
     *  start the transation
     */
    printf("Start a new transaction\n");
    e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	printf("Looking up everything inserted so far (serial) \n");
	buff = 0;
	double buffEnd = keyCount;
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	KEY keyEnd;
	keyEnd.length = sizeof(buffEnd);
	keyEnd.valuePtr = &buffEnd;
	SMCURSOR cursor;
	e = sm_FetchInit(&ndx, bufGroup, &key, SM_EQ, &keyEnd, SM_LEQ, &cursor);
	ErrorCheck(e, "sm_FetchInit");
	for (i = 0; i < keyCount; i++)  {
		int e;
		BOOL eof;

		e = sm_FetchNext(&cursor, &key, &oid, &eof);
		ErrorCheck(e, "sm_FetchNext");
		if (eof)  {
			printf("unexpected EOF\n");
			exit(-1);
			}
		if (buff != i)  {
			printf("index inconsistent\n");
			exit(-1);
			}
		}
	printf("Successful.\n");


    /*
     *  Commit the transaction
     */
	printf("Commit the transaction\n");
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");
	

    /*
     *  start the transation
     */
    printf("Start a new transaction\n");
    e = sm_BeginTransaction( &tid );
	ErrorCheck(e, "sm_BeginTransaction");

	printf("Remove everything inserted so far (serial) \n");
	key.length = sizeof(buff);
	key.valuePtr = &buff;
	for (i = 0; i < keyCount; i++)  {

		buff = i;

		e = sm_RemoveEntry(&ndx, bufGroup, &key, &oid);
		ErrorCheck(e, "sm_RemoveEntry");
		}

	e = sm_DestroyIndex(&ndx, bufGroup);
	ErrorCheck(e, "sm_DestroyIndex"); 

    /*
     *  Commit the transaction
     */
	printf("Commit the transaction\n");
    e = sm_CommitTransaction(tid);
	ErrorCheck(e, "sm_CommitTransaction");
	
	printf("Successful.\n");
	return(0);
}

	
