/*
 *  "Hello world" program for the EXODUS Storage Manager
 * $RCSfile: helloworld.c,v $
 * $Revision: 1.5 $
 * $Date: 1993/04/27 22:23:26 $
 *
 *  This program sets configuration options, connects with a server
 *  prints "hello world", and shuts down the client side of the
 *  Storage Manager. 
 */

#include "sm_client.h"
#include <stdlib.h>


void ErrorCheck (int, char *);

/*
 *	Main program:
 */
main(int argc, char** argv)
{

	int		e;
	char	*errorMsg;
	TID		tid;

	/* Read the default configuration files */
	e = sm_ReadConfigFile(NULL, argv[0], &errorMsg);
	if (e != esmNOERROR) {
		fprintf(stderr, "Configuration file error: %s\n", errorMsg);
		ErrorCheck(e, "sm_ReadConfigFile");
		exit(0);
	}

	/* Set any options from the command line */
	e = sm_ParseCommandLine(&argc, argv, &errorMsg);
	if (e != esmNOERROR) {
		fprintf(stderr, "command line error: %s\n", errorMsg);
		ErrorCheck(e, "sm_PargeCommandLine");
		exit(0);
	}

    /* Initialize the storage manager.  */
    e = sm_Initialize();
    ErrorCheck(e, "sm_Initialize");

	/*
	 *  A more complete program would now mount a volume,
	 *  and begin a transaction.
	 */

	printf("Hello world!\n");

	/* shut down the Storage Manager client */
	e = sm_ShutDown( );
	ErrorCheck(e, "sm_ShutDown");
}


void ErrorCheck ( int e, char *routine)
{
    if (e < 0) {
        fprintf(stderr, "Got a Storage Manager error from %s\n", routine);
        fprintf(stderr, "Error = %s\n", sm_Error(sm_errno));
        exit(1);
    }
}



