#ifndef _ETERROR_H_
#define _ETERROR_H_
/*
 * $RCSfile: etError.h,v $
 * $Revision: 1.9 $
 * $Date: 1993/02/15 17:35:00 $
 */

#ifndef _STDIO_H_
#include <stdio.h>
#endif _STDIO_H_

#include <setjmp.h>

#ifndef EPERM
#include <errno.h>
#endif

#define NOINFO 			-1
#define MALLOC_ERR 			0
#define OVF_ERR			1
#define RAND_NOT_SET			2
#define ENDOFFILE			3
#define SCRIPT_FILE 		4
#define PIPE_STDIN		5


#define	SM_INIT_ERR			6
#define	SM_MOUNTVOL_ERR			7
#define SM_BEGINTRANS_ERR		8
#define SM_COMMIT_TRANS_ERR		9
#define SM_ABORT_TRANS_ERR		10
#define SM_CD_FILE_ERR		11
#define SM_SETRTENTRY_ERR		12
#define SM_SHUTDOWN_SERVER_ERR		13
#define SM_CONNTO_SERVER_ERR		14
#define SM_CREATE_OBJ_ERROR		15
#define SM_DESTROY_OBJ_ERR		16
#define SM_INSERT_OBJ_ERR		17
#define SM_APPEND_OBJ_ERR		18
#define SM_DELETE_FROM_OBJ_ERR		19
#define SM_READ_OBJ_ERR			20
#define SM_READ_OBJ_HEADER_ERR		21
#define SM_RELEASE_OBJ_ERR		22
#define SM_FREEZE_VERSION_ERR		23
#define SM_CREATE_VERSION_ERR		24
#define SM_SET_OBJHEADER_ERR		25
#define SM_WRITE_OBJ_ERR		26
#define SM_CLOSE_BUF_GROUP_ERR		27
#define SM_DISMOUNT_VOL_ERR		28
#define SM_SHUTDOWN_ERR			29
#define UNUSED30			30
#define CHECKSUM		31
#define NOVOLUME		32
#define BAD_OBJ_NUM		33
#define SM_CHECK_POINT_ERR		34
#define SM_CHANGE_CKPT_FREQ_ERR		35
#define SM_SHUTDOWNSERVER_ERR		36
#define SM_OPENSCAN_ERR		 	37
#define SM_SCANNEXTOBJ_ERR	 	38
#define SM_CLOSESCAN_ERR	 	39
#define SM_SERVERSTAT_ERR	 	40	
#define NOSUCHCOMMAND	 	41	
#define SYNTAXERROR	 		42
#define	VAL_ROOTENTRY_CHANGED 43
#define	OBJECT_ALREADY_DESTROYED 44
#define	INVALID_OBJ_NUM 45
#define SM_2PC_ERR		46
#define STRING_TOOLONG		47
#define NOSUCHVARIABLE		48
#define CANTCLOSEBG		49
#define CANTOPENBG		50
#define NOVOLUMES		51
#define TOOFEW		52
#define TOOMANY		53

#define CAUSE_NONE			0
#define CAUSE_USER			1 /* e.g., syntax error == EXIT_CAUSE_USER */
#define CAUSE_VALIDATION	2 /* e.g., validation error == EXIT_CAUSE_VALIDATION */
#define CAUSE_SM			3 /* e.g., server died  == EXIT_CAUSE_SM */
#define CAUSE_ET			4 /* e.g., internal inconsistency == EXIT_CAUSE_ET */
#define CAUSE_UNIX			5 /* e.g., malloc failed ==EXIT_CAUSE_UNIX */

#define TREAT_INFO			0   /* informational only */
#define TREAT_NONFATAL		1   /* consider it a problem */
#define TREAT_FATAL			2	/* exit now */

/* exit status for problems: */
#ifndef EXIT_SUCCESS
	/* also defined in <stdlib.h> to be 0 */
#define	EXIT_SUCCESS		0	/* no problem */
#endif 	EXIT_SUCCESS
#define	EXIT_USER			100	/* user problem */
#define	EXIT_VALIDATIONERR	102	/* SM problem */
#define	EXIT_INTERNAL		103 	/* ET problem */
#define	EXIT_UNIX			104	/* UNIX problem */


extern char *ETERRORMSG[];
extern int  reportableProblems;


BEGIN_EXTERNC
	void handle_error( int, int, int, int, char *, BOOL, VOLID, int);
END_EXTERNC

#define HANDLE_ERROR(s,t,a)\
	handle_error(s,t,a,__LINE__,__FILE__, FALSE, 0, 0);

#define HANDLE_ERRWRECONNECT(s,t,a, volid, tries)\
	handle_error(s,t,a,__LINE__,__FILE__, FALSE, volid, tries);

#define HANDLE_ERROR_AND_CHECK(s,t,a)\
	handle_error(s,t,a,__LINE__,__FILE__, TRUE, 0, 0);

extern BOOL debugon;
#define DEBUGINFO if(debugon) fprintf(stderr,
#define INFO fprintf(stdout,
#define ENDINFO );
#endif /* _ETERROR_H_ */
