/*
 * $RCSfile: echo.c,v $
 * $Revision: 1.3 $
 * $Date: 1993/01/20 17:24:01 $
 */
#include "et.h"
#include "func.h"
#include "command_funcs.h"
#include "etError.h"

static FILE *echoFile = stdout;
static BOOL echoOn = FALSE;

int
open_echofile(char *str)
{
	char *arg = next_word(str, Whitespace);
	char *rest;

	if( rest = next_word(0, Whitespace) ) {
		HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, SYNTAXERROR);
		INFO
			"\"%s\" ignored\n",rest
		ENDINFO
	}

	if(arg != NULL) {
		switch(word2cmd(arg)) {
		case WORD_STDOUT:	
			echoFile = stdout;
			break;
		case WORD_STDERR:	
			echoFile = stderr;
			break;
		default:
			echoFile = fopen(arg, "a");
			if(echoFile==NULL) {
				echoFile = stdout;
				HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, EBADF);
				return esmFAILURE;
			}
		}
	}
	/* no file given --> leave it as it was */
	return esmNOERROR;
}

void
echo(int linenum, char *line)
{
	if (echoOn)
		fprintf(echoFile, "%d\t%s\n", linenum, line);
}
int
echo_command(ELIPSES)
{
	echoOn = TRUE;
	return open_echofile(NULL);
}
int
noecho_command(ELIPSES)
{
	ignore_restofline();
	echoOn = FALSE;
	if(echoFile != stdout) { /* just to be sureELIPSES */
		fflush(echoFile);
		fclose(echoFile);
	}
	echoFile = stdout;
	return esmNOERROR;
}
int
endechofile_command(ELIPSES)
{
	ignore_restofline();
	echoOn = FALSE;
	if(echoFile != stdout) /* just to be sureELIPSES */
		fclose(echoFile);
	echoFile = stdout;
	return esmNOERROR;
}
