/*
 * $RCSfile: array.c,v $
 * $Revision: 1.7 $
 * $Date: 1993/05/05 20:02:39 $
 */
#include "et.h"
#include "etError.h"
#include "func.h"


/********************************************************
 *
 * 	fillUA	
 *
 *******************************************************/
void fillUA(ObjInfo *UA, int index, int sum, int parentNum) 
{
	UA[index].index = index;
	UA[index].destroyed = FALSE;
	UA[index].checkSum = sum; 
	UA[index].parentONum = parentNum; 
}


/********************************************************
 *
 *      printArray
 *
 *******************************************************/

void printobj (int num, ObjInfo *obj)
{
	printf("%-4d %-6d %-5d %-2d",
		num,
		(int)(obj->objID.diskAddr.volid), (int)(obj->objID.diskAddr.page),
		(int)(obj->objID.diskAddr.slot));

	printf(" %-6d 0x%04x %-8.8d",
		obj->objHdr.size, obj->objHdr.tag, obj->checkSum);

	printf(" %1.1s %1.1s %1.1s ",
		obj->destroyed?"D":" ",
		(obj->objHdr.properties & P_MOVED)?"M":" ",
		(obj->objHdr.properties & P_LARGEOBJ)?"L":" ",
		(obj->objHdr.properties & P_VERSIONED)?"V":" ",
		(obj->objHdr.properties & P_FROZEN)?"F":" ");

	if(obj->parentONum > -1) {
		printf("%-7.7d\n", obj->parentONum);
	} else {
		printf("  N/A  \n");
	}
}
void pdash() {
	static char *dash = "-----------------------------------------------------------";

	printf("%-4.4s %-6.6s %-5.5s %-2.2s",dash,dash,dash,dash);
	printf(" %-6.6s %6.6s %8.8s", dash,dash,dash);
	printf(" %-5.5s %-7.7s\n", dash,dash);
}
void printArray (ObjInfo *array, int numOfObj)
{
	ObjInfo *objinfo;
    int	i,j=0;

	printf("%-4.4s %-6.6s %-5.5s %-2.2s","Obj#", "volid","page","sl");
	printf(" %-6.6s %6.6s %8.8s", "size", "tag  ", "checksum");
	printf(" DMLVF %-7.7s\n", "parent#");

	pdash();

    for (objinfo = array, i = 0; i < numOfObj; i++, objinfo++) {
		if (!objinfo->destroyed)	j++;

		printobj(i, objinfo);
	}
	pdash();

    printf("Total %d existing objects.\n", j);

}



/********************************************************
 *
 *	copyArrays
 *
 *******************************************************/
void 
check_no_temp_objects(ObjInfo *array, int count)
{
	int	i;
	VOLID v;

	for (i = 0; i < count; i++) {
		if( array[i].destroyed ) 
			continue;
		v = array[i].objID.diskAddr.volid;
		if(Volids[find_volid_index(v)].temp == TRUE) {
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, NOINFO);
		}
	}
}
void 
mark_temp_objects_destroyed(ObjInfo *array, int count)
{
	int	i;
	VOLID v;

	for (i = 0; i < count; i++) {
		v = array[i].objID.diskAddr.volid;
		if(Volids[find_volid_index(v)].temp == TRUE) {
			array[i].destroyed = TRUE;
		}
	}
}

void
printUA()
{
	printArray(UA, objUACount);
}

void
printCA()
{
	printArray(CA, objCACount);
}
int
copyArrays(ObjInfo *to, ObjInfo *from, int count)
{
	int	i;

	for (i = 0; i < count; i++)
	{
		to[i].index = from[i].index;
		to[i].destroyed = from[i].destroyed;
		to[i].objID = from[i].objID;
		to[i].checkSum = from[i].checkSum;
		to[i].objHdr = from[i].objHdr;
		to[i].parentONum = from[i].parentONum;
	}
	return count;
}

