#ifndef _TID_H_
#define _TID_H_
/*
 *   $RCSfile: tid.h,v $  
 *   $Revision: 2.9 $  
 *   $Date: 1992/11/27 16:46:25 $      
 */ 
#ifndef __tid_h__
#define __tid_h__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#include "list.h"

/* BEGIN visible to user */

/*
 *	define the transaction id
 */
typedef long	TID;

/*
 *	define the null tid
 */
#define NULL_TID	(0)


/*
 * define the maximum length of opaque char string in GTID 
 */
#define MAXOPAQUELEN 255

/*
 *	define the global transaction id
 */
typedef struct {
	
	int 		length;
	char 		opaque[MAXOPAQUELEN];

} GTID;

/* END visible to user */

typedef struct {
	GTID		gtid;
	LISTELEMENT gtidList;  
} GTIDREC;

/*
 *	define transaction privileges
 */
#define TRANSPRIV_NORMAL	0x0
#define TRANSPRIV_PREEMPT	0x1

#endif /* __tid_h__ */
#endif /* _TID_H_ */
