#ifndef _MSGSTATS_H_
#define _MSGSTATS_H_
/*
 *   $RCSfile: msgstats.h,v $  
 *   $Revision: 1.7 $  
 *   $Date: 1993/04/02 14:23:49 $      
 */ 
#ifndef __MSGSTATS_H__
#define __MSGSTATS_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/* BEGIN visible to user */

/*
 *	definitions for communication between the client and the server process
 */
#define ERROR_REPLY	 		0 	/* reply from server to client,
								 * when server cannot even tell what
								 * kind of message the client tried to
								 * send.
								 */
#define MOUNT_VOLUME	 	1
#define DISMOUNT_VOLUME	 	2
#define FORMAT_VOLUME	 	3
#define READ_PAGE		 	4
#define WRITE_PAGE		 	5
#define ALLOC_PAGE		 	6
#define DEALLOC_PAGE	 	7
#define CHECK_PAGE		 	8
#define GET_UNIQUE		 	9
#define STAT_VOLUME			10		
#define SET_ROOT_ENTRY		11
#define GET_ROOT_ENTRY		12
#define REMOVE_ROOT_ENTRY	13
#define BEGIN_TRANS			14
#define COMMIT_TRANS		15
#define ABORT_TRANS			16
#define LOCK_PAGE			17
#define LOCK_FILE			18
#define CREATE_FILE			19
#define DELETE_FILE			20	
#define FIRST_PHYSICAL_PAGE	21	
#define LAST_PHYSICAL_PAGE	22	
#define NEIGHBOR_PAGE		23	
#define FIRST_LOGICAL_PAGE	24	
#define LAST_LOGICAL_PAGE	25	
#define MARK_FILE_PAGE		26	
#define RESET_RUSAGE		27	
#define GET_RUSAGE			28	
#define CREATE_SEQ_FILE		29
#define OPEN_SEQ_LOAD		30
#define OPEN_SEQ_SCAN		31
#define SCAN_NEXT_SEQ		32
#define LOAD_NEXT_SEQ		33
#define CLOSE_RESOURCE		34
#define TEST_NULL_RPC		35
#define TEST_PAGE_RPC		36

#define WRITE_LOG_PAGE	 	37
#define INIT_CLIENT			38
#define UNLOCK_PAGE			39
#define UNLOCK_FILE			40
#define QUERY_PAGE			41
#define SET_ANCHOR			42
#define SET_CLR				43
#define MON_DUMP			44

/*
 * administrative messages	
 */
#define ADMIN_CHECKPOINT	45
#define ADMIN_CHECKPOINTFREQ	46
#define ADMIN_SHUTSERVER	47
#define ADMIN_STATISTICS	48
#define ADMIN_DEBUG			49
	/* divided into these: */
#define 	ADMIN_DEBUG_CLIENT_LOG_OFF	500
#define 	ADMIN_DEBUG_SET_VAR			501

#define TEST_PAGE_SEND		50
#define SYNC_TRANS			51
#define FILE_NUMPAGES		52

/* 
 *	distributed commit messages
 */
#define ENTER2PC			53
#define COORD_PREPARE_TRANS	54
#define COORD_VOTE_REQ		55
#define SERVER_VOTE			56
#define CLIENT_COMMAND		57 /* ?? do we need this or use COMMIT/ABORT */
#define	CONTINUE_2PC		58
#define RECOVER_2PC			59

#define COORD_COMMAND		60
#define SERVER_ACK			61

#define ADD_VOLUME			62
#define RM_VOLUME			63

#define MAX_MSG_NUMBER		63	

#define SENT		0x1
#define RECEIVED	0x2

typedef struct {
	char  *name;
	short  type;
} MESSAGENAME;
extern MESSAGENAME	MsgNames[];

typedef struct msg_stats {
	int	sent [ MAX_MSG_NUMBER+1 ];
	int	received [ MAX_MSG_NUMBER+1 ];
	int	replied_ok [ MAX_MSG_NUMBER+1 ];
	int	replied_in_error [ MAX_MSG_NUMBER+1 ];
	int	no_reply_requested [ MAX_MSG_NUMBER+1 ];
	int	bytes_sent; 
	int	bytes_received;
	int	pages_sent; /* anything larger than MIN_PAGESIZE */
	int pages_received; /* anything larger than MIN_PAGESIZE */
	int	partial_pages_sent; /* anything smaller than MIN_PAGESIZE */
	int partial_pages_received; /* anything smaller than MIN_PAGESIZE */
} MESSAGESTATS;

extern MESSAGESTATS MsgStats;

/* END visible to user */

BEGIN_EXTERNC
	extern void printMessageStats(FILE *const , MESSAGESTATS *const m);
	extern void incPages(int, int, BOOL);
END_EXTERNC

#endif __MSGSTATS_H__
#endif /* _MSGSTATS_H_ */
