#ifndef _IO_H_
#define _IO_H_
#ifndef __IO_H__
#define __IO_H__
/*
 *   $RCSfile: io.h,v $  
 *   $Revision: 2.31 $  
 *   $Date: 1993/08/20 13:45:45 $      
 */ 


/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#include "ess.h"
#include "sysdefs.h"
#include "list.h"

/* BEGIN visible to user */
/*
 *	Typedef for volume id
 */
typedef TWO		VOLID;

/*
 *  macro for finding the index into the buffer list
 *  for the given size buffer
 *  (Really a bf macro but it's used on both cli & srvr)
 */
#define OFFSET(_page2size)      (_page2size - MIN_PAGE2SIZE)

/*
 *  define a force mark for the WAL protocol
 */
typedef FOUR	    			FORCEMARK;

/*
 * Short form of PID (no volume id)
 */
typedef FOUR	SHORTPID;


/*
 * Definition for page identifier (PID).
 * Ifdefs allow an application to be compiled with C or C++.
 */
#if defined(__cplusplus) || defined(c_plusplus)

class PID {
public:

#else 

typedef struct PID {

#endif 

    SHORTPID 	page;		/* page address */
    VOLID 		volid;		/* volume id */

#if defined(__cplusplus) || defined(c_plusplus)

	inline BOOL equalFunc(PID *other) const {
		return ((other->page == this->page) &&
			(other->volid == this->volid));
	};
	inline int hashFunc() const { return (int)(this->page); };

#if defined(SHELL_C)
    operator char*();	 /* used by tcl shell only */
    void fill(char* s);
#endif 

#endif 

#if defined(__cplusplus) || defined(c_plusplus)
}; /* class PID */
#else
} PID;
#endif /* defined(__cplusplus) || defined(c_plusplus) */

/*
 *	define the type of the unique field
 */
typedef UFOUR	UNIQUE;


/* 
 * Temporary typedef for file id.
 */
typedef struct FID {

    PID			pid;		/* the root page of the file	*/
	UNIQUE		unique;		/* unique bit for file			*/

} FID;

/* END visible to user */

/*
 * structure for linking things with PIDs in them,
 * particularly pools and hash tables.
 */
typedef struct PAGEHASHQ {

    LISTELEMENT     hashList;
    PID             hashPid;

} PAGEHASHQ;

/*
 * Macro to test for FID equality.
 */
#define FIDEQ(_fid1, _fid2)								\
		(((_fid1).pid.page  == (_fid2).pid.page) &&		\
		 ((_fid1).pid.volid == (_fid2).pid.volid) &&	\
		 ((_fid1).unique == (_fid2).unique))


/*
 *	define the null pid
 */
#define	NULLPID		((SHORTPID)(-1))	

/*
 *	define the log sequence number
 */
typedef struct	LSN {

	FOUR	wrapCount;
	FOUR	offset;

} LSN;

/* BEGIN visible to user */

/*
 *	define the log record counter
 */
typedef struct LRC {

	UFOUR	wrapCount;
	UFOUR	count;

} LRC;

/* END visible to user */

/* Both client and server BF modules define and use this: */
extern const	LRC        LrcNone;
#define LRC_NONE      { 0, 1 };
extern const	PID        PidNone;
#define PID_NONE      { NULLPID, (unsigned)-1 };

/*
 *  When a short list of lrc's is needed, this is the maximum
 *	size of the short list.
 */
#define LRC_SHORTLIST_SIZE 5

/*
 *  macros for operating on lrc's
 */

/*
 *  Increment and lrc and return a pointer to it
 */
#define INCREMENT_LRC(_lrc)                                         \
    ( ((_lrc)->count == 0xFFFFFFFF) ? ((_lrc)->wrapCount++,         \
                                       (_lrc)->count = 0    ) :     \
                                      ((_lrc)->count++), (_lrc))

/*
 * Micellaneous constants.
 */
#define	DEVNAMEMAX	100		/* max length of a device's physical name */
#define	NULLVOLID	(-1)	/* illegal Volume ID */

typedef char _VOLUMENAME_[DEVNAMEMAX];
class VOLUMENAME {
public:
	_VOLUMENAME_ name;
	inline BOOL equalFunc(VOLUMENAME *other) const  {
		/* strncmp == NULL ->same */
	   return  !(strncmp(other->name, this->name, sizeof(this->name))); 
	};
    inline int hashFunc() const { 
        int len = strlen(this->name) - 1;
        int tsum = this->name[0] + this->name[len/2] + this->name[len];
        return  tsum + len;  /* this will be masked by the caller */
    };
};

/* BEGIN visible to E interpreter */

/*
 *	typedefs for page sizes
 */
typedef UTWO		PAGE2SIZE;
#ifdef PAGESIZE
	/* defined in some sparc include files */
#	undef PAGESIZE
#endif /* PAGESIZE */
typedef UFOUR		PAGESIZE;

/* END visible to E interpreter */
/* BEGIN visible to user */

/*
 *	definitions for the buffer queues
 */
#define MIN_PAGE2SIZE		13 /*8K*/
#define MIN_PAGESIZE		(1 << MIN_PAGE2SIZE)
#define MAX_PAGE2SIZE		16
#define MAX_PAGESIZE		(1 << MAX_PAGE2SIZE)
#define MAX_BLOCK2_COUNT	(MAX_PAGE2SIZE - MIN_PAGE2SIZE)
#define MAX_BLOCK_COUNT		(MAX_PAGESIZE/MIN_PAGESIZE)

#define BITMAP_PAGE2SIZE	(MIN_PAGE2SIZE)
#define BITMAP_PAGESIZE		(1 << BITMAP_PAGE2SIZE)
#define BITMAP_USABLESIZE	(BITMAP_PAGESIZE - sizeof(LRC))

#define HEADER_PAGE2SIZE	(MIN_PAGE2SIZE)
#define HEADER_PAGESIZE		(MIN_PAGESIZE)

/* END visible to user */


/*
 *	macro for finding the length in smallest size blocks for
 *	the given buffer size
 */
#define BLOCK2COUNT(_page2size)	((_page2size) - MIN_PAGE2SIZE)
#define BLOCKCOUNT(_page2size)	(1 << BLOCK2COUNT(_page2size))
#define RAISETWO(_log2)			(1 << (_log2))
#define LOG2_OF_1K				10


/* 
 * Predefined system addresses.
 */
#define	HEADERADDR		0	/* location of the volume Header (a page #) */
#define ROOTPAGEADDR	1	/* address of rootPage						*/
#define BITMAPADDR		2	/* where the bitmap begins (a page #)		*/


/*
 * Page types.
 */
#define SHORT	0
#define LONG	1


/*
 *	usage of type
 */
#define PAGE_GENERIC	0x0
#define PAGE_FILEHDR	0x1		/* file btree root page		*/
#define PAGE_FILENODE	0x2		/* internal file btree page	*/
#define PAGE_SLOTTED	0x4		/* slotted page				*/
#define PAGE_LARGENODE	0x8		/* large obj btree node page*/
#define PAGE_LARGEDATA	0x10	/* large obj data page		*/
#define PAGE_LOG		0x20	/* page of log records		*/
#define PAGE_INDEX		0x40	/* btree index page			*/
#define PAGE_INDEXDESC	0x80	/* index descriptor page	*/

/*
 *	Hold page type information here
 */
typedef UONE PAGETYPE;


/*
 *	define the null lsn
 */
#define NULL_LSN	(0)


/*
 * Root page of the file directory.
 */
typedef struct DIRROOT { 

    char 	data[MIN_PAGESIZE];

} DIRROOT;


/*
 *	define a bitmap page
 */
typedef struct BITMAPPAGE {

	FOUR	word[BITMAP_USABLESIZE/BYTESPERWORD];
	LRC		lrc;

} BITMAPPAGE;


/* 
 * The definition of the VolDev table.
 * The following type structure definition is used both for the table
 * of mounted volumes (VolDev) and the first page of the volume.
 */
typedef struct VOLHDR {

	MAGIC		magic;					/* magic number of disk header		*/
    VOLID		volid;					/* Volume ID						*/
    FOUR		numPages;				/* total # of pages on the volume	*/
	FOUR		pagesPerTrack;			/* number of pages on a track		*/
    FOUR		numCylinders;			/* number of cylinders in volume	*/
    FOUR		tracksPerCylinder;		/* number of tracks per cylinder	*/	
    FOUR		bitmapPages;			/* number of pages occupied by bitmap*/
    FOUR		numFreePages;			/* number of free pages				*/
	SHORTPID	freeBitmapAddr;			/* page the free bitmap starts at	*/
	SHORTPID	fileBitmapAddr;			/* page the file bitmap starts at	*/		SHORTPID	slotBitmapAddr;			/* page the slot bitmap starts at	*/	
	SHORTPID	uniqueArrayAddr;		/* page the unique word starts at	*/	
	SHORTPID	logFileAddr;			/* starting block of the log file	*/
	SHORTPID	logControlAddr;			/* address of the log control block	*/
	PAGE2SIZE	logFileBlock2size;		/* size of a block in the log file	*/
	FOUR		numLogFileBlocks;		/* size of the log file in blocks	*/
	LSN			dismountEndOfLog;		/* end of log LSN at dismount		*/
	LRC			lrc;					/* header lrc						*/
	/* for compatibility between server and volume */
	PAGE2SIZE	slottedPage2size;
	PAGE2SIZE	lgPage2size;
	PAGE2SIZE	lgDataPage2size;
	PAGE2SIZE	btreePage2size;
	PAGE2SIZE	indexDescPage2size;
	PAGE2SIZE	minPage2size;
	FOUR		version;				

	/* NB: Change the FORMAT_VERSION to indicate incompatibilities
	 * between old volume & new server 
	 */
#define FORMAT_VERSION	3 /* changed properties */
						  /* version 1 added page size compatibility */

	FLAGS		properties;
/* BEGIN visible to user */
#define			VOL_PROPERTIES	0x5 /* all the flags that have any meaning below  */
#define			VOLPROP_TEMP	0x1 /* cannot be temp and log */
#define			VOLPROP_UNUSED	0x2 /* RAWDEV is not a permanent property */
#define			VOLPROP_LOG		0x4 /* is a log (if not a log, its a data volume) */
/* END visible to user */

} VOLHDR;


/*
 *	the magic number of a volume header
 *  Keep the old one for backward compatibility.
 */
#define OLD_VOLUME_MAGIC	0xD15a9e12
#define VOLUME_MAGIC	0x9e13D15b

/* BEGIN visible to user */
/*
 *	define  the maximum that the root name can be
 */
#define MAX_ROOTNAME_SIZE	32
#define MAX_ROOTDATA_SIZE	32
/* END visible to user */


/*
 *	each entry in the root page looks like this
 */
typedef struct ROOTENTRY {

	char	name[MAX_ROOTNAME_SIZE];
	char	data[MAX_ROOTDATA_SIZE];
	FOUR	dataSize;
	ONE		flags;
	ONE		index;

} ROOTENTRY;


/*
 *	define the used and free flags
 */
#define ROOT_FREE	0x0
#define ROOT_USED	0x1


/*
 *	define the number of entries on the root page
 */
#define MAX_ROOT_ENTRIES		((MIN_PAGESIZE - sizeof(FOUR))/sizeof(ROOTENTRY))


/*
 *	define a root page
 */
typedef struct ROOTPAGE	{

	ROOTENTRY	entry[MAX_ROOT_ENTRIES];
	LRC		lrc;

} ROOTPAGE;


/*
 *	define the maximum pid list length for alloc and dealloc
 */
#define MAX_PIDLIST_SIZE		50

#endif __IO_H__
#endif /* _IO_H_ */
