#ifndef _ESS_H_
#define _ESS_H_
#ifndef __ESS_H__
#define __ESS_H__

/*
 *   $RCSfile: ess.h,v $  
 *   $Revision: 2.28 $  
 *   $Date: 1993/04/21 17:21:11 $
 */ 


/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 * ess.h
 * defines, typedefs, etc. used by all of ess.
 */

/* BEGIN visible to user */

/*
 *	Turn on function prototypes for these compilers
 */
#if defined(_AIX) || defined(mips) || defined(__cplusplus) || defined(c_plusplus) || defined(__GNUC__)
#	define PROTO(_parms) _parms 
#else
	/*
	 *	Turn it off for everything else
	 */
#	define PROTO(_parms) ()
#endif

#ifdef __cplusplus
#define BEGIN_EXTERNC extern "C" {
#define END_EXTERNC }
#else
#define BEGIN_EXTERNC 
#define END_EXTERNC 
#endif __cplusplus

/*
 * Allow things to compile with c and c++ without having to 
 * ifdef-out each use of "const"
 */
#ifndef __cplusplus
#define const
#endif

/*
 * Some compilers do not know about volatile, including ATT C++.
 * G++ seems to know about it.
 * In order to avoid all sorts of warnings about the use
 * of volatile in places like <sys/smp_lock.h> (for ultrix),
 * and serverlib/include/queues.h.o, we define volatile out of
 * existence for ATT C++.
 */
#if defined(__cplusplus) && !defined(__GNUC__)
#define volatile
#endif


/*
 * Boolean values.
 */
typedef char BOOL;

#ifndef TRUE
#define TRUE	(1)
#endif
#ifndef FALSE
#define FALSE	(0)
#endif

/*
 *	define some values for general macro expansion
 */
#define IS_ENABLED		==1)
#define IS_DISABLED		==0)
#define ENABLED			(1
#define DISABLED		(0

/*
 *	Universal constant for flags field
 */
#define NOFLAGS			((FLAGS) 0)


/*
 * Machine dependent constants.
 */
#define	BYTESPERWORD	(sizeof(int))
#ifndef BITSPERBYTE
#	define	BITSPERBYTE		8
#endif
#define	BITSPERWORD		(BITSPERBYTE * BYTESPERWORD)


/*
 * Special "no error" error return.
 */
#define	esmNOERROR	0		/* non-error "error" code	*/
#define esmFAILURE	-1		/* standard failure call	*/


/*
 * Invalid pointer values.
 */
#ifndef NULL
#define	NULL		(VOID *)0	/* invalid memory address. Don't use this for int types; use ZERO */
#endif

#define	ZERO		0

#define	NIL			-1		/* invalid integer index */


/*
 * Typedefs used all over.
 */
typedef char	ONE;			/* 1 byte */
typedef short	TWO;			/* 2 bytes */
typedef long	FOUR;			/* 4 bytes */


typedef void	(*PFV)();		/* pointer to void function		*/
typedef int		(*PFI)();		/* pointer to integer function		*/
typedef char	*(*PFCP)();		/* pointer to char pointer function */

typedef unsigned char	UONE;	/* 1 byte */
typedef unsigned short	UTWO;	/* 2 bytes */
typedef unsigned long	UFOUR;	/* 4 bytes */

#ifndef _AIX
typedef unsigned long	ulong;
#endif

typedef unsigned int	FLAGS;
typedef unsigned long	MAGIC;
typedef unsigned short	SHORT_MAGIC;

/*
 * These typedefs go here because they are used all over the place.
 * They are variants of flags but are given different types to
 * help avoid conflicts.
 */
typedef	FLAGS	BFFLAGS;
typedef	FLAGS	SCANFLAGS;
typedef	FLAGS	SCANTYPE;
typedef	FLAGS	NEIGHBORFLAGS;


/*
 * Version history graph node id.
 */
typedef FOUR VHGNODEID;

/*
 *  define a type for a slotted page slot
 */
typedef TWO     SLOTINDEX;

/*
 * Macro for checking errors.
 */
#define	CHECKERROR(a) 							\
	    if ((int)(a) < smNOERROR) return ((int)(a))

/* END visible to user */

/*
 * Macros for comparisions.
 */
#ifndef MIN
#define	MIN(x,y)							\
	    ((x) < (y) ? (x) : (y))
#endif  MIN

#ifndef MAX
#define	MAX(x,y)							\
	    ((x) > (y) ? (x) : (y))
#endif  MAX

#ifndef ABS
#define	ABS(x)							\
	    ((x) > 0 ? (x) : (-x))
#endif 	ABS


/* BEGIN visible to user */

/*
 *	Set object alignment to 8 byte bountries.
 *
 *	The only valid values are 8 and 4.  Adding new values
 *	requires a change to include/object.h.
 */
#define ALIGNON 8
#define ALIGNON1 (ALIGNON-1)

/*
 *	the object size align macro
 *
 *	This macro aligns object sizes to ALIGNON boundries.
 *	Note that zero length objects are also rounded up.
 */
#define ALIGNSIZE(_size)								\
	( ((_size) == 0) ? ALIGNON :( (_size) + ALIGNON1 ) & ~ALIGNON1)


/* END visible to user */

/*
 *	the align macro for general power of two alignment
 */
#define ALIGN(_value, _target)						\
														\
	(((_value) + ((_target) - 1)) & (~((_target) - 1)))

/*
 * The following kludge is simply so that we can tell which
 * .o files were compiled with debug and which without (by using nm(1)).
 * Both of these chars are defined in libcommon.a
 */
#ifdef DEBUG
extern char debug_is_on;
#else DEBUG
extern char debug_is_off;
#endif DEBUG

typedef struct hostent		HOSTENT;
typedef struct sockaddr_in	SOCKADDR;
typedef struct servent		SERVENT;
typedef struct timeval		TIMEVAL;

/*
 *	SM_FREE_PTR is to be used instead of free().
 *  GET should be used wherever it works.
 */
#define SM_FREE_PTR(_ptr) 		\
	if ((_ptr) != NULL) { 		\
		free((char*)(_ptr));	\
		(_ptr) = NULL; 			\
	}

#define GET(result, TYPE, amount) \
	if ((result = (TYPE *) malloc(sizeof(TYPE)*amount)) == NULL)	{\
		SM_ERROR(TYPE_SYS, esmMALLOCFAILED);\
		return esmFAILURE;\
	}


/* Macro for handling errors:
 * Each function has a label FailureReturn, where the 
 * failure case is treated: malloc-ed stuff is 
 * freed, pages are unfixed,  and esmFAILURE is returned.
 */
#ifdef DEBUG

static int				FailureLineNumber; /* uninitialized */
#define 	FAIL		FailureLineNumber = __LINE__; goto FailureReturn;

BEGIN_EXTERNC
	int FakeFailure(int);
END_EXTERNC
/* for testing only */
#define FAKEFAIL(e) if(FakeFailure(e)) { return esmFAILURE; }

#else

#define 	FAIL		goto FailureReturn;
#define 	FAKEFAIL(x) 

#endif DEBUG

/* brain-damaged cfront can't handle anything but trivial inline funcs, so 
 * we'll just make none of these things inline for cfront.
 */
#if defined(__GNUC__) && !defined(DEBUG)
#define INLINE inline
#else
#define INLINE 
#endif

#endif /* __ESS_H__ */
#endif /* _ESS_H_ */
