#ifndef _LHSTACK_H_
#define _LHSTACK_H_
/*
 *	$RCSfile: LHSTACK.h,v $
 *	$Revision: 1.3 $
 *	$Date: 1992/11/27 16:45:39 $
 */
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifndef LHSTACK_H
#define LHSTACK_H

const	MAXHEIGHT =	20;

class LHashStack  {
		int 		cnt;					// # of valid entries in descPtr[]
		BUFGROUP*	bufGroup;				// buffer group associated w. stack
		PageDesc	descPtr[MAXHEIGHT];		// pages in stack
	public:
		LHashStack(BUFGROUP* bg)	{ cnt = 0; bufGroup = bg; }
		~LHashStack();
		
		//
		//  Return bufGroup
		//
		BUFGROUP*	BufGroup()	{	return bufGroup;	}

		//
		//	Read page 'pid' in 'lockMode' and push it onto the stack
		//
		int ReadNPush(PID& const pid, LOCKMODE lm);
		
		//
		//	Unlock/Unfix all entries
		//
		void ReleaseAll()	{
							  	for (int i = cnt-1; i>= 0; i--)  {
								  	  if ((GROUPLINK*)descPtr[i])
									  	  descPtr[i].UnfixUnlock();
									  }
							}
		

		//
		//	Push/Pop a page to/from stack
		//
		PageDesc	Pop()			{ ASSERT1(cnt > 0); return descPtr[--cnt]; }
		void		Push(PageDesc pd)	{ 
									  ASSERT1(cnt < MAXHEIGHT-1); 
									  descPtr[cnt++] = pd; 
									}

		//
		//	pop everything in the stack
		//
		void		Empty()			{ ASSERT1(cnt > 0); cnt = 0; }
		
		//
		//	Pop a page and unfix/unlock it
		//
		void		DiscardTop();

		//
		//	Get the bottom entry (header page in the chain)
		//
		PageDesc&	Bottom()		{ ASSERT1(cnt > 0);	return descPtr[0];	}

		//
		//	Return a reference to the stack top
		//
		PageDesc&	Top()			{ ASSERT1(cnt > 0); return descPtr[cnt-1]; }
		
		//
		//	Get the entry with specified PID
		//
		int GetEntry(PID& const pageId,  PageDesc& retDesc);	 
		
		//
		//	Get the previous entry which points to the page with PID
		//
		int GetPrevEntry(PID& const pageId,  PageDesc& retDesc);	 
		
		//
		//	Discard the entry with specified PID and unfix/unlock it
		//
		void	DiscardEntry(PID& const pageId);	 
		
		//
		//	Discard the entry with specified PID and unfix/unlock it
		//
		void	DirtyAll();	 
		
		//
		//	Return current stack size
		//
		int			NumEntries()	{ return cnt; }
		
		//
		//	Print the stack (for debugging)
		//
		void Print();
		};

#endif // LHSTACK_H
#endif /* _LHSTACK_H_ */
