#ifndef __HASHTABLE_H__
#define __HASHTABLE_H__

/*
 *   $RCSfile: HashTable.h,v $  
 *   $Revision: 1.3 $  
 *   $Date: 1993/04/21 17:20:38 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifndef __cplusplus
	This file MUST be compiled with C++ !
#endif


#include "sysdefs.h"
#include "ess.h"
#include "checking.h"
#include "list.h"
#include "trace.h"
#include "error.h"
#include "ForEach.h"


template <class HASHTKEY,class CONTENTS>
class HashTable {
private:

	LIST		*buckets;
	int			numBuckets;	/* # slots */
#ifdef DEBUG
	FOREACHFUNC	dumpFunc;
#endif DEBUG

	int			numEmptyBuckets;
	int			bucketSizeHighWater; 
	unsigned int	mask;
	char		name[32];
	int			unique; /* id of resource */
	int			spaceRequirement; /* in number of bytes */

	/* 
	 * These member funcs have to be defined for the HASHTKEY class:
	 * int hashFunc();
	 * BOOL equalFunc( HASHTKEY *);
	 * These member funcs have to be defined for the CONTENTS class:
	 * Dump(FILE *)
	 * LISTELEMENT *listlocation(int);
	 * HASHTKEY *keylocation(int);
	*/
public:
	int			numItems; 	/* in the table */
	HashTable( char *, int, int );
	~HashTable() ;
	CONTENTS 	*Find ( const HASHTKEY *) ; 
	void	Insert( CONTENTS 	*) ;
	void	Remove( CONTENTS *) ;

#ifndef __GNUC__
	void	ForEach(  int,	FOREACHFUNC, ... ) ;
#else
	void	ForEach(  int,	... ) ;
#endif

	void	Stats( FILE * );
	char 	*Name() { return &name[0]; };
#ifdef DEBUG
	void	Dump( FILE *,  int, char *);
#endif DEBUG
};

#ifdef  __GNUC__
#include "HashTable.c"
#endif  __GNUC__

#endif __HASHTABLE_H__


