.TH Source 1 
.SH NAME
Source \- browsing the Exodus Storage Manager source
.SH DESCRIPTION
This document briefly describes the arrangement of the
Storage Manager source files and directories.
.SH "INTRODUCTION"
.PP
The Exodus Storage Manager (SM) comprises
applications, clients, and a server.
An application is code written by a person who wishes
to use the SM.
A client is a portion of the SM code that is linked
with the application.
The client and application make all decisions regarding
the management of data and the organization of data into
.B objects,
and the layout of
objects on 
.B pages
and in 
.B files.
Clients request locks and pages, create indices, 
initiate transactions, and log activity, among other things.
The server manages pages, locks, transactions, 
disk I/O, concurrency, and data recovery.
The server performs disk I/O in parallel by 
delegating the task to subordinate processes.
.PP
The source code is divided into 
.B modules
that roughly correspond to the divisions
of labor described in the previous paragraph.
First, the source is divided into the following directories:
.IP "client" 5
Source code and object files that are only in the client.
.IP "common" 5
Source code and object files that are linked into both the
client and the server.
.IP "config" 5
Configuration files for the client and server, containing compiled-in
configuration information.
.IP "include" 5
Source code header files that are common to the client and server.
.IP "server" 5
Main() for the server process.
The server process is linked in this directory.
.IP "serverlib" 5
The majority of the code for the server is here.
These objects are also linked into the volume formatter.
.IP "diskproc" 5
The source and objects for the disk I/O processes.
.IP "formatvolume" 5
Source and objects for the volume formatter, 
.B formatvol.
Formatvol links in the server library also.
.IP "admin" 5
Miscellaneous administrative utility programs.
.SH "MODULES"
.PP
The client and server are further divided into modules.
The modules correspond to directories in client/,
in serverlib/, and in many cases, in both.
In most cases,
the client and server perform different tasks
under the aegis of the same module.
For example,
in the 
.B lm
(lock manager)
module, the client requests and caches locks,
while the server performs the lock management, including deadlock detection,
and it denies or grants the client's request.
.IP "bf/" 5
Buffers.
(Both.)
Both the client and server contain buffer pools.
These modules manage page caching in the buffer pools.
.IP "bm/, bitmap/" 5
Bitmaps.
(Server only.)
The server has bitmaps to determine what disk
pages are in use.  The module 
.B bitmap
contains low-level routines used by 
.B bm.
.IP "client/sm/" 5
Storage Manager interface.
(Client only.)
This module implements the application's interface to the SM.
.IP "client/smint/" 5
(Client only.)
This module contains functions called from functions in ../sm.
.IP "cl/" 5
Client interface.
(Server only.)
This module implements the server's interface to the client.
.IP "clog/, log/" 5
Logging.
Both the client and server log their activities so that
recovery can be performed.
.B clog/
is the client's logging module.
.B log/
is the server's logging module.
.IP "fi/" 5
File operations.
(Both.)
This module contains routines for creating
and manipulating files (collections of objects).
.IP "lg/" 5
Large objects.
(Both.)
In the client, this module contains code that pertains
to large objects (objects larger than 4K bytes).
In the server, this module is code that is needed to 
recover (redo or undo transactions on) large objects.
.IP "lm/" 5
Lock manager.
(Both.)
In the client, this includes requesting and freeing locks.
In the server, this includes creating and  destroying locks,
converting locks, and detecting deadlocks due to granting of
locks.
.IP "trans/" 5
Transaction manager.
(Both.)
The client initiates transaction operations (begin, commit, abort)
by passing the requests along to the server.
The
.B server/trans
module is the entire transaction manager.
.IP "msg/" 5
Communication between client and server.
(Both.)
.IP "io/" 5
Page I/O.
.IP "btree/" 5
Indices.
(Both.)
There is one copy of the source (kept in client/btree),
but the objects differ between the server and the client, having 
been compiled with different C preprocessor flags.
.IP "lhash/" 5
Linear Hashing-based indices.
(Both.)
There is one copy of the source (kept in client/lhash),
but the objects differ between the server and the client, having 
been compiled with different C preprocessor flags.
.IP "recover/, analyze/, redo/, undo/" 5
Recovery.
(Server only.)
The modules
.B analyze/,
.B redo/,
and
.B undo/
are passes 1, 2, and 3 of recovery,
which is performed upon initialization of the server process.
.IP "common/, util/, resource/" 5
Glue.
(Server only.)
These modules contain code for miscellaneous
routines needed in the server.
.IP "thread/, sync/" 5
Coroutine support.
(Server only.)
The server performs many tasks in parallel.
.B
threads/
implements lightweight threads,
and manages synchronization of the activities of the various
threads. 
Threads are implemented with setjmp() and longjmp(), and
do not offer preemptive scheduling.
.IP "disk/" 5
Communication between the server process and the disk I/O processes.
(Server only.)
.IP "mr/" 5
Terminal interface and
media recovery (media recovery is not implemented).
(Server only.)
.SH MAKEFILES
.PP
Myriad makefiles are used to make the storage manager.
In every directory is a file called
.B Makefile,
which includes various files,
.B "makefile.*"
as need be.
.SH "SEE ALSO"
Makefile \- making an Exodus Storage Manager
