/*
    NAME
	 strcat, strncat, strcmp, strncmp, strcasecmp, strncasecmp,
	 strcpy, strncpy, strlen, index, rindex, strins, strdel, 
	 strload, strdump, strprint, strread - string operations

    SYNOPSIS
	 #include <dbStrings.h>

*/

#ifndef DBSTRINGS_H
#define DBSTRINGS_H
#include <E/sm_if.h>
#include <libc.h>
#include <strings.h>
#include <stdio.h>

dbchar	*	strcat(dbchar * s, const dbchar * append);
dbchar	*	strncat(dbchar * s, const dbchar * append, int count);
int		strcmp(const dbchar * s1, const dbchar * s2);
int		strncmp(const dbchar * s1, const dbchar * s2, int count);
int		strcasecmp(const dbchar * s1, const dbchar * s2);
int		strncasecmp(const dbchar * s1, const dbchar * s2, int count);
dbchar	*	strcpy(dbchar * to, const dbchar * from);
dbchar	*	strncpy(dbchar * to, const dbchar * from, int count);
int		strlen(const dbchar * s);
dbchar	*	index(const dbchar * s, int c);
dbchar	*	rindex(const dbchar * s, int c);

dbchar	*	strins( dbchar * s, const dbchar * insert, int length = -1 );
dbchar	*	strdel( dbchar * s, int length  = -1 );

int		strload( dbchar * s, FILE * f, int n = -1 );
int		strdump( const dbchar * s, FILE * f, int n = -1 );
int	strread( dbchar * s ); // { return strload( s, stdin, -1 ); }
int	strprint( const dbchar * s ); // { return strdump( s, stdout, -1 ); }

void		bcopy(const dbvoid *, dbvoid *, int );
int		bcmp( const dbvoid *, const dbvoid *, int );
void		bzero( dbvoid *, int, int = 0 );
int		bload( dbvoid *, FILE *, int );
int		bdump( const dbvoid *, FILE *, int );
void		bins( dbvoid*, const dbvoid *, int );
void		bdel( dbvoid *, int );
void		bpos( const dbvoid *, OID&, int&, int& );

#endif
