#ifndef _E_FILE_H
#define _E_FILE_H
#include <E/sm_if.h>
// #include <E/iterator.h>
/***********************************************************************

    file.h

***********************************************************************/

/*
 * For E files
 */
dbstruct dbFID {
	dbchar  space[sizeof(FID)];
};

union fidu {
	FID     fid;
	dbFID   dbfid;
};

dbclass file
{
    dbFID	f;	// pointer to the file
public:
    file();
    file(VOLID vol = __Evolid);
    ~file();
    dbvoid*  new_obj(int, dbvoid* = 0, int=0);
    void     del_obj(dbvoid*);
    // ITER_DECL(dbvoid*, scan(OBJHDR * = 0));
    dbvoid*  get_first(OBJHDR * = 0);
    dbvoid*  get_last(OBJHDR * = 0);
    dbvoid*  get_next(dbvoid*, OBJHDR * = 0);
    dbvoid*  get_prev(dbvoid*, OBJHDR * = 0);
    friend class file_scan;
}; /* file */


/***********************************************************************

    collection.h

***********************************************************************/


template <dbclass T> dbclass collection:public file
{

public:


/*
#if  0
    ITER_DEF(T *,scan());
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file_scan::next(&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
    END_ITER_DEF
#endif 
*/
    collection(VOLID vol= __Evolid): file(vol) {};
    // due to a bug in gcc2, (T *) casts don't work if the template
    // is instanciated with a nested class name, so interpose a typedef.
    // typedef T * TPT;
    T*		get_first() 
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file::get_first(&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
    T*		get_last()
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file::get_last(&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
    T*		get_next(T* tpt)
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file::get_next(tpt,&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
    T*		get_prev(T* tpt)
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file::get_prev(tpt,&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
}; /* collection[T] */

class file_scan // file scan iterator control struct
{ // NOTE! this must match the decl of scan_rec in _E_interp.c.
	char * scan_pt;
	void * udpt;
	void * hpt;
	int eof_flag;
	short tag;
	FID fid;

  public:
  file_scan(file &); // initialization
  dbvoid * next(OBJHDR * = 0);
  int empty() { return eof_flag; } ;
  ~file_scan();
};

template <dbclass T> class collection_scan : public file_scan
{
  public:
  collection_scan( collection<T> & base_collection): file_scan(base_collection) {};
  T * next()
    {  OBJHDR obh; dbchar * rpt = (dbchar *)file_scan::next(&obh);
      if (obh.tag)
	return (T *) (rpt + obh.tag);
      else
	return (T *) rpt;
    }
};    


dbvoid * operator new(unsigned int sz,file  & acol);
// near version 
dbvoid * operator new(unsigned int sz,file  & acol,dbvoid *);

#endif
