#ifndef _TypedBtree_h
#define _TypedBtree_h
#include <E/BtreeIndex.h>
// btree index with typed pointer fields
template <class keyt,dbclass eltt> dbclass TypedBtreeIndex 
	: public BtreeIndex<keyt>
{
public:
	TypedBtreeIndex(BOOL uniqf=0): BtreeIndex<keyt> ( uniqf) {};
	insert(keyt key,eltt * eltpt) 
	{ return BtreeIndex<keyt>::insert(key,eltpt);};
	remove(keyt key,eltt * eltpt) 
	{ return BtreeIndex<keyt>::remove(key,eltpt);};
	// all other ops inherited
};
// typed case of BtreeRetrieve iteratore
template <class keyt,dbclass eltt> class TypedBtreeRetrieve
	: public BtreeRetrieve<keyt>
{
	// single point retrieve
public:
	eltt * cur_pt; // override the index_retrieve_base cur_elem
	TypedBtreeRetrieve( TypedBtreeIndex<keyt,eltt>& this_index,keyt test)
		: BtreeRetrieve<keyt> (this_index, test) {};
	TypedBtreeRetrieve(TypedBtreeIndex<keyt,eltt> &this_index)   // no key; set later.
		: BtreeRetrieve<keyt> (this_index){};
	TypedBtreeRetrieve(TypedBtreeIndex<keyt,eltt>& this_index,keyt lb, keyt up, int exl=0)
		: BtreeRetrieve<keyt> (this_index, lb,  up,  exl){};
	// for the next operation, we need to copy the void pointer
	// into a typed locaton
	// other operations are inherited.
	void
	next() 
	{ 	index_retrieve_base::next(); 
		cur_pt = (eltt *)index_retrieve_base::cur_elem; 	
	}
};
#endif
