// window.h : basic include file for the Grafix package
// the "GNU Public Lincense" policy applies to all programs of this package
// (c) Wolfgang Koehler, wolf@first.gmd.de, Dec. 1994
//     Kiefernring 15
//     14478 Potsdam, Germany
//     0331-863238

#include <X11/Xlib.h>
// #include "X11/Xutil.h"
#include <X11/keysym.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define FALSE 0
#define TRUE 1

#define MAX(x,y) ((x) > (y) ? (x) : (y))
#define MIN(x,y) ((x) < (y) ? (x) : (y))

#define SimpleType 0
#define PulldownType 1

extern void error(char*);
char * ext_string(char * str); // Anhaengen von 2 * 2 space an str

GC CreateGC(unsigned long mask, XGCValues * gcv);

void set_color(int color); // set color for gc_copy 
int alloc_color(unsigned red, unsigned green, unsigned blue);
int alloc_named_color(char *colname);

// zeichnet pseudo-3D-Rahmen, mode = up3d, flat3d (background pix), down3d
void rect3d(Window Win, int mode, short x, short y, short w, short h);
void tri3d_s(Window Win, int mode, short x, short y, short w, short h);

struct point { int x; int y; };

extern Colormap def_cmap;
extern Display * display;
extern int screen;
extern GC gc_copy, gc_xor, gc_clear,gc_rubber; // some often used gcs
extern Cursor watch_cursor; // for long redraw methods eg. in coordwindows
extern XFontStruct * fixed_fn;
extern unsigned depth, black, white;

void handle_event(XEvent &event);

class main_window;
class window;
// extern window root_window;

struct win_list { // struct to manage a child list of any window
  window * child; 
  int x,y;
  struct win_list * next; 
};

class text_popup;

class window {

protected:
  int border_width;
  GC gc,text_gc;
  text_popup * help; // ggf. help popup
  window *parentw;   // nur fuer destruktoren wichtig
  long selection_mask; // default mask fuer SelectInput
  Bool hidden;    // if true not realize the window 
public:  
  main_window * mainw; // the main window of this window, direct child of root 
  int width, height;
  int CB_info;   // toggle debug infos on callbacks in this Window
  Window Win;
  int type;      // to distinguish simple <-> pulldown

  win_list * children;        // chained List of children
 
  window(char * DISP = NULL); // constructor for root window
  window(window & parent,
	 int w = 0, int h = 0, int x = 0, int y = 0, int bw = 1);
  
  virtual ~window();  // virtual destructor
  
  virtual void draw_interior() { } 
  // is called from Map to draw an image 
  virtual void Map();
  void Unmap() ;
  void set_backing_store();  // set backing_store = WhenMapped
  void set_save_under();     // save covered region when mapped

  void Realize();
  // Realize the whole Window tree from this root
  void RealizeChildren();

  virtual void clear();
  virtual int eff_width() { return width; } // effektive Breite abzgl pictures

  virtual void DrawString(int x, int y, char * string);

  // place a string with font (fixed_fn) at x,y (0 = centered)
  void PlaceText(char * string,int x = 0, int y = 0,
		   XFontStruct * fn = fixed_fn);
  virtual void line(int x0, int y0, int x1, int y1);
  virtual void DrawPoint(int x, int y);

  add_help(char * WMName,char * text[]);
  
  virtual void action(char*,char*) {} // action fuer Windows, die von 
                                      // radio_button - BPress-CBs
                                      // aus neu gestaltet werden sollen
  void WatchCursor(); // temporaeres Setzen, in der event-loop rueckgesetzt
  virtual void redraw() {}
  virtual void resize(int, int);
protected:  
  virtual void BPress_CB(XButtonEvent) {} 
  virtual void BPress_1_CB(XButtonEvent); 
  virtual void BPress_3_CB(XButtonEvent);
  virtual void BRelease_CB(XButtonEvent) {} 
  virtual void Enter_CB(XCrossingEvent) {}
  virtual void Leave_CB(XCrossingEvent) {}
  virtual void Motion_CB(XMotionEvent) {} // pointer movements
  virtual void Expose_CB(XExposeEvent);
  virtual void KeyPress_CB(XKeyEvent) {}
  virtual void Configure_CB(XConfigureEvent ev) {} // nur fuer main_windows
  virtual void add_child(window *) {} // um die parent-Geometrie anzupassen

public:  
  void CallBack(XEvent &event) ;
};

// for special applications : in the main_loop use polling 
extern Bool polling_mode; // use polling instead of XNextEvent
extern void (*poll_handler)(); // called after each polling 

class main_window : public window {
public: 
  int exit_flag; // used in main_loop to break it
  main_window(char * Name, int w, int h);
  ~main_window();
  void do_popup(int x, int y); // Realize at absolute x,y-coords
  virtual void Configure_CB(XConfigureEvent ev);
  void set_icon(char ibits[], int iwidth, int iheight);
  void main_loop(); 
};

// A window that stores its content in a Pixmap, to enable a quick Expose
// Each drawing operation is done to Pixmap, Map & Expose copy pix -> Win
// 
class pixmap_window : public window {
protected:
  Pixmap pix;  // to store the image and re-map in expose events
public:
  pixmap_window(window & parent, int w = 0, int h = 0, 
	       int x = 0, int y = 0, int bw = 1);
  virtual ~pixmap_window();
  virtual void clear();
  virtual void Map(); // copy pix -> Win
  virtual void DrawString(int x, int y, char * string);
  virtual void line(int x0, int y0, int x1, int y1);
  virtual void DrawPoint(int x, int y);
  virtual void Expose_CB(XExposeEvent ev); 
  virtual void draw_interior() = 0;
  virtual void redraw() { clear(); Map(); }
  virtual void resize(int,int);
};

// very simple window to place text
class text_win : public window {
char *text;
public:
  text_win(window &parent, char *text, int w,int h, int x, int y, int bw = 0) :
    window(parent,w,h,x,y,bw), text(text) {}
  virtual void redraw() { PlaceText(text);  }
};

// manage position of children
class container {
  int min_w, max_w; // minimum & maximum width for children
public:
  int xp, yp; // place position for next child, is updated from children
  int getw(int w) { return ((w > min_w) ? ((w > max_w) ? max_w : w) : min_w) ;}
  container(int minw, int maxw) : min_w(minw), max_w(maxw) 
  { xp = yp = 0; }
  };

class menu_bar : public window, public container {
public:
  menu_bar(window & parent, int w, int h, int x = 0, int y = 0, 
	   int minw = 0, int maxw = 1000, int bw = 1)
  : window(parent,w,h,x,y,bw), container(minw,maxw) {}
  virtual void add_child(window * child) { xp += getw(child->width); };
  };


class text_popup : public main_window  {
  char ** pop_text;
public: 
  text_popup(char * WMName, int w, int h, char *text[]); 
  void Expose_CB(XExposeEvent ev);
};

// Konstanten zur 3d Darstellung
#define down3d 0 
#define up3d   1 
#define flat3d 2

// a window with pseudo-3d frames
class plate : public window { 
  int mode3d;
public:
  plate(window & parent, int w, int h, int x = 0, int y = 0, int mode3d = up3d)
    : window(parent, w, h, x, y, 0), mode3d(mode3d) { }
  virtual void redraw();  
protected:  
  void frame3d(int mode) { rect3d(Win, mode, 0, 0, width-1, height-1); }
  virtual void default_frame() { frame3d(mode3d); }
};

class button : public plate {
  //  parent is a pulldown menu -> other dynamic frame mode
  int in_pulldown;
protected:
  // die Breite des strings fuer menu_bar (bei auto-placement in container)
  int Nwidth(char *str) { return 6*strlen(str) + 6; }
public:
  char * Name;
  void add_help(char **help_text); // replaces window::add_help
  void init_button(window *parent);
  button (window & parent, char * Name, int w, int h, 
	  int x = 0, int y = 0) :
  plate (parent, w, h, x, y), Name(Name) { init_button(&parent); }

  button (window & parent, char * Name, char ** help_text, int w, int h,
	  int x = 0, int y = 0) : plate (parent, w, h, x, y), Name(Name) 
    { add_help(help_text); init_button(&parent); }
  
  // autosizing buttons
  button (menu_bar & parent, char * Name) :
    Name(Name), plate (parent, parent.getw(Nwidth(Name)),  
                       parent.height, parent.xp, parent.yp) 
    { init_button(&parent); }
  virtual ~button();
  virtual void default_frame() { frame3d(in_pulldown ? flat3d : up3d);  }
  void enter_frame() { frame3d(in_pulldown ? up3d : flat3d); }
 
protected: 
  virtual void Enter_CB(XCrossingEvent ev) { enter_frame(); }
  virtual void Leave_CB(XCrossingEvent ev) { default_frame(); }
  virtual void BPress_CB(XButtonEvent ev) { frame3d(down3d); }

  virtual void BPress_1_CB(XButtonEvent ev) { 
    // printf("button press '%s' %d \n", Name, ev.button); 
  }
  virtual void BRelease_1_action() {} // hook for callbacks with Button1
  virtual void BRelease_CB(XButtonEvent ev) { 
    if (ev.state & Button1Mask) { BRelease_1_action(); default_frame(); }
  }
  virtual void redraw();
};

//                 ##### delete_button #####
// class zum geordneten delete eines Windows (und aller child-windows)
// Achtung: der button selbst darf nach dem Ausloesen keine grafischen 
// Operationen mehr ausfuehren ! 
// Weitere callbacks werden abgefangen, indem der thisW-pointer auf NULL gesetzt
// wird 
class delete_button : public button { 
window * to_del;
public: 
  delete_button(window & parent, window * to_del, int w, int h, int x, int y): 
    button(parent, "delete", w, h, x, y), to_del(to_del) {}
private:
  void BPress_1_CB(XButtonEvent ev) { to_del->Unmap(); delete (to_del); }
};

//             **** "quit_button" ****
// geordnetes Beenden der Applikation ueber globales exit Flag
class quit_button : public button { 
public: 
  quit_button(window & parent, int w, int h, int x, int y) : 
    button(parent, "quit", w, h, x, y) {}
  quit_button(menu_bar & parent) : button(parent, "quit") {}
private:
  void BPress_1_CB(XButtonEvent ev) { mainw->exit_flag = TRUE; }
};

// popup a window with help text and a OK button
class help_button : public button {
  text_popup * help_popup;
public: 
  help_button(window & parent, int x, int y, char * text[]) :
    button(parent, "help", 60, 20, x, y) { make_popup(text); }

  help_button(menu_bar & parent, char * Name, char * text[]) :
    button(parent, Name) { make_popup(text); }
private:
  void make_popup(char * text[]);
protected:
  virtual void BPress_1_CB(XButtonEvent ev) { 
   // help_popup->do_popup(ev.x_root, ev.y_root + 20); 
   help_popup->RealizeChildren();
  }
};

// *** "callback_button" class ****
// a button attached with a callback function on BRelease !! events
// bietet einen Mechanismus, instanz-spezifische callbacks aufzurufen !
// die ansonsten nur klassenbezogen definiert werden
class callback_button : public button {
  void (*callback) ();

public:
  callback_button (window & parent, char * Name, void (*cb)(), 
		   int w, int h, int x = 0, int y = 0) : 
  button (parent, Name, w, h, x, y), callback(cb) { }
  
  callback_button (menu_bar & parent, char * Name, void (*cb)()) : 
  button (parent, Name), callback(cb) { }

protected:
  virtual void BPress_1_CB(XButtonEvent ev) { } // do nothing
  virtual void BRelease_1_action()  { (*callback)(); } 
};

// *** "template_button" class ****
// analog, mit Uebergabe eines T-Argumentes "template"
// dh die callback-function ist vom Typ "void cb(T)"
// Bsp: void dist(float x) {ww->z +=x;..} 
//      template_button <float> (mb,"Name", dist, 2);

template <class T>
class template_button : public button {
  void (*callback) (T);
  T value;
public:
  template_button (window & parent, char * Name, void (*cb)(T), T val,
		   int w, int h, int x = 0, int y = 0) : 
  button (parent, Name, w, h, x, y), callback(cb) {value = val; }
  
  template_button (menu_bar & parent, char * Name, void (*cb)(T), 
		  T val) : 
  button (parent, Name), callback(cb) { value = val; }

protected:
  virtual void BPress_1_CB(XButtonEvent ev) { } // do nothing
  virtual void BRelease_1_action()  { (*callback)(value); }
};

//   ***** instance_button : template button for member-functions of class
template <class T>
class instance_button : public button {
  void (T::*member)();
  T *instance;
public:
  instance_button(window &parent, char *Name, void (T::*mem)(), T *inst,
		  int w, int h, int x, int y) :
    button(parent,Name,w,h,x,y) { member = mem; instance = inst; }

  instance_button(menu_bar &parent, char *Name, void (T::*mem)(), T *inst) :
    button(parent,Name) { member = mem; instance = inst; }  
protected:
  virtual void BPress_1_CB(XButtonEvent ev) { (instance->*member)(); }
  virtual void BRelease_1_action() {} 
};

// *** "function_button" class **** : die 3. Variante des callbacks
// a button attached with a callback function on BRelease !! events
// hier bekommt die callback_function alle Argumente der Ellipses uebergeben
// (Pointer oder int); max 10 
// default Argumente sind nicht erlaubt !

#include <stdarg.h>

typedef void (*CB)(...); // typ der callback fn

class function_button : public button {
  CB callback;
  void *values[10]; // die uebergebenen Werte
public:
  function_button (window & parent, char * Name,  
                   int w, int h, int x, int y, CB cb,  ...);

  function_button (menu_bar & parent, char * Name, CB cb, ...);
protected:
  virtual void BPress_1_CB(XButtonEvent ev) { } // do nothing
  virtual void BRelease_1_action() {
    (*callback)(values[0],values[1],values[2],values[3],values[4],values[5],
		values[6],values[7],values[8],values[9]);} 
};


//     ****** class toggle_button : with display of state ****

class toggle_button : public button {
  int *vptr; // der Pointer zum toggle-Wert
  int xright; // Platz fuer picture am rechten Rand
  virtual int eff_width() { return (width - xright); } // fuer PlaceText
public:
  toggle_button(menu_bar &parent, char *Name, int *ref) : 
      button(parent,ext_string(Name)) { vptr = ref ; xright = 12; }
  toggle_button(window &parent, char *Name, int *ref, int w, int h, 
		 int x, int y ) :
      button(parent,Name,w,h,x,y) { vptr = ref; xright = 12; }
  void picture() { // 8x8 Pixel gross
    int offs = (height-8)/2; // Abstand zur Ober- und Unterkante
    rect3d(Win,(*vptr) ? down3d : up3d, width-xright,offs,8,8); }
protected:
  virtual void toggle_cb (int val) {}  // can be overloded
  virtual void BRelease_1_action() { 
    *vptr = ! *vptr; picture(); toggle_cb(*vptr); }
  virtual void redraw() { button::redraw(); picture(); }
};

//   ************  frequently used : toggle and redraw a window
class toggle_redraw_button : public toggle_button {
window *win;
public:
  toggle_redraw_button(menu_bar &parent, char * Name, int *ref, window *win):
     toggle_button(parent,Name,ref), win(win) { }
  virtual void toggle_cb(int v) { win->redraw(); }
};

// *********************************************************************
//                   PULLDOWN windows
// pulldown window : a window child from root_window, not yet visible, 
// not managed from WM, position is determined from the button at popup time
class pulldown_window : public main_window {
public:
  pulldown_window (int w, int h);
  inline void Release_CB(XButtonEvent ev) { Unmap();}
};

//     **** "pulldown_button" class *****
// map the window (menu) on root when button is activated (BPress)
// the window is mapped to absolute co-ordinates !
class pulldown_button : public button { 
  pulldown_window  * pulldown_menu; 
  int xright;
  virtual int eff_width() { return (width-xright); }
public:
  pulldown_button (window & parent, pulldown_window * menu, char * Name, 
		   int w, int h, int x, int y);
  pulldown_button(menu_bar & parent, pulldown_window * menu, 
		  char * Name);
  pulldown_button (window & parent, pulldown_window * menu, char * Name, 
		   char ** help_text, int w, int h, int x, int y);
  void picture();
protected:
  virtual void BPress_1_CB(XButtonEvent ev);   
  virtual void Leave_CB(XCrossingEvent ev) { // falls B1 nicht gedrueckt
    if (!(ev.state & Button1Mask)) default_frame(); }
  virtual void redraw() { button::redraw(); picture(); }
};


// creates single button entry with Name and value in a radio_menu
class radio_button : public button {
  char * value;  // the special value
  char * menu_name ; // the name of the button which pulled this radio_menu
  window * action_win;
public:    
  radio_button(pulldown_window &parent, char * MName, 
	       int w, int h, int x, int y, char * val, window * action) 
       : button(parent,val,w,h,x,y), value(val) {
    menu_name = MName; // Name of menu_button; is passed to action
    action_win = action;
  }
protected:
  virtual void BRelease_1_action() { 
    if (action_win) action_win->action(menu_name, value); 
  }
};


// Erzeugt ein radio-menu (toggle) mit named buttons (name = value : string)
// Name,w,h,x,y  : Parameter des pulldown_buttons 
// list : besteht aus { "value1", "value2",..., 0 }
// action_win : window dessen "action" methode aufgerufen werden soll 
//              nach dem toggle
// der Name (als Pointer) wird mit value uebergeben -> als Hilfe, welches
// menue (von ggf. mehreren) aktiv war !

pulldown_button * make_radio_menu(window &parent, char *Name,
				  char **blist,  window * action_win = 0,
				  int w= 0, int h= 0, int x= 0, int y= 0);

// analogous : with help popup
pulldown_button * make_radio_menu(window &parent, char *Name, char **list,
				  char ** help_text, window * action_win = 0,
				  int w= 0, int h= 0, int x= 0, int y= 0 ); 

// fuer callback_buttons : name string, callback function
struct but_cb { char * bname; void (*cb) (); };

// erzeugt pulldown_menu mit einer Liste von callback_buttons
// und einem pulldown_button (im parent) der es aktiviert
pulldown_button * make_pulldown_menu(window &parent, char *Name, 
				     int nbuttons, struct but_cb list[],
				     int w= 0, int h= 0 , int x= 0, int y= 0);

// ---------------------- POPUP WINDOWS ------------------------------------

// popup_button : realize the popup menu when BPress (make it visibel) 
class popup_button : public button { 
  main_window * popup_menu; 
public: 
  popup_button(window &parent, main_window * menu, char * Name, 
	       int w, int h, int x, int y) :
    button(parent, Name, w, h, x, y) { popup_menu = menu; }  

  popup_button(menu_bar &parent, main_window * menu, char * Name) :
    button(parent, Name) { popup_menu = menu; } 
private:
  virtual void BPress_1_CB(XButtonEvent ev) { 
    popup_menu->do_popup(ev.x_root + 10,ev.y_root + 20); }  
};

// unmap_button : a special button to Unmap the parent
//                 on BPress, esp. usefull for popup menus
class unmap_button : public button { 
  window * to_unmap;
public: 
  unmap_button(window & parent, char * string,
	       int w, int h, int x, int y) : 
  button(parent,string, w, h, x, y) { to_unmap = &parent;}  
  // 2. constructor, used for unmap_buttons on menu_bars
  unmap_button(menu_bar & parent, char * string, window * unmap) :
    button(parent,string) { to_unmap = unmap;}
private:
  virtual void BPress_1_CB(XButtonEvent ev) { to_unmap->Unmap(); }
};

// berechtet fuer string array: max Laenge eines strings && Anzahl der strings 
void compute_text_size(char *text[], int &cols, int &lines);

// define a co-ordinate system in a window 
class coord_window : public pixmap_window {
protected:
  int x0,y0; // Window-Koordinaten des Ursprungs;
  int w_eff,h_eff; // effektive	Breite und Hoehe des KS
  int w_diff,h_diff,ryd,rxl;
  float xl,yd, // WK der linken unteren Ecke (Ursprung, ia: 0,0)
        xr,yu, // WK der rechten, oberen Ecke (ia: xmax, ymax)
        xf,yf; // Masstabs-Faktoren
public:

  void define_coord(float x1, float y1, float x2, float y2);

  // compute total window-coordinates from world-values
  int x_window(float x);
  int y_window(float y);
  XPoint p_window(float x, float y); // returns same as XPoint
 
  // back transformation : window coords to world-values
  float x_org(int xw);
  float y_org(int yw);

  // rx : freier Rand links/rechts & ry : unten
  coord_window(window & parent, int w, int h, int x, int y, 
	       int rxl = 5, int rxr = 5, int ryd = 5, int ryu = 5);
 
  // zeichnet Linie mit normierten Window-Koordinaten
  // dh. Ursprung => (0,0), y waechst nach oben !
  void rline(int xp, int yp, int xq, int yq) {
    line(x0 + xp, y0 - yp, x0 + xq, y0 - yq); }
  
  void draw_coords() {
    rline(0,0,0,h_eff); rline(0,0,w_eff,0);
   }
  // draw x-ticks from xl..xo in dx-steps, max n ticks
  void x_ticks(float dx, int n = 1000);
  void y_ticks(float dy, int n = 1000);

  void wline(float x1, float y1, float x2, float y2) {
    line(x_window(x1),y_window(y1),x_window(x2),y_window(y2)); }
 
  void graph(int nx, double f[]); 
};

// ruft system-call mit cmdline-string als Argument
class system_button : public button {
char * cmdline;
public: 
  system_button(window &parent,char *Name, char *cmdline, 
	      int w, int h, int x, int y) : 
    button(parent,Name,w,h,x,y), cmdline(cmdline) {}
  virtual void BPress_1_CB(XButtonEvent);
};

// ruft 'system("xwd -in wid " + arg)' und erzeugt damit X-Window-dump des
// windows 'dumpw'; 
// Mit arg laesst sich die Ausgabe steuern : 
// zB "-out dump.file" oder " | xpr | lpr " als hardcopy 
// mit "xwud -in dump.file" bzw. "xpr" wieder darzustellen bzw. zu drucken
// zB:  'xwd_button du1(mb,"dump","-nobdrs -out dump.file",pwindow);'

class xwd_button : public button { 
window * dumpw;
char * arg;  // rest-arg, kann auch beliebige xwd-Optionen enth. zb. "-nobdrs"
public: 
  xwd_button(window &parent, char *Name, char *arg, window *dumpw,
	      int w, int h, int x, int y) : 
    button(parent,Name,w,h,x,y), dumpw(dumpw), arg(arg) {}
  
  xwd_button(menu_bar &parent,char *Name, char *arg, window *dumpw ) : 
    button(parent,Name), dumpw(dumpw), arg(arg) {}

  void BPress_1_CB(XButtonEvent);
};
 
// **************************************************************
//               SCROLLBARS

// sliders as movable plate for scrollbars
class slider : public plate { 
  int count;
public: 
  slider(window &parent, int w, int h, int x, int y) :
     plate (parent,w,h,x,y,up3d) { }
  virtual void redraw(); // called from Expose_CB
};

// a simple scrollbar without display of the value (should not be used)
// if the 1. constructor (without xanf) is used, the slider must explicitely 
// be set !!

class pure_scrollbar : public plate {
  slider * bar;
protected:
  int sw,sh,sy,xoff,xmax,xspan,xact;
public:
  void set_slider(int x); // fuer Anfang: Setzen des sliders nach x
  void init (); // Setzen der Elemente
  // 1. constructor: without initial value
  pure_scrollbar(window &parent, int w, int h, int x, int y) :
    plate (parent,w,h,x,y,down3d) { init(); }
  // 2. constructor : with initial value 
  pure_scrollbar(window &parent, int w, int h, int x, int y, int xanf) :
    plate (parent,w,h,x,y,down3d) { init(); set_slider(xanf);}

protected:
  // virtual function "callbck" is called from move
  virtual void callbck(int x) { printf(" %d",x); fflush(stdout); } 

  void move(int x); // Bewegen des sliders (x = Pointer) und callback  
  virtual void redraw();

  // Springen bei Maus-Click button1
  virtual void BPress_1_CB(XButtonEvent ev) { move(ev.x - xoff); }

  // Ziehen, wenn Button1 gedrueckt
  virtual void Motion_CB(XMotionEvent ev) { 
    if (ev.state & Button1Mask) { move(ev.x - xoff); }
  } 
  virtual void resize(int, int);
};

// to display the actual value of a slider
class display_window : public plate { 
char * val; 
public: 
  display_window(window &parent, char *def, int w, int h, int x, int y, 
		 int mode3d) :
    plate(parent,w,h,x,y,mode3d) { val = def; }
  void draw_val() { PlaceText(val); }
  void set_text_mode(int mode); // mode 0 : Loeschen, 1 : Schreiben
  virtual void redraw() { plate::redraw(); draw_val(); }

};

//   ********* class scrollbar ********

// die union "fn_union" dient dem Zugriff auf den function pointer 
// fuer die 2 Typen der info function, die als calback aufgerufen werden
union fn_union {  
  void (*empty)();     // der parameterlose call mode (Form 1)
  void (*vptr)(void*); // der callmode mit void* (Form 2)
  void *value;         // fuer Test auf NULL
};

// 2 Konstruktoren : mit verschiedenen callback-Formen
//      1. callback inf() als parameterlose void Funktion (alte Version)
//      2. callback inf(void *), die das (void*) Argument "to_inf" erhaelt
//         damit lassen sich Memberfunktionen anderer Klassen aufrufen
// "minp, maxp" sind die Grenzwerte des scrollbars, die auf [0..xspan] pixel
//          abgebildet werden
//          falls maxp == 0 (default) wird die slider-Breite angenommen
// "format" dient zur Konvertierung des aktuellen Wertes im display
// "inf"    ist ein callback, das bei jeder slider-Bewegung aufgerufen wird
//          (ohne Argumente), der aktuelle Wert laesst sich ueber 
//          "scrollbar.value" abfragen
// "xstart" ist Anfangswert des sliders

class scrollbar : public pure_scrollbar {
  display_window * disp_win;
  pure_scrollbar * ps;
  char str[80];
  double factor;   // der Umrechnungs-Faktor von pixel = 0..w -> min..max 
  void *to_inform; // pointer fuer Form 2
  fn_union inffn;
  char * format; // das format zur Darstellung des Wertes, zB "Wert = %4x"
public:
  int min, max, value;
private:
  void valstr(int pix) { // update string and value
    value = min + (int) (pix * factor);
    sprintf(str,format,value); }
  int pwidth(int w) { return (w-60); } // die eff. Breite des pure_scrollbars
public:
  void init(window &parent, int w, int h, int x, int y,
	    int minp, int maxp, int xstart);
  // 1. Konstruktor
  scrollbar(window &parent, void (*inf)(), int w, int h, int x, int y, 
	    int minp = 0, int maxp = 0, int xstart = 0, char *format = "%d");
  // 2. Konstruktor
  scrollbar(window &parent, void (*inf)(void*), void * to_inf,
	    int w, int h, int x, int y, 
	    int minp = 0, int maxp = 0, int xstart = 0, char *format = "%d");

  // explizites Setzen des sliders und displays
  void change(int x) { move( (int) ((x - min) / factor)); } 
protected:
  virtual void callbck(int pix);
  virtual void resize(int, int);
};

// class for temporarily set and reset cursor for a window 
// using constructors & destructors
class TempCursor {
 window * win;
 public:
  TempCursor(window *w) {
    win = w;
    XDefineCursor(display, win->Win, watch_cursor);
   }
  ~TempCursor() { XUndefineCursor(display, win->Win); }
};

// ***************************************
// class "edit_window" zum Editieren von strings, max 200 Zeichen 
// zwei virtuelle fn : 
//   enter - daran sollte die Aktion gekoppelt werden , escape
class edit_window : public plate {
  int cp; // text cursor position im string (von 0..strlen)
  int xs; // x-pos des string starts
protected:
  void mark_cursor();
  virtual void Enter_CB(XCrossingEvent ev);
  virtual void Leave_CB(XCrossingEvent ev);

  void del_char();
  void ins_char(char x);
public:
  char value[200];  
  edit_window(window &parent, char *str, int w,int h, int x, int y);
  virtual void redraw();
  virtual void enter() { printf("%s\n",value); } // zu ueberdefinieren !!
  virtual void escape() { memset(value,0,80); cp = 0; } // Loescht den string
  virtual void format_error() { XBell(display,10); }
  void KeyPress_CB(XKeyEvent ev);
};
