proc TedReadFile {w} {
  global ted params

  if {$ted($w,file) == "" || [file isdir $ted($w,file)]} {
    append ted($w,file) "##noname##"
    wm title $w "$ted($w,title) [cutdir $ted($w,file)]"
  }
  if [file exists $ted($w,file)] {
    $w.text delete 1.0 end
    set id [open $ted($w,file) r]
    while {[gets $id s]!=-1} {
      $w.text insert end $s\n
    }
    close $id
    if {[set i [lsearch $params(global_options) "bak *"]] > -1} {
      if [lindex [lindex $params(global_options) $i] 1] {
        TedSave $w [file rootname $ted($w,file)].bak
      }
    }
  }
  $w.text mark set insert 1.0
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedNew {w} {
  global ted

  $w.text delete 0.1 end
  set ted($w,file) ""
  TedReadFile $w
}

proc TedSave {w filename} {
  global ted

  if {$filename != ""} {
    set color [lindex [$w.text configure -foreground] 4]
    $w.text configure -foreground Black
    update idletasks
    debug "TedSave: $filename :"
    set id [open $filename w]
    for {set i 1} {[$w.text compare $i.0 < end]} {incr i} {
      set s [$w.text get $i.0 "$i.0 lineend"]
      puts $id $s
    }
    close $id
    set ted($w,stsave) 0
    $w.text configure -foreground $color
  }
}

proc TedSaveAs {w question} {
  global ted params 

  if {$question || [file tail $ted($w,file)] == "##noname##"} {
    set x [winfo rootx $w]
    set y [winfo rooty $w]
    if {![FileDialog +$x+$y "Save File" $ted($w,ext) ted($w,file)]} {
      return
    }
    debug "TedSaveAs: $ted($w,file)"
    wm title $w "$ted($w,title) [cutdir $ted($w,file)]"
    # In cause of changing filename of active edit file: correct
    set params(Edit_file) $ted($w,file)
  }
  TedSave $w $ted($w,file)
}

proc TedAskSave {w} {
  global ted  

  if $ted($w,stsave) {
    set x [winfo rootx $w]
    set y [winfo rooty $w]
    switch [Dialog .dlg +$x+$y Save \
      "Edit file $ted($w,file) has been changed. Save?" \
      warning 0 2 {Yes <Any-y>} {No <Any-n>} {Cancel}] {
      0 {TedSaveAs $w 0}
      1 {}
      2 {return 0}
    }
  }
  return 1
}

proc TedAutoSave {w} {
  global ted

  if {$ted($w,autosave)} {
    debug "AutoSave"
    if {$ted($w,stsave)} {
      TedSaveAs $w 0
      sync
    }
    after $ted($w,autos_interval) [list TedAutoSave $w]
  }
}
    
proc TedExit {w} {
  global ted  

  if {![TedAskSave $w]} {return 0}
  unset ted($w,file)
  unset ted($w,ext)
  destroy $w
  xfocus .
  return 1
}

proc TedPos {w anchor {sign ""} {count ""} {direct ""}} {
  global ted

  $w.text mark set insert "$anchor $sign $count $direct"
  $w.text yview -pickplace insert
  set ted($w,pos) [$w.text index insert]
}

proc TedMark {w sign {count ""} {direct ""}} {

  set l [$w.text tag ranges sel]
  if {$l == ""} {
    $w.text mark set anchor insert
    $w.text mark set selto insert
  }
  if [$w.text compare anchor != insert] {
    $w.text mark set anchor insert
    $w.text mark set selto insert
  }
  $w.text mark set selto "selto $sign $count $direct"
  if [$w.text compare anchor < selto] {
    $w.text mark set first anchor
    $w.text mark set last selto
  } else {
    $w.text mark set first selto
    $w.text mark set last anchor
  }
  $w.text tag remove sel 0.0 first
  $w.text tag add sel first last
  $w.text tag remove sel last end
  $w.text yview -pickplace selto
}

proc TedCopyMark {w {cut ""}} {
  global ted_buf

  set l [$w.text tag ranges sel]
  if {[llength $l] != 2} {
    return
  }
  set txt [eval $w.text get $l]
  if {$cut != ""} {
    eval $w.text delete $l
  }
  set first [$w.text index insert]
  $w.text insert insert $txt
  $w.text mark set anchor $first
  $w.text mark set selto insert
  $w.text tag remove sel 0.0 anchor
  $w.text tag add sel anchor selto
  $w.text tag remove sel selto end
  set ted($w,stsave) 1
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedCut {w {fcopy ""}} {
  global ted_buf

  set l [$w.text tag ranges sel]
  if {[llength $l] != 2} {
    return
  }
  set ted_buf [eval $w.text get $l]
  if {$fcopy == ""} {
    eval $w.text delete $l
    set ted($w,stsave) 1
  }
  $w.text tag remove sel 0.0 end
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedPaste {w} {
  global ted ted_buf 

  if ![info exists ted_buf] return
  set ted($w,pos) [$w.text index insert]  
  $w.text insert insert $ted_buf
  $w.text mark set insert $ted($w,pos)
  $w.text yview -pickplace insert
  set ted($w,stsave) 1
}

proc TedDelMark {w} {
  global  ted

  set l [$w.text tag ranges sel]
  if {[llength $l] != 2} {return} 
  eval $w.text delete $l
  set ted($w,stsave) 1
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedDelWord {w} {
  global ted

  $w.text delete insert "insert wordend"
  set ted($w,stsave) 1
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedInsert {w c} {
  global ted

  switch -- $c {
    \r {$w.text insert insert \n}
    \b {$w.text delete "insert - 1 c"}
    \t {$w.text insert insert $c}
    \x7f {$w.text delete insert}
    default {
      if {$c < " "} {return}
      $w.text insert insert $c
    }
  }
  if $ted($w,wrap) {
    set width [lindex [$w.text config -width] 4]
    set line [$w.text get "insert linestart" "insert lineend"]
    set l [string length $line]
    if {$l >= $width} {
      set l1 [string length [$w.text get "insert + 1 l linestart" \
                             "insert + 1 l lineend"]]
      if {[set i [string last " " [string range $line 0 $width]]] > 0} {
        $w.text mark set ml "insert linestart"
        $w.text delete "insert linestart + $i c"
        $w.text insert "insert linestart + $i c" \n
        if "$l1 + $l - $i < $width && $l1 > 0" {
          $w.text insert "ml + 1 l lineend" " "
          $w.text delete "ml + 1 l lineend"
        }
      }
    }
  }
  set ted($w,stsave) 1
  set ted($w,pos) [$w.text index insert]
  $w.text yview -pickplace insert
}

proc TedInsSel {w} {
  global ted

  set s [selection get STRING]
  $w.text insert insert $s
  $w.text yview -pickplace insert
}

proc TedDelLine {w} {
  global ted

  $w.text delete "insert linestart" "insert lineend"
  $w.text delete "insert linestart" "insert linestart + 1 l"
  $w.text yview -pickplace insert
  set ted($w,stsave) 1
  set ted($w,pos) [$w.text index insert]
}

proc TedSearchDlg {w geom replace} {
  global ted_sdlg

  toplevel $w
  wm geometry $w $geom
  wm transient $w . 

  if $replace {
    set title "Search and Replace expression"
  } else {
    set title "Search expression"
  }
   
  label $w.title -text $title
  pack $w.title -fill x

  frame $w.s
  pack $w.s -fill x
  label $w.s.l -text "\[T\]ext to find" -width 15 -anchor w
  entry $w.s.e -textvariable ted_sdlg(search) -width 15 \
    -relief sunken -bd 1
  pack $w.s.l -side left -fill x
  pack $w.s.e -side left -fill x -expand true -padx 5
  
  frame $w.r
  if $replace {pack $w.r -fill x}
  label $w.r.l -text "\[N\]ew text" -width 15 -anchor w
  entry $w.r.e -textvariable ted_sdlg(replace) -width 15 \
    -relief sunken -bd 1
  pack $w.r.l -side left -fill x
  pack $w.r.e -side left -fill x -expand true -padx 5

  frame $w.b
  pack $w.b -side bottom -fill x

  frame $w.ex1 -bd 1 
  pack $w.ex1 -side left -fill both -expand true -pady 5

  checkbutton $w.ex1.c -text "\[C\]ase sensitive" -anchor w \
    -variable ted_sdlg(case)
  pack $w.ex1.c -fill x -expand true
  if $replace {
    checkbutton $w.ex1.a -text "\[R\]eplace all" -anchor w \
      -variable ted_sdlg(all)
    checkbutton $w.ex1.q -text "\[P\]rompt on replace"  -anchor w \
      -variable ted_sdlg(prompt)
    pack $w.ex1.a $w.ex1.q -fill x
  }

  frame $w.b.fok -relief sunken -bd 1
  pack $w.b.fok -side left -padx 5 -pady 5
  button $w.b.ok -text OK -command {set ted_sdlg(ok) 1}
  button $w.b.cancel -text Cancel -command {set ted_sdlg(ok) 0}
  pack $w.b.ok -padx 5 -pady 5 -in $w.b.fok
  pack $w.b.cancel -padx 5 -pady 5 -side left

  if $replace {
    set el [list $w.s.e $w.r.e]
    bind $w.s.e <Return> "focus $w.r.e"
    bind $w.s.e <Any-Tab> "focus $w.r.e"
    bind $w.r.e <Return> "focus $w.s.e"
    bind $w.r.e <Any-Tab> "focus $w.s.e"
  } else {
    set el [list $w.s.e]
    bind $w.s.e <Return> { }
    bind $w.s.e <Tab> { }
  }
  foreach e $el {
    bind $e <Control-Return> {set ted_sdlg(ok) 1}
    bind $e <Escape> {set ted_sdlg(ok) 0}
    bind $e <Alt-Any-c> {
      set ted_sdlg(case) [expr ! $ted_sdlg(case)]
    }
    bind $e <Alt-Any-r> {
      set ted_sdlg(all) [expr ! $ted_sdlg(all)]
    }
    bind $e <Alt-Any-p> {
      set ted_sdlg(prompt) [expr ! $ted_sdlg(prompt)]
    }
    bind $e <Left> {
      set i [%W index insert]
      if {$i > 0} {incr i -1}
      %W icursor $i
    }
    bind $e <Right> {
      set i [%W index insert]
      set l [string length [%W get]]
      if {$i < $l} {incr i}
      %W icursor $i
    }
  }
  set old_focus [focus]
  grab $w
  focus $w.s.e
  tkwait variable ted_sdlg(ok)
  destroy $w
  focus $old_focus
  return $ted_sdlg(ok)
} 

proc TedSearch {w} {
  global ted ted_sdlg

  set ted_sdlg(search) ""
  set ted_sdlg(case) 0
  catch {
    set ted_sdlg(search) $ted($w,s_search)
    set ted_sdlg(case) $ted($w,s_case)
  }
  set x [winfo rootx $w.text]
  set y [winfo rooty $w.text]
  if [TedSearchDlg .tedsd +$x+$y 0] {
    set ted($w,s_case)  $ted_sdlg(case)
    if $ted($w,s_case) {
      set ted($w,s_search) $ted_sdlg(search)
    } else {
      set ted($w,s_search) [string tolower $ted_sdlg(search)]
    }
    set ted($w,replace) 0
    TedReplaceNext $w
  }
}

proc TedReplace {w} {
  global ted ted_sdlg

  set ted_sdlg(search) ""
  set ted_sdlg(case) 0
  set ted_sdlg(prompt) 1
  set ted_sdlg(all) 0
  catch {
    set ted_sdlg(search) $ted($w,r_search)
    set ted_sdlg(replace) $ted($w,r_replace)
    set ted_sdlg(case) $ted($w,r_case)
    set ted_sdlg(prompt) $ted($w,r_prompt)
    set ted_sdlg(all) $ted($w,r_all)
  }
  set x [winfo rootx $w.text]
  set y [winfo rooty $w.text]
  if [TedSearchDlg .tedsd +$x+$y 1] {
    set ted($w,r_case)  $ted_sdlg(case)
    if $ted($w,r_case) {
      set ted($w,r_search) $ted_sdlg(search)
    } else {
      set ted($w,r_search) [string tolower $ted_sdlg(search)]
    }
    set ted($w,r_replace) $ted_sdlg(replace)
    set ted($w,r_prompt) $ted_sdlg(prompt)
    set ted($w,r_all) $ted_sdlg(all)
    set ted($w,replace) 1
    if $ted($w,r_all) {
      $w.text mark set insert 1.0
      while {[TedReplaceNext $w]} { }
    } else {
      TedReplaceNext $w
    }
  }
}

proc TedReplaceNext {w} {
  global ted

  if ![info exists ted($w,replace)] return
  if $ted($w,replace) {
    # Replace part
    if {$ted($w,r_search) == ""} return
    set search $ted($w,r_search)
    if $ted($w,r_case) {
      set case 1
    } else {
      set case 0
    }
    $w.text mark set pos [$w.text index insert]
    scan [$w.text index insert] %d i
    scan [$w.text index end] %d numLines
    while {$i < $numLines} {
      set s [$w.text get pos "pos lineend"]
      if {! $case} {
        set s [string tolower $s]
      }
      set res [string first $ted($w,r_search) $s]
      if {$res >= 0} {
        set l [string length $ted($w,r_search)]
        $w.text tag add repl "pos + $res c" \
          "pos + $res c + $l c"
        $w.text tag configure repl -background green
        set repl 0
        if $ted($w,r_prompt) { 
          $w.text yview pos
          update idletasks
          set x [winfo rootx $w.text]
          set y [expr [winfo rooty $w.text] + 40]
          set repl [Dialog .dlg +$x+$y Replace \
            "Replace this occurance?" \
            question 0 2 {Yes <Any-y>} {No <Any-n>} {Cancel}]
        }
        $w.text tag delete repl
        if {$repl == 2} {return 0} ; # Interrupt search
        $w.text mark set insert \
          "pos + $res c + $l c"
        if {$repl == 0} {
          $w.text delete "pos + $res c" \
            "pos + $res c + $l c"
          $w.text insert "pos + $res c" $ted($w,r_replace)
          $w.text yview -pickplace insert
          set ted($w,stsave) 1
        } 
        return 1
      }
      incr i
      $w.text mark set pos $i.0
    }
    return 0
  } else {
    # Search part
    if {$ted($w,s_search) == ""} return
    set search $ted($w,s_search)
    if $ted($w,s_case) {
      set case 1
    } else {
      set case 0
    }
    $w.text mark set pos [$w.text index insert]
    scan [$w.text index insert] %d i
    scan [$w.text index end] %d numLines
    while {$i < $numLines} {
      set s [$w.text get pos "pos lineend"]
      if {! $case} {
        set s [string tolower $s]
      }
      set res [string first $ted($w,s_search) $s]
      if {$res >= 0} {
        $w.text mark set insert \
          "pos + $res c + [string length $ted($w,s_search)] c"
        $w.text yview -pickplace insert
        return 1
      }
      incr i
      $w.text mark set pos $i.0
    }
    return 0
  }
}

proc TedGoto {w} {
  global ted

  set r(goto) ""
  set x [winfo rootx $w.text]
  set y [winfo rooty $w.text]
  if [InpDlg r .dlg +$x+$y "Goto" {
    {Line int 4 goto}
    } r] {
    $w.text mark set insert $r(goto).0
    $w.text yview -pickplace insert
  }
}

proc TedContextHelp {w} {
  global ted hlp
  
  set s [$w.text get "insert wordstart" "insert wordend"]
  puts $s
  set i [lsearch $hlp(idx_list) $s*]
  if {$i < 0} {return}
  set j $i
  incr j
  while {[string match "$s*" [lindex $hlp(idx_list) $j]]} {incr j}
  incr j -1
  if {$i < $j} {
    set l {}
    for {set k $i} {$k <= $j} {incr k} {
      lappend l [lindex [split [lindex $hlp(idx_list) $k] \xff] 0]
    }
    if {[set k \
      [ListDlg .hlpdia $hlp(dlg_geom) "Select Item" $l] \
      ] > -1 } {
      set i [expr $i + $k]
    } else {
      return
    }
  }
  help [lindex [split [lindex $hlp(idx_list) $i] \xff] 1]
}

# Widgets
proc tedit {w geometry title {filename ""} {line 1}} {
  global params ted ted_buf
  
  toplevel $w
  wm group . $w
  set ted($w,file) $filename
  set ted($w,ext) .tex
  set ted($w,stsave) 0
  set ted($w,wrap) 0
  set ted($w,autosave) 0
  set ted($w,autos_interval) 60000
  if {[set i [lsearch $params(global_options) "save *"]] >= 0} {
    set ted($w,autosave) [lindex [lindex $params(global_options) $i] 1]
  }
  if {[set i [lsearch $params(global_options) "interval *"]] >= 0} {
    set ted($w,autos_interval) \
    [expr [lindex [lindex $params(global_options) $i] 1]*1000]
  }
  if {[set i [lsearch $params(global_options) "wrap *"]] >= 0} {
    set ted($w,wrap) [lindex [lindex $params(global_options) $i] 1]
  }
  set ted($w,block) 0
  set ted($w,title) $title
  wm geometry $w $geometry
  wm title $w "$title [cutdir $filename]"
  frame $w.menu -relief raised -borderwidth 1
  text $w.text -yscrollcommand "$w.textsb set" -font $params(editfont) \
    -wrap char
  scrollbar $w.textsb -command "$w.text yview"
  frame $w.status -relief raised -bd 1
  checkbutton $w.save -text "Changed (F2 Save)" -variable ted($w,stsave)
  checkbutton $w.wrap -text "Wrap (^w)" -variable ted($w,wrap)
  label $w.pos -textvariable ted($w,pos) -relief raised -bd 2
  pack $w.menu -side top -fill x
  pack $w.status -side bottom -fill x
  pack $w.text -side left
  pack $w.textsb -side left -fill y
  pack $w.save $w.wrap $w.pos -side left -in $w.status

  menubutton $w.menu.file -text "File" -underline 0 -menu $w.menu.file.m
  menu $w.menu.file.m
  $w.menu.file.m add command -label "New" -underline 0 -command "TedNew $w"
  $w.menu.file.m add command -label "Save" -accelerator F2 \
    -command "TedSaveAs $w 0"
  $w.menu.file.m add command -label "Save as..." -accelerator Ctrl-F2 \
    -command "TedSaveAs $w 1"
  $w.menu.file.m add separator
  $w.menu.file.m add command -label "Exit" -underline 1 -accelerator Alt-F3 \
    -command "TedExit $w"

  menubutton $w.menu.edit -text "Edit" -underline 0 -menu $w.menu.edit.m
  menu $w.menu.edit.m
  $w.menu.edit.m add command -label "Cut" -accelerator ^x \
    -command "TedCut $w"
  $w.menu.edit.m add command -label "Copy" -accelerator ^c \
    -command "TedCut $w copy"
  $w.menu.edit.m add command -label "Paste" -accelerator ^v \
    -command "TedPaste $w"
  $w.menu.edit.m add separator
  $w.menu.edit.m add command -label "Go to..." -accelerator "^Q l" \
    -command "TedGoto $w"
  $w.menu.edit.m add command -label "Search..." -accelerator "^Q f" \
    -command "TedSearch $w"
  $w.menu.edit.m add command -label "Replace..." -accelerator "^Q a" \
    -command "TedReplace $w"
  $w.menu.edit.m add command -label "Next occurance" -accelerator "^L" \
    -command "TedReplaceNext $w"
  menubutton $w.menu.option -text "Options" -underline 0 \
    -menu $w.menu.option.m
  menu $w.menu.option.m
  $w.menu.option.m add checkbutton -label "Wrap" -accelerator "^W" \
    -variable ted($w,wrap)
  $w.menu.option.m add checkbutton -label "Autosave" \
    -variable ted($w,autosave) -command "TedAutoSave $w"

#  menubutton $w.menu.latex -text "LaTeX" -menu $w.menu.latex.m
#  menu $w.menu.latex.m
#  $w.menu.latex.m add command -label "Environments" 
#  $w.menu.latex.m add command -label "Fonts" 

  pack $w.menu.file $w.menu.edit $w.menu.option -side left
  tk_menuBar $w.menu $w.menu.file $w.menu.edit $w.menu.option

  # Text widget bindings
  TextBind $w
  # Global bindings
  GlobalBind $w.text
  tk_bindForTraversal $w.text

  update idletasks
  foreach l $ted(global_params) {
    set flag [lindex $l 0]
    set value [lindex $l 1]
    set ted($w,$flag) $value
  }
  TedReadFile $w
  $w.text mark set insert $line.0
  $w.text yview -pickplace insert
  focus default $w.text
  TedAutoSave $w
  xfocus $w.text
}
