# params.tcl

proc initparams {} {

  set s {
    { Edit  0 {
        {"Intern" "tedit" "%e"}
        {"vi &" "exbg" "xterm -geometry %g -e vi !i+%! %e"}
    } }
    { Compose 0 {
      {"LaTeX" "exwin" "latex %p"}
      {"TeX" "exwin" "tex %p"}
    } }
    { Reference 0 {
      {"Makeindex" "exwin" "makeindex %p"}
    } }
    { View 0 {
      {"Xdvi" "exwin" "xdvi -geometry %g %p" }
      {"Xdvi &" "exbg" "xdvi -geometry %g %p"}
      {"Ghostview" "exwin" "ghostview %p.ps"}
    } }
    { Print 0 {
      {"DVIPS" exwin "dvips -t a4 !l-t landscape! !0-p %! !9-l %! !c-c %! !o-A! !e-B! !x%! %p"}
    } }
    { Graphic 0 {
      {"XFig &" "exbg" "xfig -geometry %g -but_ 3 -me %o.fig"}
    } }
    { Util 0 {
      {"View Log" catfile "%p.log"}
    } }
  }
  return $s
}

proc readparams {filename} {
  global params ted

  if [catch {set fd [open $filename r]}] {
    # Default values
    set s [initparams]
  } else {
    set s [read $fd]
    close $fd
  }
  set ted(global_params) {}
  foreach l $s {
    set cmd [lindex $l 0]
    if {[lsearch {Edit Compose View Print Reference Graphic Util} $cmd] \
      >= 0} {
      set default [lindex $l 1]
      set params($cmd) [lindex $l 2]
      set params(${cmd}_name) [lindex [lindex $params($cmd) $default] 0]
      set params(${cmd}_default) $default
    } elseif {$cmd == "Options"} {
      set params(global_options) [lindex $l 1]
    }
  }
}

proc writeparams {filename} {
  global params ted

#  foreach cmd {Edit Compose Reference View Print Util Graphic} {
#    puts $fd "\{[list $cmd $params(${cmd}_default) $params($cmd)]\}"
#  }
  set fd [open $filename w]
  foreach cmd {Edit Compose Reference View Print Util Graphic} {
    puts $fd "\{ $cmd $params(${cmd}_default) \{"
      foreach l $params($cmd) {
        puts $fd "\{$l\}"
      }
    puts $fd "\} \}"
  }
  puts $fd "\{ Options \{"
  foreach l $params(global_options) {
    puts $fd "\{$l\}"
  }
  puts $fd "\} \}"
  close $fd
}

proc selectparams {cmd} {
  global params pdlg

  proc PSetFields {l} {
    global pdlg

    if {[llength $l] > 0} {set pdlg(name) [lindex $l 0]}
    if {[llength $l] > 1} {set pdlg(cmd) [lindex $l 1]}
    if {[llength $l] > 2} {set pdlg(opt) [lindex $l 2]}
  }

  proc PSelect {i} {
    global pdlg

    set pdlg(sel) $i
    .pdlg.lb.b select from $i
    .pdlg.lb.b select to $i
    set l [.pdlg.lb.s get]
    set min [lindex $l 2]
    set max [lindex $l 3]
    if {$i < $min} {
      .pdlg.lb.b yview $i
    } elseif {$i > $max} {
      .pdlg.lb.b yview [expr $min + $i - $max]
    }
    PSetFields [lindex $pdlg(cmds) $pdlg(sel)] 
  }
  proc PNext {} {
    global pdlg

    incr pdlg(sel)
    if {$pdlg(sel) >= [.pdlg.lb.b size]} {
      set pdlg(sel) [expr [.pdlg.lb.b size] - 1]
    }
    PSelect $pdlg(sel)
  }
  proc PPrev {} {
    global pdlg

    incr pdlg(sel) -1
    if {$pdlg(sel) < 0} {set pdlg(sel) 0}
    PSelect $pdlg(sel)
  }
  
  proc PAdd {{app ins}} {
    global pdlg

    foreach f [array names pdlg] {
      set p($f) ""
    }
    if {[InpDlg pdlg .idlg $pdlg(geom) "Add Parameter" {
      {Name char 15 name}
      {"Exec Proc" char 15 cmd}
      {"Options" char 45 opt}
      } p]} {
      set l [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
      if {$app == "ins"} {
        set i $pdlg(sel)
      } else {
        set i [llength $pdlg(cmds)]
      }
      set pdlg(cmds) \
        [linsert $pdlg(cmds) $i $l]
      .pdlg.lb.b insert $i $pdlg(name)
      update
      PSelect $i
    }
  }
  proc PEdit {} {
    global pdlg

    if {[InpDlg pdlg .idlg $pdlg(geom) "Edit Parameter" {
      {Name char 15 name}
      {"Exec Proc" char 15 cmd}
      {"Options" char 45 opt}
      } pdlg]} {
      set l [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
      set pdlg(cmds) \
        [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel) $l]
        .pdlg.lb.b delete $pdlg(sel)
        .pdlg.lb.b insert $pdlg(sel) $pdlg(name)
      PSelect $pdlg(sel)
    }
  }
  proc PDel {} {
    global pdlg

    if {[Dialog .ddlg $pdlg(geom) "" "Delete entry $pdlg(name)" \
      question 0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
      debug "PDel"
      set pdlg(cmds) \
        [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
      .pdlg.lb.b delete $pdlg(sel)
      PSelect 0
    }
  }
  
  toplevel .pdlg
  wm transient .pdlg .
  wm geometry .pdlg $params(dlg_geom)

  frame .pdlg.b
  pack .pdlg.b -side right
  button .pdlg.b.ok -text "OK" -font 6x13bold -anchor w \
    -command {set pdlg(ok) 1}
  pack .pdlg.b.ok -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.cancel -text "Cancel" -font 6x13bold -anchor w \
    -command {set pdlg(ok) 0}
  pack .pdlg.b.cancel -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.edit -text "\[E\]dit" -font 6x13bold -anchor w \
  -command PEdit
  pack .pdlg.b.edit -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.insert -text "\[I\]nsert" -font 6x13bold -anchor w \
    -command {PAdd ins}
  pack .pdlg.b.insert -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.append -text "\[A\]ppend" -font 6x13bold -anchor w \
    -command {PAdd app}
  pack .pdlg.b.append -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.delete -text "\[D\]elete" -font 6x13bold -anchor w \
    -command {PDel}
  pack .pdlg.b.delete -side top -padx 5 -pady 5 -fill x

  label .pdlg.lsel -text "Select $cmd action" -font fixed
  pack .pdlg.lsel -anchor w
  frame .pdlg.lb 
  pack .pdlg.lb
  scrollbar .pdlg.lb.s -command ".pdlg.lb.b yview"
  listbox .pdlg.lb.b -yscroll ".pdlg.lb.s set" -relief sunken -bd 1
  tk_listboxSingleSelect .pdlg.lb.b
  pack .pdlg.lb.b -side left 
  pack .pdlg.lb.s -side right -fill y
  frame .pdlg.name
  pack .pdlg.name -side bottom -before .pdlg.b
  label .pdlg.name.l -text "Name" -width 10
  entry .pdlg.name.e -textvariable pdlg(name) -width 25 -state disabled
  pack .pdlg.name.l .pdlg.name.e -side left -anchor w
  frame .pdlg.cmd
  pack .pdlg.cmd -side bottom -before .pdlg.name
  label .pdlg.cmd.l -text "Exec proc" -width 10
  entry .pdlg.cmd.e -textvariable pdlg(cmd) -width 25 -state disabled
  pack .pdlg.cmd.l .pdlg.cmd.e -side left
  frame .pdlg.opt
  pack .pdlg.opt -side bottom -before .pdlg.cmd
  label .pdlg.opt.l -text "Call options" -width 10
  entry .pdlg.opt.e -textvariable pdlg(opt) -width 25 -state disabled
  pack .pdlg.opt.l .pdlg.opt.e -side left

  set pdlg(cmds) $params($cmd)
  foreach l $pdlg(cmds) {
    .pdlg.lb.b insert end [lindex $l 0]
  }
  set pdlg(sel) $params(${cmd}_default)
  set pdlg(name) $params(${cmd}_name)
  PSetFields [lindex $pdlg(cmds) $pdlg(sel)]
  # Bindings
  bind .pdlg.lb.b <Any-Return> {set pdlg(ok) 1}
  bind .pdlg.lb.b <Escape>  {set pdlg(ok) 0}
  bind .pdlg.lb.b <Any-a>   {PAdd app}
  bind .pdlg.lb.b <Any-i>   {PAdd ins}
  bind .pdlg.lb.b <Any-e>   {PEdit}
  bind .pdlg.lb.b <Any-d>   {PDel}
  bind .pdlg.lb.b <Delete>  {PDel}
  bind .pdlg.lb.b <Down>    {PNext}
  bind .pdlg.lb.b <Up>      {PPrev}
  bind .pdlg.lb.b <1>	    {PSelect [%W nearest %y]}
  update
  # Compute geometry
  set x [expr [winfo rootx .pdlg] - 100]
  set y [expr [winfo rooty .pdlg] + [winfo height .pdlg] + 5]
  set pdlg(geom) +$x+$y
  debug "Dialog geometry: $pdlg(geom)"
  PSelect $pdlg(sel)
  set old_focus [focus]
  grab set .pdlg
  focus .pdlg.lb.b
  tkwait var pdlg(ok)
  focus $old_focus
  destroy .pdlg
  if {$pdlg(ok)} {
    set params($cmd) $pdlg(cmds)
    set l [lindex $params($cmd) $pdlg(sel)]
    set params(${cmd}_name) [lindex $l 0]
    set params(${cmd}_default) $pdlg(sel)
    if {$cmd == "Util"} {
      utilmenu
    }
  }
  return
}

proc Options {} {
  global params odlg

  toplevel .odlg
  wm transient .odlg .
  wm geometry .odlg $params(dlg_geom)
  
  frame .odlg.l -relief raised -bd 1
  pack .odlg.l -fill x -expand 1
  label .odlg.l.title -text "Global settings"
  pack .odlg.l.title

  frame .odlg.t -relief raised -bd 1
  pack .odlg.t -fill x
  label .odlg.t.l -text "TeXShell:" -anchor w
  checkbutton .odlg.t.out -text "Show \[O\]utput Window" -anchor w \
    -variable odlg(out)
  pack .odlg.t.l -padx 10 -pady 5 -fill x
  pack .odlg.t.out -padx 10 -pady 5 -anchor w

  frame .odlg.e -relief raised -bd 1
  pack .odlg.e -fill x -expand 1
  label .odlg.e.l -text "Edit:" -anchor w
  frame .odlg.e.left
  frame .odlg.e.right
  checkbutton .odlg.e.wrap -text "Auto \[W\]rap" -anchor w \
    -variable odlg(wrap)
  checkbutton .odlg.e.save -text "Auto \[S\]ave" -anchor w \
    -variable odlg(save)
  checkbutton .odlg.e.bak -text "\[B\]AK-File" -anchor w \
    -variable odlg(bak)
    
  label .odlg.e.lint -text "Autosave \[I\]nterval (s):"
  entry .odlg.e.int -textvariable odlg(interval) -relief sunken -bd 2
  pack .odlg.e.l -padx 10 -pady 5 -fill x -expand 1
  pack .odlg.e.left .odlg.e.right -padx 10 -pady 5 -fill x -side left
  pack .odlg.e.wrap .odlg.e.save  .odlg.e.bak -fill x -in .odlg.e.left
  pack .odlg.e.lint .odlg.e.int -fill x -in .odlg.e.right

  frame .odlg.b -relief raised -bd 1
  pack .odlg.b -fill x -expand 1

  frame .odlg.b.fok -relief sunken -bd 1
  button .odlg.b.ok -text "OK" -command {set odlg(ok) 1}
  button .odlg.b.cancel -text "Cancel" -command {set odlg(ok) 0}
  pack .odlg.b.fok .odlg.b.cancel -side left -padx 10 -pady 5
  pack .odlg.b.ok -padx 5 -pady 5 -in .odlg.b.fok

  bind .odlg.e.int <Alt-Any-o> {set odlg(out) [expr ! $odlg(out)]}
  bind .odlg.e.int <Alt-Any-w> {set odlg(wrap) [expr ! $odlg(wrap)]}
  bind .odlg.e.int <Alt-Any-s> {set odlg(save) [expr ! $odlg(save)]}
  bind .odlg.e.int <Alt-Any-b> {set odlg(bak) [expr ! $odlg(bak)]}
  bind .odlg.e.int <Control-Return> {set odlg(ok) 1}
  bind .odlg.e.int <Escape>         {set odlg(ok) 0}

  foreach l $params(global_options) {
    set odlg([lindex $l 0]) [lindex $l 1]
  }
  set old_focus [focus]
  focus .odlg.e.int
  grab .odlg
  tkwait variable odlg(ok)
  if $odlg(ok) {
    set params(global_options) \
      [list "out $odlg(out)" "wrap $odlg(wrap)" "save $odlg(save)" \
        "bak $odlg(bak)" "interval $odlg(interval)"]
  }
  focus $old_focus
  destroy .odlg
}
