# help.tcl
#
# Syntax of help files:
# %.index
# %/topic
# %/topic
# ...
# Text
# 
proc readhelp {widget file pos} {
  global hlp

  $widget delete 1.0 end
  $widget mark set insert 1.0
  set fd [open $file r]
  seek $fd $pos
  set tagcount 0
  set t1 ""
  set t2 ""
  set tb ""
  set reflist ""
  set txt ""
  while {![eof $fd]} {
    gets $fd s
    if {[cindex $s 0] == "%" && [cindex $s 1] == "."} {break}
    append txt $s\n
  }
  close $fd
  set s0 ""
  while {[set i [string first "%" $txt]] > -1} {
    set s0 [string range $txt 0 [expr $i - 1]]
    $widget insert end $s0
    set p1 [$widget index insert]
    set c [cindex $txt [expr $i + 1]]
    if {$c == "%"} {
      $widget insert end "%"
      set txt [string range $txt [expr $i + 2] end]
    } else {
      set txt [string range $txt [expr $i + 2] end]
      set l [string length $txt]
      set t ""
      for {set i 0} {$i < $l} {incr i} {
        if {[cindex $txt $i] == "%"} {
          if {$i < $l && [cindex $txt [expr $i + 1]] == "%"} {
            incr i
          } else {
            break
          }
        }
        append t [cindex $txt $i]
      }
      set txt [string range $txt [expr $i + 1] end]
      if {$c == ">"} {
        set i [string first ">" $t]
        if {$i > -1} {
          set tref [string range $t [expr $i + 1] end]
          set t [string range $t 0 [expr $i - 1]]
        } else {set c "1"}
      }
      $widget insert end $t
      set p2 [$widget index insert]
      switch -- $c {
        "1" {lappend t1 "$p1 $p2"}
        "2" {lappend t2 "$p1 $p2"}
        "b" {lappend tb "$p1 $p2"}
        ">" {
          incr tagcount
          lappend reflist "ref$tagcount $p1 $p2 $tref"
        }
      }
    }
  }
  $widget insert end $txt\n
  $widget mark set insert 1.0
  foreach t1 $t1 {
    eval $widget tag add t1 $t1
  }
  foreach t2 $t2 {
    eval $widget tag add t2 $t2
  }
  foreach tb $tb {
    eval $widget tag add tb $tb
  }
  $widget tag configure t1 -foreground Red -font 8x16
  $widget tag configure t2 -foreground Red
  $widget tag configure tb -background Gray -foreground Red
  set hlp(items) "dummy"
  set hlp(sel) 0
  foreach l $reflist {
    set tg [lindex $l 0]
    $widget tag add $tg [lindex $l 1] [lindex $l 2]
    $widget tag configure $tg -background SteelBlue -foreground White \
      -borderwidth 1 -relief raised
    $widget tag bind $tg <1> "ref_find $widget [lindex $l 3]"
    lappend hlp(items) [lindex $l 3]
  }
  update
}

proc ref_find {widget item} {
  global hlp

  if {[keylget hlp(ref_list) $item pos]} {
    $widget config -state normal
    eval readhelp $widget $pos
    $widget config -state disabled
  }
}

proc ref_tell {filelist} {
  global hlp
  
  set hlp(ref_list) {}
  set hlp(idx_list) {}
  set idx ""
  set head ""
  foreach f $filelist {
    set fd [open $f r]
    set fhead 0
    while {! [eof $fd]} {
      set pos [tell $fd]
      gets $fd s
      if [regexp {^%\.(.*)>(.*)} $s match idx head] {
        lappend hlp(idx_list) "$head\xff$idx"
        set fhead 1
      } elseif [string match "%/*" $s] {
        lappend hlp(idx_list) "[string range $s 2 end] -> $head\xff$idx"
      } elseif $fhead {
        lappend hlp(ref_list) [list $idx [list $f $pos]]
        set fhead 0
      }
    }
    close $fd
  }
  set hlp(idx_list) [lsort $hlp(idx_list)]
}
    
proc ref_tell_old {filelist} {
  global hlp

  set context [scancontext create]
  scanmatch $context {^%\\(.*)>(.*)$} {
    lappend hlp(ref_list) [list $matchInfo(submatch0) \
      [list $file [tell $matchInfo(handle)]]]  
    lappend hlp(idx_list) \
      "$matchInfo(submatch1)\xff$matchInfo(submatch0)"
  }

  set hlp(ref_list) ""
  foreach file $filelist {
    set fd [open $file r]
    scanfile $context $fd
    close $fd
  }
  scancontext delete $context
  set hlp(idx_list) [lsort $hlp(idx_list)]
}

proc idx_find {w} {
  global hlp

  set l ""
  foreach ll $hlp(idx_list) {
    lappend l [lindex [split $ll \xff] 0]
  }
  if {[set i \
         [ListDlg .hlpdia $hlp(dlg_geom) "Select Item" $l]\
      ] > -1} {
    ref_find $w [lindex [split [lindex $hlp(idx_list) $i] \xff] 1] 
  }
}

proc hlp_Next {{delta 1}} {
  global hlp

  set l [llength $hlp(items)]
  incr l -1
  if {$l == 0} {return}
  set i [expr $hlp(sel) + $delta]
  if {$i > $l} {set i 1}
  if {$i < 1} {set i $l}
  if {$hlp(sel)} {
    .help.t tag configure ref$hlp(sel) -background steelblue
  }
  .help.t tag configure ref$i -background blue 
  .help.t yview -pickplace [lindex [.help.t tag ranges ref$i] 0]
  set hlp(sel) $i
} 

proc hlp_Copy {} {
  global hlp ted_buf

  set p [.help.t tag ranges tb]
  if {[llength $p] < 2} {return}
  set ted_buf [.help.t get [lindex $p 0] [lindex $p 1]]
}

proc hlp_Exit {} {
  global hlp

  destroy .help
  xfocus $hlp(old_focus)
}

proc help {{item main}} {
  global hlp

  if {$hlp(ref_list) == ""} {ref_tell [glob $hlp(dir)/*.hlp]}
  
  toplevel .help
  wm geometry .help +0+100
  wm title .help Help

  frame .help.m -relief raised -bd 1
  pack .help.m -fill x

  menubutton .help.m.file -text File -underline 0 -menu .help.m.file.m
  menu .help.m.file.m
  .help.m.file.m add command -label Exit -accelerator Esc -command hlp_Exit
  pack .help.m.file -side left -padx 5

  menubutton .help.m.help -text Help -underline 0 -menu .help.m.help.m
  menu .help.m.help.m
  .help.m.help.m add command -label Main -accelerator M \
    -command {ref_find .help.t main}
  .help.m.help.m add command -label Index -accelerator I \
    -command {idx_find .help.t}
  pack .help.m.help -side left -padx 5

  scrollbar .help.sb -command {.help.t yview}
  pack .help.sb -side right -fill y
  text .help.t -yscroll {.help.sb set}
  pack .help.t -fill both -expand true 

  bind .help.t <Tab>    {hlp_Next}
  bind .help.t <Shift-Tab> {hlp_Next -1}
  bind .help.t <Any-i> {idx_find .help.t}
  bind .help.t <Any-m> {ref_find .help.t main}
  bind .help.t <Control-c> {hlp_Copy}
  bind .help.t <Return> {ref_find .help.t [lindex $hlp(items) $hlp(sel)]} 
  bind .help.t <Escape> {hlp_Exit}
  bind .help.t <Prior> {
    .help.t mark set insert "insert - 15 l"
    .help.t yview insert
  }
  bind .help.t <Next> {
    .help.t mark set insert "insert + 15 l"
    .help.t yview insert
  }
  bind .help.t <Any-Key> { }

  tk_menuBar .help.m .help.m.file .help.m.help
  tk_bindForTraversal .help.t

  set hlp(old_focus) [focus]
  xfocus .help.t
  grab .help
  update
  set x [winfo rootx .help.t]
  set y [winfo rooty .help.t]
  set hlp(dlg_geom) 300x200+$x+$y

  ref_find .help.t $item 
}
