%% 
%% This is file `myletter.cls'
%% by Axel Kielhorn
%% a.kielhorn@tu-bs.de
%%
%% International Version 1.3g
%% 
%% This system is distributed in the hope that it will be useful, 
%% but WITHOUT ANY WARRANTY; without even the implied warranty of 
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
%% 
%% 
%% IMPORTANT NOTICE: 
%% 
%% 
%% You are not allowed to change this file. 
%% 
%% Anything you may want to configure should go into
%% the .cfg file. See default.cfg as example
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{myletter}
              [1994/10/24 v1.3g
               LaTeX letter class]
\newcommand\@ptsize{}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
    {\ClassError{Myletter}
    {Sorry, only a4paper supported!}
    {If you tell me how to calculate the right margins,\MessageBreak
    I will add different paper sizes}}
\DeclareOption{b5paper}
    {\ClassError{Myletter}
    {Sorry, only a4paper supported!}
    {If you tell me how to calculate the right margins,\MessageBreak
    I will add different paper sizes}}
\DeclareOption{letterpaper}
    {\ClassError{Myletter}
    {Sorry, only a4paper supported!}
    {If you tell me how to calculate the right margins,\MessageBreak
    I will add different paper sizes}}
\DeclareOption{legalpaper}
    {\ClassError{Myletter}
    {Sorry, only a4paper supported!}
    {If you tell me how to calculate the right margins,\MessageBreak
    I will add different paper sizes}}
\DeclareOption{executivepaper}
    {\ClassError{Myletter}
    {Sorry, only a4paper supported!}
    {If you tell me how to calculate the right margins,\MessageBreak
    I will add different paper sizes}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\if@bankhi \@bankhifalse
\newif\if@banklo \@banklofalse
\newif\if@german \@germanfalse	% Kludge! Beware!
\newif\if@ref \@reffalse
\DeclareOption{bankhigh}{\@bankhitrue}
\DeclareOption{banklow}{\@banklotrue}
\DeclareOption{german}
    {\ClassError{Myletter}
    {The option german is no longer valid!}
    {Use the usepackage command instead}}
\ExecuteOptions{a4paper,11pt,oneside,onecolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip         {0.7em}
\setlength\parindent       {0\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setlength\headheight      {12\p@}
\setlength\headsep         {45\p@}
\setlength\footskip        {25\p@}
\setlength\maxdepth        {.5\topskip}
\setlength\@maxdepth       \maxdepth
\setlength\textwidth       {450\p@}
\setlength\textheight      {650\p@}
\setlength{\@tempdima}     {\paperwidth}
\addtolength{\@tempdima}   {-2in}
\addtolength{\@tempdima}   {-\textwidth}
\setlength\oddsidemargin   {.5\@tempdima}
\setlength\evensidemargin  {\oddsidemargin}
\setlength\marginparwidth  {90\p@}
\setlength\marginparsep    {11\p@}
\setlength\marginparpush   {5\p@}
\setlength\topmargin       {-35\p@}
\setlength\footnotesep     {12\p@}
\setlength{\skip\footins}  {10\p@ \@plus 2\p@ \@minus 4\p@}
\newlength{\rightfield}
\setlength{\rightfield}    {42mm}
\newlength{\leftfield}
\setlength{\leftfield}     {\textwidth}
\addtolength{\leftfield}   {-\rightfield}
\newsavebox{\FIRM}
\newsavebox{\firm}
\newsavebox{\firmaddress}
\newsavebox{\FIRMHEAD}
\newsavebox{\firmreturn}
\newsavebox{\firmfoot}


\newif\if@fold
\@foldtrue
\def\foldmarkson{\@foldtrue}
\def\foldmarksoff{\@foldfalse}

\newdimen\foldhskip
\newdimen\foldvskipi
\newdimen\foldvskipii
\newdimen\foldvskipiii

\foldhskip 3.5mm
\foldvskipi 62mm % war: 65mm RTL
\foldvskipii 40.5mm
\foldvskipiii 58.5mm

\def\@foldmarks{\if@fold \bgroup
 \reversemarginpar\vspace{\foldvskipi}
 \marginpar{\hspace{\foldhskip}\rule{2mm}{.2pt}} \vspace{\foldvskipii}
 \marginpar{\hspace{\foldhskip}\rule{4mm}{.2pt}} \vspace{\foldvskipiii}
 \marginpar{\hspace{\foldhskip}\rule{2mm}{.2pt}}
 \vspace{-\foldvskipiii}\vspace{-\foldvskipii}\vspace{-\foldvskipi}
 \egroup \fi}


\def\Username{default}
\newcommand{\usename}[1]{\def\Username{#1}}

%% Defining the language-depending variables
%% Compatible to script_l
%% Now we don't have to wait for german.sty 2.4b :-)
%% you can still redefine them in the cfg-file

\AtBeginDocument{%
 \def\captionsenglish{%
  \def\yourrefname	{Your ref.}
  \def\yourmailname	{Your letter of}
  \def\myrefname	{Our ref.}
  \def\mymailname	{Our letter of}
  \def\customername	{Customer no.}
  \def\invoicename	{Invoice no.}
  \def\subjectname	{Subject}
  \def\ccname		{cc}
  \def\enclname		{encl}
  \def\headtoname	{To}
  \def\datename		{Date}
  \def\pagename		{Page}
  \def\telephonename	{Telephone}
  \def\telefaxname	{Telefax}}
 \let\captionsUSenglish=\captionsenglish
 \def\captionsgerman{%
  \def\yourrefname	{Ihr Zeichen}
  \def\yourmailname	{Ihr Schreiben vom}
  \def\myrefname	{Unser Zeichen}
  \def\mymailname	{Unser Schreiben vom}
  \def\customername	{Kundennummer}
  \def\invoicename	{Rechnungsnummer}
  \def\subjectname	{}
  \def\ccname		{Kopien an}
  \def\enclname		{Anlagen}
  \def\headtoname	{An}
  \def\datename		{Datum}
  \def\pagename		{Seite}
  \def\telephonename	{Telefon}
  \def\telefaxname	{FAX}}
 \let\captionsaustrian=\captionsgerman
 \def\captionsfrench{%
  \def\yourrefname	{Vos r\'ef\'erences}
  \def\yourmailname	{Votre lettre du}
  \def\myrefname	{Nos r\'ef\'erences}
  \def\mymailname	{Nos lettre du}
  \def\customername	{Num\'ero de client}
  \def\invoicename	{Num\'ero de facture}
  \def\subjectname	{Concernant}
  \def\ccname		{Copie \`a}
  \def\enclname		{Annexes}
  \def\headtoname	{A}
  \def\datename		{Date}
  \def\pagename		{Page}
  \def\telephonename	{Telephone}
  \def\telefaxname	{Telefax}}
 \def\dateenglish{\def\today{\number\day/\number\month/\number\year}}
 \def\dateUSenglish{\def\today{\number\month/\number\day/\number\year}}
 \def\dategerman{\def\today{\number\day.\,\number\month.\,\number\year}}
 \let\dateaustrian=\dategerman
 \let\datefrench=\dategerman
 \ifcase\language
  \captionsUSenglish
  \dateUSenglish
 \or
  \captionsgerman
  \dategerman
  \@germantrue		%Kludge! Beware!
 \or
  \captionsfrench
  \datefrench
 \fi
 \input{\Username.cfg}
}

\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@oddhead{\usebox{\firm}
         \hfil \@date \hfil \pagename{} \thepage}%
      \let\@evenhead\@oddhead
\else
  \def\ps@headings{%
      \let\@oddfoot\@empty
      \def\@oddhead{\usebox{\firm}
        %\ignorespaces\toname
         \hfil \@date \hfil \pagename{} \thepage}}
\fi
\def\ps@empty{%
      \let\@oddfoot\@empty\let\@oddhead\@empty
      \let\@evenfoot\@empty\let\@evenhead\@empty}
\def\ps@firstpage{%
     \setlength{\topmargin}{-35\p@}
     \setlength{\headheight}{36\p@}
     \setlength{\headsep}{15\p@}
     \let\@evenhead\@empty \let\@evenfoot\@empty
     \def\@oddhead{\parbox{\textwidth}{\usebox{\FIRMHEAD}}}
     \def\@oddfoot{\parbox{\textwidth}{\usebox{\firmfoot}}}
     \settoheight{\footskip}{\parbox{\textwidth}{\usebox{\firmfoot}}}
     \addtolength{\footskip}{20pt}
     }
\def\ps@plain{%
      \let\@oddhead\@empty
      \def\@oddfoot{\hfil\rmfamily\thepage\hfil}%
      \def\@evenfoot{\hfil\rmfamily\thepage\hfil}}

\def\name#1{\def\fromname{#1}}
\def\fromname{}
\def\signature#1{\def\fromsig{#1}}
\def\fromsig{}
\def\telephone#1{\def\telephonenum{#1}}
\def\telephonenum{}
\def\telefax#1{\def\telefaxnum{#1}}
\def\telefaxnum{}
\def\makelabels{%
  \AtBeginDocument{%
     \let\@startlabels\startlabels
     \let\@mlabel\mlabel
     \if@filesw
       \immediate\write\@mainaux{\string\@startlabels}\fi}%
  \AtEndDocument{%
     \if@filesw\immediate\write\@mainaux{\string\clearpage}\fi}}
\@onlypreamble\makelabels
\newenvironment{letter}[1]
  {\newpage
    \if@twoside
       \ifodd\c@page
       \else\thispagestyle{empty} \hbox{}\newpage
       \fi
    \fi
    \c@page\@ne
    \interlinepenalty=200 % smaller than the TeXbook value
    \@processto{\leavevmode\ignorespaces #1}}
  {\stopletter\@@par\pagebreak\@@par
    \if@filesw
      \begingroup
        \let\\=\relax
        \def\protect##1{\string##1\space}%
          \immediate\write\@auxout
            {\string\@mlabel{\returnaddress}{\toname\\\toaddress}}%
      \endgroup
    \fi}
\long\def\@processto#1{\@xproc #1\\@@@\ifx\toaddress\@empty
    \else \@yproc #1@@@\fi}
\long\def\@xproc #1\\#2@@@{\def\toname{#1}\def\toaddress{#2}}
\long\def\@yproc #1\\#2@@@{\def\toaddress{#2}}
\def\stopbreaks{\interlinepenalty \@M
   \def\par{\@@par\nobreak}\let\\=\@nobreakcr
   \let\vspace\@nobreakvspace}
\def\@nobreakvspace{\@ifstar{\@nobreakvspacex}{\@nobreakvspacex}}

\def\@nobreakvspacex#1{\ifvmode\nobreak\vskip #1\relax\else
               \@bsphack\vadjust{\nobreak\vskip #1}\@esphack\fi}

\def\@nobreakcr{\vadjust{\penalty\@M}\@ifstar{\@xnewline}{\@xnewline}}
\def\startbreaks{\let\\=\@normalcr
   \interlinepenalty 200\def\par{\@@par\penalty 200\relax}}

\def\opening#1{\thispagestyle{firstpage}%
  \vspace*{2\parskip}%
  \parbox[t]{\leftfield}%
  {\usebox{\firmreturn}\\
     \parbox[t][3.5cm][c]{\leftfield}
     {\fontsize{12}{14pt}\selectfont
       \ifx\@specialmail\@empty
       \else
         {\bfseries\@specialmail}\\[1ex]
       \fi
       \toname\\
       \toaddress
    }%
  }%
  \rightbox\par
  \vspace{2\parskip}
  \if@ref
    \parbox[t]{\textwidth}
    {
      \makebox[\textwidth][l]
      {\@yref \@ymail \@myref \@mymail \hfill \@refdate}\\[7mm]
      \ifx\@subject\@empty
        \makebox[\leftfield][l]{}%
      \else
        \makebox[\leftfield][l]{\@subject}%
      \fi%
    }%
  \else
    \parbox[t]{\textwidth}{%
     \ifx\@subject\@empty
     \else
       \makebox[\leftfield][l]{\@subject}%
     \fi
     \@date
    }%
  \fi
  \par
  \vspace{4\parskip}
  #1\par\nobreak %\@foldmarks
}

\long\def\closing#1{\par
  \vspace{\parskip}%
  \stopbreaks
  \noindent
  \parbox{\textwidth}{\raggedright
       \ignorespaces #1\par
       \vspace{6\medskipamount}%
       %\\[6\medskipamount]%
       \ifx\@empty\fromsig
           \fromname
       \else
           \fromsig
       \fi\strut}%
   \par}
\medskipamount=\parskip
\def\cc#1{\par\noindent
     \parbox[t]{\textwidth}
     {\@hangfrom{\reset@font\rm \ccname: }%
      \ignorespaces #1\strut}\par}
\def\encl#1{\par\noindent
     \parbox[t]{\textwidth}
     {\@hangfrom{\reset@font\rm \enclname: }%
      \ignorespaces #1\strut}\par}
\def\ps{\par\startbreaks}
\def\stopletter{}

%%
%% The definitions below are compatible to DIN 676,
%% you may change them in the cfg-file
%%
\def\yref#1{\def\@yref{\parbox[t]{.25\textwidth}
    {\scriptsize \yourrefname:\\ \normalsize #1}}
    \@reftrue}
\def\ymail#1{\def\@ymail{\parbox[t]{.25\textwidth}
    {\scriptsize \yourmailname:\\ \normalsize #1}}
    \@reftrue}
\def\myref#1{\def\@myref{\parbox[t]{.25\textwidth}
    {\scriptsize \myrefname:\\ \normalsize #1}}
    \@reftrue}
\def\mymail#1{\def\@mymail{\parbox[t]{.25\textwidth}
    {\scriptsize \mymailname:\\ \normalsize #1}}
    \@reftrue}

\def\refdatename#1{\def\@refdate{\parbox[t]{.2\textwidth}
   {\scriptsize #1\\ \normalsize \@date}}
\def\yref##1{\def\@yref{\parbox[t]{.2\textwidth}
    {\scriptsize \yourrefname:\\ \normalsize ##1}}
    \@reftrue}
\def\ymail##1{\def\@ymail{\parbox[t]{.2\textwidth}
    {\scriptsize \yourmailname:\\ \normalsize ##1}}
    \@reftrue}
\def\myref##1{\def\@myref{\parbox[t]{.2\textwidth}
    {\scriptsize \myrefname:\\ \normalsize ##1}}
    \@reftrue}
\def\mymail##1{\def\@mymail{\parbox[t]{.2\textwidth}
    {\scriptsize \mymailname:\\ \normalsize ##1}}
    \@reftrue}
   }

\def\subject#1{\def\@subject{{\subjectname\ \bfseries #1}}}

\def\@yref{}  \def\@ymail{}
\def\@myref{} \def\@mymail{}
\def\@subject{}
\def\@refdate{}

\def\specialmail#1{\def\@specialmail{#1}}
\def\@specialmail{}
\def\email#1{\def\@email{#1}}
\def\@email{}
\def\mailbox#1{\def\@mailbox{#1}}
\def\@mailbox{}

\def\returnaddress{}
\newcount\labelcount
\def\startlabels{\labelcount\z@
   \pagestyle{empty}%
   \let\@texttop\relax
   \topmargin -50\p@
   \headsep \z@
   \oddsidemargin -35\p@
   \evensidemargin -35\p@
   \textheight 10in
   \@colht\textheight  \@colroom\textheight \vsize\textheight
   \textwidth 550\p@
   \columnsep 25\p@
   \ifcase \@ptsize\relax
     \normalsize
   \or
     \small
   \or
     \footnotesize
   \fi
   \baselineskip \z@
   \lineskip \z@
   \boxmaxdepth \z@
   \parindent \z@
   \twocolumn\relax}
\let\@startlabels=\relax
\def\mlabel#1#2{\setbox0\vbox{\parbox[b]{3.6in}%
                                        {\strut\ignorespaces #2}}%
         \vbox to 2in{\vss \box0 \vss}}
\let\@mlabel=\@gobbletwo
\setlength\leftmargini  {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength\leftmarginvi {1em}
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {5\p@}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\setlength\partopsep{0\p@}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\def\@listI{\setlength\leftmargin{\leftmargini}
            \setlength\parsep {0\p@}%
            \setlength\topsep {.4em}%
            \setlength\itemsep{.4em}}
\let\@listi\@listI
\@listi
\def\@listii {\setlength  \leftmargin{\leftmarginii}%
              \setlength  \labelwidth{\leftmarginii}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listiii{\setlength  \leftmargin{\leftmarginiii}%
              \setlength  \labelwidth{\leftmarginiii}%
              \addtolength\labelwidth{-\labelsep}%
              \setlength  \topsep    {.2em}%
              \setlength  \itemsep   {\topsep}}
\def\@listiv {\setlength  \leftmargin{\leftmarginiv}%
              \setlength  \labelwidth{\leftmarginiv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listv  {\setlength  \leftmargin{\leftmarginv}%
              \setlength  \labelwidth{\leftmarginv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listvi {\setlength  \leftmargin{\leftmarginvi}%
              \setlength  \labelwidth{\leftmarginvi}%
              \addtolength\labelwidth{-\labelsep}}
\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\setlength\itemsep{\z@}%
                        \setlength\itemindent{-15\p@}%
                        \setlength\listparindent{\itemindent}%
                        \setlength\rightmargin{\leftmargin}%
                        \addtolength\leftmargin{15\p@}}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\setlength\listparindent{1.5em}%
                        \setlength\itemindent{\listparindent}%
                        \setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\arabic{equation}}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\relax}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\relax}
\renewcommand{\cal}{\protect\pcal}
\newcommand{\pcal}{\@fontswitch{\relax}{\mathcal}}
\renewcommand{\mit}{\protect\pmit}
\newcommand{\pmit}{\@fontswitch{\relax}{\mathnormal}}
\renewcommand\footnoterule{%
  \kern-\p@
  \hrule \@width .4\columnwidth
  \kern .6\p@}
\long\def\@makefntext#1{%
    \noindent
    \hangindent 5\p@
    \hbox to5\p@{\hss\@makefnmark}#1}

\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\raggedbottom
\let\@texttop\relax
\onecolumn

\endinput
%% End of file `myletter.cls'.
