#ifndef lint
static char rcsid[] = "$Header: /ful/chris/ctex_dist/lib/RCS/dviclass.c,v 1.3 84/05/29 01:27:40 chris Exp $";
#endif

/* dviclass - DVI code classification tables (only for chars 128-256) */

#include "dviclass.h"

/* this table contains the byte length of the single operand, or 0 if not
   valid */
char dvi_oplen[128] = {
    5, 6, 7, 4,			/* DVI_SET1 .. DVI_SET4 */
    0,				/* DVI_SETRULE */
    5, 6, 7, 4,			/* DVI_PUT1 .. DVI_PUT4 */
    0,				/* DVI_PUTRULE */
    0,				/* DVI_NOP */
    0,				/* DVI_BOP */
    0,				/* DVI_EOP */
    0,				/* DVI_PUSH */
    0,				/* DVI_POP */
    1, 2, 3, 4,			/* DVI_RIGHT1 .. DVI_RIGHT4 */
    0,				/* DVI_W0 */
    1, 2, 3, 4,			/* DVI_W1 .. DVI_W4 */
    0,				/* DVI_X0 */
    1, 2, 3, 4,			/* DVI_X1 .. DVI_X4 */
    1, 2, 3, 4,			/* DVI_DOWN1 .. DVI_DOWN4 */
    0,				/* DVI_Y0 */
    1, 2, 3, 4,			/* DVI_Y1 .. DVI_Y4 */
    0,				/* DVI_Z0 */
    1, 2, 3, 4,			/* DVI_Z1 .. DVI_Z4 */
    0,				/* DVI_FNTNUM0 (171) */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 172 .. 179 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 180 .. 187 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 188 .. 195 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 196 .. 203 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 204 .. 211 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 212 .. 219 */
    0, 0, 0, 0, 0, 0, 0, 0,	/* 220 .. 227 */
    0, 0, 0, 0, 0, 0, 0,	/* 228 .. 234 */
    5, 6, 7, 4,			/* DVI_FNT1 .. DVI_FNT4 */
    5, 6, 7, 4,			/* DVI_XXX1 .. DVI_XXX4 */
    5, 6, 7, 4,			/* DVI_FNTDEF1 .. DVI_FNTDEF4 */
    0,				/* DVI_PRE */
    0,				/* DVI_POST */
    0,				/* DVI_POSTPOST */
    0, 0, 0, 0, 0, 0,		/* 250 .. 255 */
};

char dvi_dt[128] = {
    DT_SET, DT_SET, DT_SET, DT_SET,	/* DVI_SET1 .. DVI_SET4 */
    0,					/* DVI_SETRULE */
    DT_PUT, DT_PUT, DT_PUT, DT_PUT,	/* DVI_PUT1 .. DVI_PUT4 */
    0,					/* DVI_PUTRULE */
    0,					/* DVI_NOP */
    0,					/* DVI_BOP */
    0,					/* DVI_EOP */
    0,					/* DVI_PUSH */
    0,					/* DVI_POP */
    DT_RIGHT,DT_RIGHT,DT_RIGHT,DT_RIGHT,/* DVI_RIGHT1 .. DVI_RIGHT4 */
    0,					/* DVI_W0 */
    DT_W, DT_W, DT_W, DT_W,		/* DVI_W1 .. DVI_W4 */
    0,					/* DVI_X0 */
    DT_X, DT_X, DT_X, DT_X,		/* DVI_X1 .. DVI_X4 */
    DT_DOWN, DT_DOWN, DT_DOWN, DT_DOWN,	/* DVI_DOWN1 .. DVI_DOWN4 */
    0,					/* DVI_Y0 */
    DT_Y, DT_Y, DT_Y, DT_Y,		/* DVI_Y1 .. DVI_Y4 */
    0,					/* DVI_Z0 */
    DT_Z, DT_Z, DT_Z, DT_Z,		/* DVI_Z1 .. DVI_Z4 */
    0,					/* DVI_FNTNUM0 (171) */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 172 .. 179 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 180 .. 187 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 188 .. 195 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 196 .. 203 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 204 .. 211 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 212 .. 219 */
    0, 0, 0, 0, 0, 0, 0, 0,		/* 220 .. 227 */
    0, 0, 0, 0, 0, 0, 0,		/* 228 .. 234 */
    DT_FNT, DT_FNT, DT_FNT, DT_FNT,	/* DVI_FNT1 .. DVI_FNT4 */
    DT_XXX, DT_XXX, DT_XXX, DT_XXX,	/* DVI_XXX1 .. DVI_XXX4 */
    DT_FNTDEF,DT_FNTDEF,DT_FNTDEF,DT_FNTDEF,/* DVI_FNTDEF1 .. DVI_FNTDEF4 */
    0,					/* DVI_PRE */
    0,					/* DVI_POST */
    0,					/* DVI_POSTPOST */
    0, 0, 0, 0, 0, 0,			/* 250 .. 255 */
};
