#! /usr/local/bin/python

# /***********************************************************
# Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
# Amsterdam, The Netherlands.
# 
#                         All Rights Reserved
# 
# Permission to use, copy, modify, and distribute this software and its 
# documentation for any purpose and without fee is hereby granted, 
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in 
# supporting documentation, and that the names of Stichting Mathematisch
# Centrum or CWI not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
# 
# STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# ******************************************************************/

# Print station call packets received from broadcast programs around the net.

import time
import string
import os
from stat import *
from socket import *
##from SOCKET import *

INFOPORT = 54317
BCASTCTLPORT = 54319

def main():
	s = socket(AF_INET, SOCK_DGRAM)
##	s.setsockopt(SOL_SOCKET, SO_BROADCAST, 1) # Python 0.9.7 or higher
	s.allowbroadcast(1) # Python 0.9.6
	s.bind('', INFOPORT)
	s.sendto('radio:s', ('<broadcast>', BCASTCTLPORT))
	while 1:
		data, sender = s.recvfrom(100)
		if data[:7] == 'radio:S':
			name, prt, tr, log, age, prg = decodeinfo(data)
			print name+':', prg,
			if age >= 0: print '(' + formatage(age) + ')',
			print
		elif data[:6] == 'radio:':
			print 'bad control packet:', `data`
		else:
			print 'bad packet received'


def formatage(age):
	if age < 60: return `age` + ' sec'
	if age < 3600: return `age/60` + ' min'
	if age < 24*3600: return `age/3600` + ' hrs'
	return `age/(24*3600)` + ' days'

def decodeinfo(data):
	fields = string.splitfields(data, ':')
	name = fields[2]
	port = eval(fields[3])
	if fields[4:]:
		transmitting = eval(fields[4])
		logfile = fields[5]
		age = eval(fields[6])
		contents = string.joinfields(fields[7:], ':')
	else:
		transmitting = -1
		programfile = '/ufs/' + name + '/CD'
		logfile = programfile + 'log'
		age = getage(programfile)
		if age == None:
			age = -1
		contents = getcontents(programfile)
		if contents == None:
			contents = '???'
	return name, port, transmitting, logfile, age, contents
	return None

def getcontents(filename):
	try:
		f = open(filename, 'r')
	except IOError:
		return None
	res = f.readline()
	f.close()
	return string.strip(res)

def getage(filename):
	try:
		st = os.stat(filename)
	except os.error:
		return None
	return time.time() - st[ST_MTIME]


try:
	main()
except KeyboardInterrupt:
	print
	print '[Interrupt]'
