.TH BROADCAST 1
.SH NAME
broadcast \- send audio UDP packets to be received by radio
.SH SYNOPSIS
.B broadcast
[
.B "\-a"
] [
.B "\-A"
] [
.BI "\-c " port
] [
.BI \-d
]
          [
.BI "\-m " ttl
] [
.BI \-n
] [
.BI "\-p " port
] [
.BI \-t
]
          [
.BI "\-L " logfile
] [
.BI "-N " name
] [
.BI "\P " programfile
] [
.BI \-s
]
          [
.IR addr [ :port ]
\&... ]

.SH DESCRIPTION
.I Broadcast
reads audio data in U-LAW format (8000 samples/second, 1 byte/sample,
logarithmically encoded) from standard input, chops it up into packets
of about 1400 bytes each, and transmits these as UDP broadcast packets.
On a typical ethernet, this uses about 1 percent of the net available
bandwith (less than 6 maximum-size packets per second).  If this is
still too much, the
.B \-a
option can cut the required bandwidth in half.
.PP
The program
.IR radio (1)
listens for these packets, reassembles them and makes the encoded
sound audible, given suitable hardware.
.PP
It is possible to use multiple transmission stations (each identified
by a different UDP port), and to transmit to multiple connected
subnets simultaneously, as long as the gateways let UDP broadcast
packets through.
Multiple transmission stations may reside on the same host, but on some
systems they need to have different control ports specified with the
\-c option.
.SH OPTIONS
.TP 10
.BR "\-a"
Use ADPCM (Adaptive Delta Pulse Code Modulation) to compress the audio data.
It sends out packets at the same rate, but the packet size is cut in
half.  This saves about 50 percent of the required network bandwidth,
at the cost of some CPU time (for the receivers as well as as for the
sender).  There is a slight degradation in sound quality, but the
quality is actually still quite good.  The receiver adapts itself
automatically to the data format.
.TP 10
.BR "\-A"
Use a variant on ADPCM (Adaptive Delta Pulse Code Modulation) which is
compatible the IVS program from INRIA.
.TP 10
.BI "\-c " port
Use this UDP port number as control port (default 54320).
Normally you never need to change this; the control port is used by
optional ``tuner'' software (distributed separately).
.TP 10
.B \-d
Turn on debugging (a message on stderr for each 8 packets sent).
.TP 10
.BI "\-m " ttl
Use this to specify a multicast TTL, to control how far the multicasts
will propagate.  A value of 0 restricts them to the same host,
1 to the same subnet, 32 to the same ``site,'' 64 to the same ``region,''
128 to the same continent, and 255 is unrestricted.  The default is 32.
Note that this option only has an effect if your machine supports multicasts
and you specify a multicast address to send to (or the default is a
multicast address).
.TP 10
.B \-n
No silence suppression.
Normally, when the input contains more than 20 seconds of silence,
output packets are suppressed until some noise is detected again.
This option turns off that feature.
.TP 10
.BI "\-p " port
Transmit to this UDP port number (default 54321).  When there is
than one transmission station on a single local area network, each
should use a different port number, else radio listeners will hear
interference (since they choose the station by its port number).  If
you choose ascending port numbers starting with the default, radio
listeners can use the shorthand
.BR "\-p 1" ,
.BR "\-p 2" ,
.BR "\-p 3"
and so on.
.TP 10
.B \-t
When the input is faster than real time, e.g., read from a file, this
option ensures that the packets are sent out at the correct rate (8000
bytes/sec).
Normally, it is presumed that the standard input takes care of this.
.TP 10
.BI "\-L " logfile
The filename of the file where recent program information is logged.
Typically, each time the current program information is changed it is
also appended to this file.
Default is $HOME/.CDlog.
.TP 10
.BI "\-N " name
The name of the station.
Default the current username.
.TP 10
.BI "\-P " programfile
The name of the file where current program information is kept (one line).
Typically, this file contains three colon-separated fields:
performer, composer, and title, where the composer field is only used
for classical music.
Default is $HOME/.CD.
.PP
The information passed with
.BR \-L ,
.BR \-N
and
.BR \-P
options (in the latter case the contents of the file) is regularly
transmitted in the form of a ``station call packet''.  Station call
packets are ignored by the receiving radio program, but may be picked
up by other programs to inform interested listeners, e.g.
.IR tuner (1)
and
.IR ektuner (1).
.PP
The remaining arguments are IP addresses to send to.
The default is either the local net broadcast address
or a multicast address assigned to radio if the host supports IP multicasts.
The address may be a host name (for unicast), an IP broadcast address
(addresses ending in either 0 or 255, depending on local convention)
or an IP multicast address (addresses beginning with 224). Optionally,
the address may be followed by a colon and a port number specifying
that the given port should be used when transmitting to this address.
Normally data is transmitted to the default port or the port given
with the
.B \-p
option.
More than one address may be given; the data is sent to each address.
.TP 10
.BI \-s
Start up in Audio File server mode.  If the program is compiled to
work with the Audio File system from DEC CRL this will tell the
program to read from the local server directly instead of from the
stdin.	
.SH TYPICAL USAGE
Due to the different interface to audio input hardware on different
systems, transmissions are started differently on different platforms.
.PP
To start transmissions on Sun Sparcs, run this command (probably in
the background, once you've debugged your audio setup):
.IP
broadcast -p \fIport\fP </dev/audio
.PP
You must connect a mono audio source to the machine using a standard
cable provided by Sun.
Control the input gain with
.IR x_gaintool (1)
or
.IP gaintool (1)
(these programs can be found in /usr/demo/SOUND in SunOS 4.1).
.PP
This command start transmissions on SGI IRIX:
.IP
recordulaw | broadcast -p \fIport\fP
.PP
Connect a stereo audio source to the machine using a standard walkman
jack.
If you're using an early 4D/35, check that you have audio hardware and
software installed -- the output from hinv will tell you this.
Control the the input gain with
.IR apanel (1).
.PP
On the NeXT you start transmissions as follows:
.IP
sndulaw | broadcast -p \fIport\fP
.PP
This takes input from the microphone; you may also connect an audio
source to the microphone input (probably needs some attenuation to get
the impedance right).
.SH FORWARDING
If nets A and B are connected by a gateway that blocks UDP broadcasts
but lets normal packets through, you can set up a forwarding station
as follows.
Assume A.1 is the host on net A where broadcasts originate, A.0 is the
broadcast address for net A, host B.1 is the forwarding host on net B,
and B.0 is net B's broadcast address.
(You will have to specify IP broadcast addresses in the decimal
.I ddd.ddd.ddd.ddd
format; usually the broadcast address for a net is the same as the IP
address for hosts on that net with the last byte changed to 0 or 255.)
On host A.1, run
.I broadcast
as follows:
.IP
broadcast A.0 B.1
.PP
On host B.1, run this pipeline:
.IP
radio -l B.1 -r A.1 -f | broadcast B.0
.PP
Now all hosts on nets A and B can listen to the broadcasts from host
A.1, at the cost of 100% extra (unicast) packets on both nets.
.PP
If the gateway lets UDP broadcast packets through, no forwarding is
necessary; running ``broadcast A.0 B.0'' on host A.1 is
sufficient.
.SH NOTE
On some systems it is not possible to have multiple receivers
listening to the same port on the same system. If you need this
functionality, for instance because you want to capture the news with
a dedicated program while still listening to the radio yourself, you
can use the folowing setup. Assume A is your local host and B the
local net:
.IP
broadcast B A:12000
.PP
This will allow you to listen to the radio on the default port (like
everyone else on the net) and your capture program to listen to port 12000.
.SH AUTHOR
Guido van Rossum
.SH VERSION
This manual page documents broadcast version 2.0, patchlevel 3.
.SH SEE ALSO
radio(1), tuner(1), ektuner(1)
.SH COPYRIGHT
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
