/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* svga bar display class interface definitions                           */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: s_bar_display.h,v 0.1 1995/04/15 18:38:04 drewvel Exp $

/*******************************************************************/
#ifndef __S_BAR_DISPLAYH_INC
#define __S_BAR_DISPLAYH_INC

#include "svga_display.h"

/*******************************************************************/
// SVGA Bar Display Class
/*******************************************************************/

/*******************************************************************/
class SVGA_Bar_Display:public SVGA_Display {
protected:
  boolean allocated;
  int length, lownum;
  BaseType *Bars;
   
  
  void AllocBars(int t);
  void AllocBarsType(BaseType** bars, int type, int num);
  void DeallocBars();

  void SetBarFreqs();
  void DrawFreqs();
  void SetBarExtents();

  float AvgFreq(int low, int high);
  float BarFreq(int barnum);

//  void UpdateFreqIndex();
  void UpdateIntervals();

  void DrawInit();

public:

  SVGA_Bar_Display(int n, Signal& S, 
		   aScreen &screen, int t=1,
		   boolean st=DEFLOGSCALE);
  ~SVGA_Bar_Display();

  void InitRange(int SizeScale=-1);
  
  void Reset();

  void RefreshFreqs();
  void DisplayChange();

  inline void Update()
  {
    for (int i=0; i<num; i++) 
      Bars[i].Update();
  }

  void ProcessControl(char control);

  void UpdateCoefficients();

  void Show();

  void ClearGraph();
  void RenewDisplayMethod(int t);
};

#endif __S_BAR_DISPLAYH_INC
