/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* svga 3d display class interface definitions                            */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: s_3d_display.h,v 0.1 1995/04/15 18:37:06 drewvel Exp $

/*******************************************************************/
#ifndef __S_3D_DISPLAYH_INC
#define __S_3D_DISPLAYH_INC

#include "svga_display.h"

#define DELTADEGREES 1.0
#define SIZEINC (DELTADEGREES/180.0*PI)


/*******************************************************************/
// SVGA Display 2D
// this needs a lot of work, but is supposed to 
// be a two-dimensional display of Fourier coefficients

// don't even try it, it needs to be rewritten
/*******************************************************************/

/*******************************************************************/
class SVGA_Display_2D:public SVGA_Display {
protected:
  int *FadeCols;
  int numcols, numsteps;
  void InitData();

public:
  SVGA_Display_2D(int n, Signal& S, 
	    aScreen &screen, boolean st=DEFLOGSCALE);

  ~SVGA_Display_2D() { if (FadeCols) delete [] FadeCols; }

  void Show();

  void UpdateCoefficients();
  
};


/*******************************************************************/
// only need this from here
#include "point3d.h"
/*******************************************************************/


/*******************************************************************/
// SVGA Display 3D
// This is base class which can be used to 
// derive 3 dimensional displays.  It contains
// some useful transformation functions (just
// enough though ;-))
/*******************************************************************/

/*******************************************************************/
class SVGA_Display_3D:public SVGA_Display {
protected:
  boolean perspective;
  float user_dist;
  int length, lownum, highnum;
  float RotX, RotY, RotZ;
  float TransX, TransY, TransZ;

  void InitRange(int SizeScale);

  void SetTransformConfig(globalConfig& config);
  void GetTransformConfig(globalConfig& config);
  
  // transformations
  // point scaling
  inline void ScalePoint3D(Point3D& p,
			   int& x, int& y);  

  // point rotation
  inline void RotatePoint3D_X(Point3D& p, float theta);
  inline void RotatePoint3D_Y(Point3D& p, float theta);
  inline void RotatePoint3D_Z(Point3D& p, float theta);

  // plotting functions
  inline void DrawPoint3D(Point3D& p, 
			  int color);
  inline void DrawLine3D(Point3D& p1, Point3D& p2, 
			 int color);
  inline void DrawLine3D(Point3D& p,
			 int color);

public:
  SVGA_Display_3D(int n, Signal& S, 
		  aScreen &screen, boolean st=DEFLOGSCALE);
    
  void ProcessControl(char control);
};


/*******************************************************************/
// 3D waveform display class

// NOTE: these are incomplete and really alpha

/*******************************************************************/

/*******************************************************************/
class SVGA_Waveform_Display_3D:public SVGA_Display_3D {
protected:
  short *savey, *savex;
  unsigned char *savecol;
  int numlines, size;
  unsigned char *FadeCols;
  int numsteps, numcols;
  int xinterval, yinterval, iinterval;
  int cur;

  void InitData();
  
public:
  SVGA_Waveform_Display_3D(int n, Signal& S, 
		  aScreen &screen, boolean st=DEFLOGSCALE);
  ~SVGA_Waveform_Display_3D();

  void Draw3DAxes();
  void ClearGraph();
  void DrawInit();
  
  void Show();

  void ProcessControl(char control);

  void UpdateCoefficients();  
};


/*******************************************************************/
// Continuous scrolling bar graph
/*******************************************************************/

/*******************************************************************/
class SVGA_Continuous_Waveform_Display_3D:public SVGA_Waveform_Display_3D {
protected:

public:
  SVGA_Continuous_Waveform_Display_3D(int n, Signal& S, 
				      aScreen &screen, boolean st=DEFLOGSCALE);
  ~SVGA_Continuous_Waveform_Display_3D();


  void Show();

  void ProcessControl(char control);

  void UpdateCoefficients();  
};

#endif __S_3D_DISPLAYH_INC
