/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* inlined 3D point stuff                                                 */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: point3d.h,v 0.1 1995/01/28 20:48:12 root Exp $

#ifndef __POINT3DH_INC
#define __POINT3DH_INC

struct Point3D {
  float x, y, z;

  Point3D() { x=y=z=0; }
  Point3D(float X, float Y, float Z) : x(X), y(Y), z(Z) { }
  ~Point3D() { }

  void set(float X, float Y, float Z) 
    { x=X; y=Y; z=Z; }

  Point3D& operator = (Point3D& o)
    { 
      x=o.x; y=o.y; z=o.z;
      return *this; 
    }

  Point3D operator + (Point3D& o)
    {
      return Point3D(x+o.x, y+o.y, z+o.z);
    }

  Point3D operator + (float o)
    {
      return Point3D(x+o, y+o, z+o);
    }

  Point3D operator - (Point3D& o)
    {
      return Point3D(x-o.x, y-o.y, z-o.z);
    }

  Point3D operator - (float o)
    {
      return Point3D(x-o, y-o, z-o);
    }

  Point3D operator * (Point3D& o)
    {
      return Point3D(x*o.x, y*o.y, z*o.z);
    }

  Point3D operator * (float o)
    {
      return Point3D(x*o, y*o, z*o);
    }

  Point3D operator / (Point3D& o)
    {
      return Point3D(x/o.x, y/o.y, z/o.z); 
    }

  Point3D operator / (float o)
    {
      return Point3D(x/o, y/o, z/o); 
    }  
};

#endif __POINT3DH_INC
