/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* various runtime text                                                   */
/**************************************************************************/

/**************************************************************************

    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: helptxt.cc,v 1.6 1995/04/15 05:47:09 drewvel Exp $             

#include "configuration.h"
#include "defvals.h"

char *gProgInfo=
VERSION
" ALPHA, Copyright (C) 1995 Andrew Veliath\n"
"svgafft comes with ABSOLUTELY NO WARRANTY.\n"
"See man page for detailed usage information.\n"
;

char *gAnalyzerHelpText=
"analyzer controls\n"
"-----------------\n"
"y, u, i\t\tswitch to line, bar or 3D graph\n"
"l\t\ttoggle logarithmic scale for amplitude axis\n"
";\t\ttoggle logarithmic scale for frequency axis\n"
"<space>\t\tclear graph\n"
"[, ]\t\t- or + attenuation\n"
"{, }\t\t- or + sampling rate\n"
"b\t\ttoggle bit resolution (16 or 8 bits)\n"
"z\t\tzero vpos and set scale to defaults\n"
"d\t\trevert to defaults given on command-line\n"
"w\t\ttoggle Hanning windowing\n"
"c\t\trun auto-calibration for current bit resolution\n"
"j, k, J, K\t+ or - low or high frequency range\n"
"f\t\tflush signal buffer\n"
"<, >\t\tless or more labels\n"
"p\t\tpause display\n"
"x\t\tturn spectrum analyzer off (exit)\n"
"?\t\tdisplay this screen (includes mode specifics)"
;


char *gDisplayHelpText=
"inherited controls\n\n"
"base display controls\n"
"---------------------\n"
"s\t\tsave options\n";
;

char *gSVGADisplayHelpText=
"SVGA display controls\n"
"---------------------\n"
"~\t\tswitch to 320x200x256\n"
"!\t\tswitch to 640x480x256\n"
"@\t\tswitch to 800x600x256\n"
"#\t\tswitch to 1024x768x256\n"
;

char *gSVGABarDisplayHelpText=
"SVGA bar display controls\n"
"-------------------------\n"
"1\t\tswitch to continuous bar graph\n"
"2\t\tswitch to segmented bar graph\n"
"3\t\tswitch to one segment bar graph\n"
"4\t\tswitch to segmented peak-drop bar graph\n"
"5\t\tswitch to one segment peak-drop bar graph\n"
"6\t\tswitch to fading segment bar graph\n"
#ifdef RUNTIME_BARCHANGE
"\nRuntime bar changing enabled.\n"
#else
"\nRuntime bar changing DISABLED.\n"
#endif
;


char *gSVGADisplay3DHelpText=
"SVGA 3D display controls\n"
"------------------------\n"
"1\t\trotate x-axis -\n"
"2\t\trotate x-axis +\n"
"3\t\treset x-axis to default value\n"
"4\t\trotate y-axis -\n"
"5\t\trotate y-axis +\n"
"6\t\treset y-axis to default value\n"
"7\t\trotate z-axis -\n"
"8\t\trotate z-axis +\n"
"9\t\treset z-axis to default value\n"
"P\t\ttoggle perspective on/off\n"
;


char *gSVGAWaveformDisplay3DHelpText=
"SVGA 3D waveform display controls\n"
"---------------------------------\n"
"&, *\t\t-/+ x-interval\n"
"(, )\t\t-/+ y-interval\n"
;
