/**************************************************************************/
/* svgafft --  Spectrum Analyzer                                          */
/*                                                                        */ 
/* configuration header file                                              */
/**************************************************************************/

/**************************************************************************
 
    Copyright (C) 1995 Andrew Veliath

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


***************************************************************************/

// $Id: configuration.h,v 0.6 1995/04/15 05:43:57 drewvel Exp $             

#ifndef _CONFIGURATION_INCLUDED
#define _CONFIGURATION_INCLUDED

#include "bars.h"

//#define DEBUG

/*******************************************************************/
#ifdef DEBUG
#define DOUT(a) {cout << "DEBUG: " << a << endl;}
#else
#define DOUT(a) {}
#endif DEBUG
/*******************************************************************/

/*******************************************************************/
#define DEFSCALE 8
#define LOGATTEN (gConfig.Bits8.val ? 1 : 512)
/*******************************************************************/

/*******************************************************************/
typedef signed char sample8;
typedef signed short sample16;

#define NUMBITS (gConfig.Bits8.val?8:16)

#include "barconfig.h"
#include "bools.h"

#define CALSAMPSIZE 16384
#define NUMCALSAMPLES 10

/*******************************************************************/
#endif _CONFIGURATION_INCLUDED
