/* Syncstruct.h
 *------------------------------------------------------------*
 * HISTORY
 *    10-Mar-89 Fil Alleva (alleva) at Oregon Graduate Center
 *       - Added _pad1_ field to SYNC so that the structure
 *       would be the same size when compule on the sun3 and sun4
 *       architectures. NB. this does not effect sun4 code.
 *       - Added conditional include symbols.
 *      
 *    Created - Mike Phillips and Bob Brennan at Carnegie Mellon.
 */

#ifndef _SYNCSTRUCT_H_
#define _SYNCSTRUCT_H_


typedef	struct
{
    int		ref;		/* reference adc pitch point */
    short	size;		/* number of adc points in this point */
    short	dist;		/* distance to last frame in adc points */
    short	syncflag;	/* flag saying if frame is pitch sync */
    short	framesize;	/* spectral size of frame */
    short	*frame;		/* usual frame info entire spectrum */
    short	enersize;	/* number of energy points */
    short       _pad1_;         /* Padding so that Sun4 and Sun3 structs are
				 * same size */
    short	*ener;		/* usual energy info and extra space */
} SYNC;

/*
 *	syncflag explanation:
 *
 *	This flag should be filled by whatever routine you call
 *	to produce a pitch syncronous representation.
 *	This doesn't mean syncrep but the routine you call that
 *	you supply pitch information to.
 *
 *	The flags mean:
 *
 *	0:	routine doesn't know.
 *	1:	completely default (doesn't start or end on pitch)
 *	2:	pitch syncronous (starts and ends on pitch)
 *			may not be the correct pitch!
 *	3:	starts on pitch but does not end on pitch.
 */

#endif _SYNCSTRUCT_H_

