/*--------------------------------------------------------------*
 * AD.H - ad header description
 *--------------------------------------------------------------*
 * HISTORY
 */

#ifndef _AD_H_
#define _AD_H_

struct ad_head {
    short ad_hdrsize;			/* Size of header, including this
				         * this field, in short words */
    short ad_version;
    short ad_channels;
    short ad_rate;			/* In quarter usec */
    int   ad_samples;
    int	  little_indian;		/* True if least significant byte is
					 * byte 0, ie. Vax byteorder */
};

#define CURRENT_AD_VERSION	1

#define ADA_RANGE		(1<<16)
#define QUS_PER_MS		4000	/* Quarter usec / msec */

#define SAMPS_PER_MS(r)		(QUS_PER_MS/(r))

typedef struct ad_head ad_head_t;

#endif _AD_H_
