/* card.c 
 * io code for the RadioTrack Program 
 * Gideon le Grange, 1994 
 * this is the code that does the actual talking to the card 
 * 1994-11-17 - first success with switching card on and off 
 * 1994-11-18 - put in different tables for on and off   
 * 1994-11-20 - finally figured out how card works 
 *            - no more tables 
 *            - freq converted to bitmap which is sent to the card 
 * 1994-11-22 - removed debugging code. this module is now stable. i hope */

#include "port.h"
#include "card.h"
#include <unistd.h>

unsigned short read_card(int sub_port)
{
   /* reads a byte in from the card */
   unsigned short value;
   
   value=port_in(RadioBase+sub_port);
   return(value);
}

void write_card(int sub_port, unsigned short value)
{
   /* writes a byte to the card */
   port_out(value,RadioBase+sub_port);
}

void CardOff(void)
{
   /* switch card off */
   write_card(0,0x00);
   write_card(0,0x00);
}

void VolumeDown(void)
{
   /* vol down a notch */
   write_card(0,0x48);
   usleep(100000);
   write_card(0,0xc8);
}

void VolumeUp(void)
{
   /* vol up a notch */
   write_card(0,0x88);
   usleep(100000);
   write_card(0,0xc8);
}

void Tune(float freq)
{
   /* tunes the radio to the desired frequency */
   unsigned long int bits;
   int i,mask;
   
   bits=(freq*40)+10486188;
   /* yes, i know. now where does THAT come from? 
    * working out that bits=(freq*multiplier)+base 
    * was hard, and working out the base and multiplier
    * was tricky. */
   mask=1;
   for (i=0; i<24; ++i)
     {
	if ((bits&mask)==0)
	  {
	     /* 0 bit */
	     write_card(0,0x1);
	     write_card(0,0x1);
	     write_card(0,0x3);
	     write_card(0,0x3);
	  }
	else
	  {
	     /* bit is 1 */
	     write_card(0,0x5);
	     write_card(0,0x5);
	     write_card(0,0x7);
	     write_card(0,0x7);
	  }
	mask=mask*2;
     }
   /* termination sequence? */
     write_card(0,0x0);
     write_card(0,0xc8);
}
