# $Id: config.tcl,v 1.7 1994/07/10 04:09:25 shendrix Exp $
#
# Tickle Music configuration and variable setup
# 

# debugging
set tmdebug 0

# where is the tickle music lib dir?
set codelib /usr/local/lib/tmusic

# where is the tcl main program
set program "/usr/local/bin/tmusic"

# default mod file directory
set modlib "/pub/ModFiles/"

# default midi directory
set midilib "/pub/Midi"

# set the library to one of the above (or wherever)
set library $midilib

# command to play modfiles
set gmod "/usr/local/bin/gm"

# options for above
set gmodopts "-x -z -l"

# extensions to tell a mod file, screamtracker, and other PCM files
set modext ".s3m .mod .MOD .S3M"

# command to play a midi file
set midi "/usr/local/bin/pmid2"

# options for above
set midiopts ""

# extensions for recognized midi files
set midext ".md1 .mid .midi .mtm"

#set type mod

#set sdir [ pwd ]

# default song playing
set songplaying "NOTHING"

# init songlist
set songlist {}

# get current process id
set spid [pid]

# boolean value used in stopping the song queue
set stoptheq 0

# borders for all widgets
set border 1
