/*********************************************************************************************************************************
* It's the SoundSmith player by Hemlock Solmes and The Arch Druid Allanon of T.S.I.  It is far from complete and it is really    *
* hacked together.  Allanon did the background/foreground signal stuff, the original command argument parser, most of the        *
* keypress stuff, the jump to next position effect, and provided extremely valuable information on the Ensoniq DOC, the GS, and  *
* SoundSmith.  He also provided a hell of a lot of songs so I could test the program, and wrote the decompression library which  *
* I still have yet to fully incorporate (I'll get around to it eventually =) ).                                                  *
* I did pretty much most of everything else (player, loader, instrument reader, DOC RAM loader, etc).                            *
*                                                                                                                                *
* I don't think either of us could have gotten this far with the project without the information provided by:                    *
*                                                                                                                                *
* Linus Torvalds           (Creator of the best operating system yet:  Linux)                                                    *
* Hannu Savolainen         (Systems programmer and author of the Voxware sound driver)                                           *
* Ian Schmidt              (Systems programmer and hacker for the Apple IIGS)                                            *
* Philip Stephens          (Systems programmer and hacker for the Apple IIGS)                                                                                  *
*                                                                                                                                *
* Our thanks goes to you.                                                                                                        *
*                                                                                                                                *
* A note:  all source files are formatted with 4 space tabs.  Also, we used a 132 column terminal.  We wish it had been wider at *
* times.                                                                                                                         *
*                                                                                                                                *
* If you would like to help with the player, read the README file and send mail to one of us.                                    *
*                                                                                                                                *
* Hope ya like it.  Remember:  Live free or die!                                                                                 *
* Written sometime in the latter half of 1994.                                                                                   *
*********************************************************************************************************************************/
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
#include <sys/ultrasound.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <termios.h>
#include <time.h>
#include <gus.h>

#include "Globals.h"
#include "compress.h"
#include "SSmith.h"
#include "asif.h"
#include "inst.h"

SEQ_DEFINEBUF(1024);	/* (no longer) value given in example in <sys/soundcard.h> */

int32			mixer_volume = 100;
boolean			debugging_output = FALSE;	/* output debugging information?			*/
boolean			tracker_output = FALSE;		/* output song information?					*/
boolean			sync_output = TRUE;			/* synchronize player with sound output?	*/
boolean			repeat_song = FALSE;		/* repeat song infinitely?					*/
boolean			stereo_output = TRUE;		/* play in stereo?							*/
boolean			old_ss_arpeg = FALSE;		/* use the original SoundSmith arpegiattos?	*/
boolean			foreground = TRUE;			/* are we in the foreground?				*/
boolean			verbose_flag = FALSE;		/* print out inst names?					*/
char			*ss_inst_dir = "", *ss_music_dir = "";

int32			seqfd, mixerfd, gus_dev, tempo, tempo1;
SSmith_song		*song = NULL;
chnl			volume, instrument;
boolean			sample_ok[16] = {FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};
arpegiatto		arpeg[14];
volume_ramp		volramp[14];
boolean			do_oldarpeg = FALSE, do_newarpeg = FALSE;
void			(*old_backgrounder)(int);
void			(*old_foregrounder)(int);

void	backgrounder(int sig);
void	foregrounder(int sig);


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/

void backgrounder(int sig)
	{
	foreground = FALSE;
/*	SEQ_STOP_TIMER();*/		/* Supposed to cause player to stop while in the background.
							 * It currently doesn't do anything (ie, there is no code for it in the
							 * sounddriver. */
	terminal_set(1);
	signal(SIGTSTP, old_backgrounder);	/* calling old_backgrounder directly segfaults, so...	*/
	raise(SIGTSTP);
	old_backgrounder = signal(SIGTSTP, backgrounder);
	}

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/

void foregrounder(int sig)
	{
	foreground = TRUE;
	signal(SIGCONT, old_foregrounder);	/* calling old_foregrounder directly segfaults, so...	*/
	raise(SIGCONT);
	old_foregrounder = signal(SIGCONT, foregrounder);
	terminal_set(0);
/*	SEQ_CONTINUE_TIMER();*/	/* This isn't used for the same reason that SEQ_STOP_TIMER doesn't work
							 * properly */
	}

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* terminal_set is used to reset the terminal for blocking or non-blocking I/O */

void terminal_set (int32 mode)
	{
	static long old_flags;
	static struct termios old_termio;
	struct termios new_termio;

	/* if the mode is 0, set non-blocking I/O so we can read stdin 1 char at a time */
	if (mode == 0)
		{
		/* not really raw */
		old_flags = fcntl (0, F_GETFL);
		fcntl (0, F_SETFL, old_flags | O_NONBLOCK);
		tcgetattr (0, &old_termio);
		new_termio = old_termio;
		new_termio.c_lflag = 0;
		new_termio.c_cc[VTIME] = 0;
		new_termio.c_cc[VMIN] = 0;
		tcsetattr (0, TCSANOW, &new_termio);
		}
	else
		{
		fcntl (0, F_SETFL, old_flags);
		tcsetattr (0, TCSANOW, &old_termio);
		}
	}



/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Initialize some basic stuff, like the sound driver, so we can access the sequencer and the mixer.
** Yes, the error messages are sortof rude, I haven't bothered to change them since my original test phase.
*/

void init_stuff(void)
	{
	int32	counter, mixer_dev_mask, num_synths;
	struct synth_info	info;

	srand(getpid());	/* seed "random" number generator by process ID */
	
	/* Open the sequencer device for reading and writing */
	if ((seqfd = open ("/dev/sequencer", O_RDWR, 0)) == -1)
		{
		fprintf(stderr, "Unable to open /dev/sequencer.  Tough luck, eh?\n");
		free(song);
		exit (-1);
		}

	/* Get the number of synth supported by the sequencer */
	if (ioctl (seqfd, SNDCTL_SEQ_NRSYNTHS, &num_synths) == -1)
		{
		fprintf(stderr, "An I/O error occured while accessing /dev/sequencer.  You lose\n");
		free(song);
		close(seqfd);
		exit (-1);
		}

	/* Make sure we have a Gravis Ultrasound, since at the time this is written it is the only device supported by the sound
	 * driver that allows us to upload our own instruments. */
	for (counter = 0; counter < num_synths; counter++)
		{
		info.device = counter;

		if (ioctl (seqfd, SNDCTL_SYNTH_INFO, &info) == -1)
			{
			fprintf(stderr, "Error $%04x has occured trying to get some info.  Too bad.\n", rand() % 65536);
			free(song);
			close(seqfd);
			exit (-1);
			}

		if (info.synth_type == SYNTH_TYPE_SAMPLE && info.synth_subtype == SAMPLE_TYPE_GUS)
			gus_dev = counter;
		}

	/* If a GUS isn't found, inform the user that they need to get one. */
	if (gus_dev == -1)
		{
		fprintf(stderr, "You know, we couldn't find a GUS.  Do you know what that means?\n"\
						"IT MEANS THAT YOU ARE GOING TO HAVE TO GET ONE!!!!!\n");
		free(song);
		close(seqfd);
		exit (-1);
		}

	/* Open the mixer device for reading and writing so we can do global volume control. */
	if ((mixerfd = open ("/dev/mixer", O_RDWR, 0)) == -1)
		{
		fprintf(stderr, "Unable to open /dev/mixer.  You don't get volume control!\n");
		}
	else
		{
		/* Now that we know that it exists, does it support volume control? */
		ioctl (mixerfd, SOUND_MIXER_READ_DEVMASK, &mixer_dev_mask);
		if (!(mixer_dev_mask & SOUND_MASK_SYNTH))
			{
			fprintf (stderr, "Did you know that /dev/mixer does not support volume control?\n");
			close (mixerfd);
			mixerfd = -1;
			}
		}
		                                                         
		      
	ioctl (seqfd, SNDCTL_SEQ_SYNC, 0);					/* ? from s3mod										*/
	ioctl (seqfd, SNDCTL_SEQ_RESETSAMPLES, &gus_dev);	/* reset samples to 0								*/

	GUS_NUMVOICES (gus_dev, 32);						/* allocate all channels to turn them all off		*/

	for (counter = 0; counter < 32; counter++)			/* go through all channels and turn stuff off		*/
		{
		GUS_VOICEOFF (gus_dev, counter);				/* stop the voice from playing (if it is)			*/
		GUS_RAMPOFF (gus_dev, counter);					/* end any volume ramps that might be taking place	*/
		}
	SEQ_DUMPBUF ();										/* force the event buffer to be read				*/
	}

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Free data allocated for the global "song" structure */

void free_song(void)
	{
	if (song->patterns != NULL)
		free(song->patterns);
	if (song != NULL)
		free(song);
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Shutdown the sound driver, close devices, empty the event buffer, reset terminal to blocking I/O, etc */

void shutdown(int foo)
	{
	int32	outcount, dump_enabled = 0, counter;

	terminal_set(1);
	
DEBUG(	printf("We are in shutdown!\n");
)
	do
		{
		if (!dump_enabled)
			{
			dump_enabled = 1;
			_seqbufptr = 0;
			ioctl(seqfd, SNDCTL_SEQ_RESETSAMPLES, &gus_dev);
			ioctl(seqfd, SNDCTL_SEQ_RESET, 0);

			GUS_NUMVOICES (gus_dev, 32);				/* allocate all channels to turn them all off	*/

			for (counter = 0; counter < 32; counter++)	/* go through all channels and turn stuff off	*/
				{
				GUS_VOICEOFF (gus_dev, counter);
				GUS_RAMPOFF (gus_dev, counter);
				}
			SEQ_DUMPBUF ();
			}
		ioctl (seqfd, SNDCTL_SEQ_GETOUTCOUNT, &outcount);
DEBUG(		printf("%d  <== (should be 1024!)\n", outcount);
)		} while (outcount != 1024);
	SEQ_DUMPBUF();
	close(seqfd);
	SEQ_STOP_TIMER();
	if (mixerfd != -1)
		close(mixerfd);


	if (foo == SIGTERM || foo == SIGKILL || foo == SIGINT)
		{
		free_song();
		exit(0);
		}
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* An almost identical function when compared to the original (and to findinstrument), changed to use compression lib */

char *SS_FindMusicFile(char *the_music)
	{
	char	*path, *dir;
	int32u	len1 = 0, len2 = 0;
	FILE	*file = NULL;
	
	if ((dir = getenv("SS_MUSIC_DIR")) != NULL)
		len1 = strlen(dir);
	
	if ((len2 = strlen(SS_MUSIC_DIR)) > len1)
		len1 = len2;
	
	if ((len2 = strlen(ss_music_dir)) > len1)
		len1 = len2;
	
	path = NEW_ARRAY(char, len1 + strlen(the_music) + 2);
	strcpy(path, the_music);
	
	/* check in current dir */
	if (file == NULL)		/* duh! */
		file = fopen(the_music, "rb");
	
	/* check in command line dir */
	if (((dir = ss_music_dir) != NULL) && (file == NULL))
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_music);
		file = fopen(path, "rb");
		}
	
	/* check in environment dir */
	if (((dir = getenv("SS_MUSIC_DIR")) != NULL) && (file == NULL))
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_music);
		file = fopen(path, "rb");
		}

	/* check in compile time dir */
	if (((dir = SS_MUSIC_DIR) != NULL) && (file == NULL))
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_music);
		file = fopen(path, "rb");
		}
	
	if (file != NULL)
		{
		fclose(file);
		return path;
		}
	else
		return NULL;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Find the location of an ASIF instrument and return a file pointer for it */

FILE *findinstrument(char *the_inst)
	{
	char	*path, *dir;
	int32u	len1 = 0, len2 = 0;
	FILE	*file = NULL;
		
	/* A really twisted way to make sure we allocate enough space for the full name of the file */
	if ((dir = getenv("SS_INST_DIR")) != NULL)				/* The environment variable dir		*/
		len1 = strlen(getenv("SS_INST_DIR"));
	
	if ((len2 = strlen(SS_INST_DIR)) > len1)				/* The hard coded dir				*/
		len1 = len2;
	
	if ((len2 = strlen(ss_inst_dir)) > len1)				/* The user specified dir			*/
		len1 = len2;
	
	path = NEW_ARRAY(char, len1 + strlen(the_inst) + 2);	/* allocate space for the filename	*/
	
	/* Attempt to find/open the instrument in order of most important directory */
	if (((dir = ss_inst_dir) != NULL) && (file == NULL))	/* Check the user specified dir		*/
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_inst);
		file = fopen(path, "rb");
		}
	
	if (((dir = getenv("SS_INST_DIR")) != NULL) && (file == NULL))	/* Next to the environment	*/
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_inst);
		file = fopen(path, "rb");
		}

	if (((dir = SS_INST_DIR) != NULL) && (file == NULL))	/* Try the hard coded one			*/
		{
		strcpy(path, dir);
		strcat(path, "/");
		strcat(path, the_inst);
		file = fopen(path, "rb");
		}
	
	if (file == NULL)										/* Lastly, try the current dir		*/
		file = fopen(the_inst, "rb");
	
	free(path);												/* Free some RAM					*/
	return file;											/* return, hopefully successful		*/
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* See if we can find a GS DOC RAM image.  DOC RAM images named are <file>.DOC, <file>.D, <file>.W, or DOC.DATA; I don't know    */
/* why.*/

FILE *check_for_DOC_RAM(char *song_file)
	{ /* Check for DOC RAM image */
	FILE	*doc_ram;
	char	*ptr, *ptr1;
	char	path[512];
	long	i;
	
	if ((ptr = strrchr(song_file, (int) '/')) == NULL)
		strcpy(path, song_file);
	else
		strcpy(path, ptr);
	ptr = path + strlen(path);

	strcat(path, ".DOC");
	if ((doc_ram = findinstrument(path)) != NULL)
		return doc_ram;

	*ptr = '\0';
	strcat(path, ".D");
	if ((doc_ram = findinstrument(path)) != NULL)
		return doc_ram;

	*ptr = '\0';
	strcat(path, ".W");
	if ((doc_ram = findinstrument(path)) != NULL)
		return doc_ram;

	strcpy(path, "DOC.DATA");
	if ((doc_ram = findinstrument(path)) != NULL)
		return doc_ram;

	return NULL;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Load a DOC RAM image to the GUS sound RAM.  This routine is a quick hack just so i could do it. */

boolean upload_DOC_RAM(FILE *the_file)
	{
	struct patch_info	*pr;
	int32				counter, datacounter, num_inst, start, length;
	int8u				*doc_ram, flag = 0;
	boolean				swap_mode_flag = FALSE, sorted_flag;
	INST_wavelist		*Awavelist, *Bwavelist;
	
	if (the_file == NULL)
		return FALSE;

	printf("Loading DOC RAM image.\n");

	doc_ram = NEW_ARRAY(int8u, 65536);
	num_inst = GET_INT16L(the_file);
	Awavelist = NEW_ARRAY(INST_wavelist, num_inst);
	Bwavelist = NEW_ARRAY(INST_wavelist, num_inst);
DEBUG(	printf("Number of instruments in DOC RAM image = %d\n", num_inst);
)
	for (counter = 0; counter < 65536; counter++)
		doc_ram[counter] = GET_INT8(the_file);

	THRASH_BYTES(the_file, 32);	/* skip number of wavelists (always 1 and 1) */
	for (counter = 0; counter < num_inst; counter++)
		{
		Awavelist[counter].topkey = GET_INT8(the_file);
		Awavelist[counter].waveaddress = GET_INT8(the_file);
		Awavelist[counter].wavesize = GET_INT8(the_file);
		Awavelist[counter].docmode = GET_INT8(the_file);
		Awavelist[counter].relpitch = GET_INT16L(the_file);

		Bwavelist[counter].topkey = GET_INT8(the_file);
		Bwavelist[counter].waveaddress = GET_INT8(the_file);
		Bwavelist[counter].wavesize = GET_INT8(the_file);
		Bwavelist[counter].docmode = GET_INT8(the_file);
		Bwavelist[counter].relpitch = GET_INT16L(the_file);

		THRASH_BYTES(the_file, 80);	/* garbage to next set of lists */
		}
	fclose(the_file);					/* we don't need it open anymore, so close it */

	for (counter = 0; counter < 15; counter++)
		{
		if (!strcmp(song->header.instBlock[counter].instName, ""))
			{
			sample_ok[counter + 1] = FALSE;
			flag += 1;
			}
		else
			{
			start = Awavelist[counter - flag].waveaddress * 256;
			length = 0;
			while (doc_ram[start + length] != '\0')
				length++;

			pr = (struct patch_info *)malloc(sizeof(struct patch_info) + length);
										/* get space for data of patch record		*/
	
			pr->key = GUS_PATCH;		/* the key value should always be GUS_PATCH	*/
			pr->device_no = gus_dev;	/* device #									*/
			pr->instr_no = counter + 1;	/* instrument #								*/
			
			handle_DOCmode(pr, Awavelist[counter - flag].docmode, Bwavelist[counter - flag].docmode, length);
			
			pr->len = length;			/* length of sample							*/
			pr->base_freq = 40035;		/* base frequency * 5						*/
			pr->base_note = 314415;		/* our Middle C frequency * 5				*/
			pr->low_note = 0;			/* value from gmod							*/
			pr->high_note = 1280000;
			
			pr->panning = 0;			/* the instrument is centered, the channels might not be */
			 
			pr->detuning = 0;			/* no info on this; value from mod			*/
			
			pr->tremolo_sweep = 0;
			pr->tremolo_rate = 0;
			pr->tremolo_depth = 0;
			pr->vibrato_sweep = 0;
			pr->vibrato_rate = 0;
			pr->vibrato_depth = 0;
			pr->scale_frequency = 64;	/* an idea from SDK docs					*/
			pr->scale_factor = 1024;	/* from 0 to 2048 or 0 to 2; specify midi notes 1 semitone apart*/
			pr->volume = song->header.instBlock[counter].volume;	/* It's the volume	*/
			
			for (datacounter = start; datacounter < start + length; datacounter++)
				pr->data[datacounter - start] = doc_ram[datacounter];
		
			SEQ_WRPATCH(pr, sizeof(struct patch_info) + length);
			free(pr);
			sample_ok[counter + 1] = TRUE;
			}
		}
	free(doc_ram);
	free(Awavelist);
	free(Bwavelist);
	return TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Load an instrument into GUS RAM */

void upload_instrument(int32 inst_num, char *inst_name)
	{
	FILE				*asif_file;
	int32				chunk_type = 0, counter;
	FORM_chunk			form;
	INST_chunk			inst;
	WAVE_chunk			wave;
	struct patch_info	*pr;		/* we need a patch record					*/
	int32u				length = 0;	/* length of instrument						*/
	char				path[512];
	boolean				swap_mode_flag = FALSE;
	

	if (!strcmp(inst_name, ""))		/* null name, load null instrument			*/
		{
		sample_ok[inst_num] = FALSE;
		return;
		}

	if ((asif_file = findinstrument(inst_name)) == NULL)
		{
		fprintf(stderr, "Ack!  I couldn't find the instrument file: \"%s\"!!\n  Loading a null instrument in its place.\n", inst_name);
		sample_ok[inst_num] = FALSE;
		return;
		}


	read_FORMchunk(asif_file, &form);
DEBUG(	printf(	"FORM id:   %s\n" \
		"FORM size: %d\n" \
		"FORM type: %s\n", form.id, form.size, form.type);
)
	/* Search through instrument file and load read in various chunks */
	while (!feof(asif_file))
		{
		chunk_type = GET_INT32L(asif_file);
		switch (chunk_type)
			{
			case CHAR4('I', 'N', 'S', 'T'):
				read_INSTchunk(asif_file, &inst);
DEBUG(				printf(	"INST id:       INST\n" \
					"INST size:     %d\n" \
					"INST name:     %s\n" \
					"INST sample #: %d\n" \
					"INST ENVELOPE stage 0 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 1 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 2 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 3 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 4 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 5 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 6 breakpoint %d\tincrement %3d %3d\n" \
					"INST          stage 7 breakpoint %d\tincrement %3d %3d\n" \
					"INST release segment:    %d\n" \
					"INST priority increment: %d\n" \
					"INST pitchbend range:    %d\n" \
					"INST vibrato depth:      %d\n" \
					"INST vibrato speed:      %d\n" \
					"INST Awave count:        %d\n" \
					"INST Bwave count:        %d\n",
						inst.size, inst.name, inst.samplenum,
						inst.stage[0].breakpoint, inst.stage[0].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[1].breakpoint, inst.stage[1].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[2].breakpoint, inst.stage[2].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[3].breakpoint, inst.stage[3].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[4].breakpoint, inst.stage[4].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[5].breakpoint, inst.stage[5].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[6].breakpoint, inst.stage[6].increment >> 8, inst.stage[0].increment & 0xf,
						inst.stage[7].breakpoint, inst.stage[7].increment >> 8, inst.stage[0].increment & 0xf,
						inst.releasesegment, inst.priorityincrement,
						inst.pitchbendrange, inst.vibratodepth,
						inst.vibratospeed, inst.Awavecount, inst.Bwavecount);
				printf ("INST Awave list:\n");
				for (counter = 0; counter < inst.Awavecount; counter++)
					{
					printf(	"  Awavelist[%3d].topkey:          %d\n" \
						"  Awavelist[%3d].waveaddress:     %d\n" \
						"  Awavelist[%3d].wavesize:        %d\n" \
						"  Awavelist[%3d].docmode:         %d\n" \
						"  Awavelist[%3d].relpitch:        %d\n",
							counter, inst.Awavelist[counter].topkey,
							counter, inst.Awavelist[counter].waveaddress,
							counter, inst.Awavelist[counter].wavesize,
							counter, inst.Awavelist[counter].docmode,
							counter, inst.Awavelist[counter].relpitch);
					}
				printf ("INST Bwave list:\n");
				for (counter = 0; counter < inst.Bwavecount; counter++)
					{
					printf(	"  Bwavelist[%3d].topkey:          %d\n" \
						"  Bwavelist[%3d].waveaddress:     %d\n" \
						"  Bwavelist[%3d].wavesize:        %d\n" \
						"  Bwavelist[%3d].docmode:         %d\n" \
						"  Bwavelist[%3d].relpitch:        %d\n",
							counter, inst.Bwavelist[counter].topkey,
							counter, inst.Bwavelist[counter].waveaddress,
							counter, inst.Bwavelist[counter].wavesize,
							counter, inst.Bwavelist[counter].docmode,
							counter, inst.Bwavelist[counter].relpitch);
					}
)				break;
			case CHAR4('W', 'A', 'V', 'E'):
				read_WAVEchunk(asif_file, &wave);
DEBUG(				printf(	"WAVE id:          WAVE\n" \
					"WAVE chunk size:  %d\n" \
					"WAVE name:        %s\n" \
					"WAVE wave size:   %d\n" \
					"WAVE num samples: %d\n",
						wave.chunksize, wave.name, wave.wavesize,
						wave.numsamples);
				for (counter = 0; counter < wave.numsamples; counter++)
					{
					printf(	"WAVE SAMPLE\n" \
						"WAVE   location(offset from start): %d\n" \
						"WAVE   size (DOC pages):            %d\n" \
						"WAVE   original frequency:          $%08x\n" \
						"WAVE   sampling rate:               $%08x\n",
							wave.sampletable[counter].location, wave.sampletable[counter].size,
							wave.sampletable[counter].origfreq, wave.sampletable[counter].samprate);
					}
)				break;
			case CHAR4('N', 'A', 'M', 'E'):
DEBUG(				puts("NAME Name chunk");
)				read_NAMEchunk(asif_file);
				break;
			case CHAR4('A', 'U', 'T', 'H'):
DEBUG(				puts("AUTH Author chunk");
)				read_AUTHchunk(asif_file);
				break;
			case CHAR4('(', 'c', ')', ' '):
DEBUG(				puts("(c)  Copyright chunk");
)				read_COPYchunk(asif_file);
				break;
			case CHAR4('A', 'N', 'N', 'O'):
DEBUG(				puts("ANNO Annotation chunk");
)				read_ANNOchunk(asif_file);
				break;
			default:
DEBUG(				puts("Unknown chunk");
)				read_genericchunk(asif_file);
				break;
			}
		}

	while ((wave.data[length] != 0) && (length < wave.wavesize))	/* get size knowing that 0 will stop the wave from playing */
		length++;

	length = MIN(((wave.sampletable[0].size + 1) * 256), length);
	length -= wave.sampletable[0].location;

	pr = (struct patch_info *)malloc(sizeof(struct patch_info) + length);
								/* get space for data of patch record		*/
	
	pr->key = GUS_PATCH;		/* the key value should always be GUS_PATCH	*/
	pr->device_no = gus_dev;	/* device #									*/
	pr->instr_no = inst_num;	/* instrument #								*/

	handle_DOCmode(pr, inst.Awavelist[0].docmode, inst.Bwavelist[0].docmode, length);
	
	pr->len = length;			/* length of sample							*/

/*	pr->base_freq = 8007 * 5;*/
/*	pr->base_note = 62883 * 5;*/	/* Middle C								*/
	pr->base_freq = 40035;
	pr->base_note = 314415;		/* Middle C									*/
	pr->low_note = 0;			/* value from gmod							*/
	pr->high_note = 1280000;	/* not used by the sound driver; a guess	*/
	
	pr->panning = 0;			/* center instrument, channels might not be centered	*/
	pr->detuning = 0;			/* no info on this; value from mod			*/
	
	pr->tremolo_sweep = 0;
	pr->tremolo_rate = 0;
	pr->tremolo_depth = 0;
	pr->vibrato_sweep = 0;
	pr->vibrato_rate = 0;
	pr->vibrato_depth = 0;
	pr->scale_frequency = 64;	/* an idea from SDK docs					*/
	pr->scale_factor = 1024;	/* from 0 to 2048 or 0 to 2, specify midi notes 1 semitone apart*/
	pr->volume = song->header.instBlock[inst_num - 1].volume;	/* It's the volume	*/
	
	for (counter = wave.sampletable[0].location; counter < (length + wave.sampletable[0].location); counter++)
		pr->data[counter - wave.sampletable[0].location] = wave.data[counter];

	SEQ_WRPATCH(pr, sizeof(struct patch_info) + length);
	fclose(asif_file);
	free(wave.data);
	free(wave.sampletable);
	free(inst.Awavelist);
	free(inst.Bwavelist);
	free(pr);
	sample_ok[inst_num] = TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Finally!  At long last!  I know, sort of, how to handle the doc mode! */

void handle_DOCmode(struct patch_info *pr, int8u Adocmode, int8u Bdocmode, int32u length)
	{
	if (((DOC(Adocmode) == DOC_SWAP) && (DOC(Bdocmode) == DOC_SWAP)) ||
		((DOC(Adocmode) == DOC_SWAP) && (DOC(Bdocmode) == DOC_FREERUN)) ||
		((DOC(Adocmode) == DOC_ONESHOT) && (DOC(Bdocmode) == DOC_SWAP)) ||
		((DOC(Adocmode) == DOC_FREERUN) && (DOC(Bdocmode) == DOC_FREERUN)) &&
		(length >= 2))
		{
		pr->mode = WAVE_UNSIGNED | WAVE_LOOPING;
		pr->loop_start = 0;
		pr->loop_end = length - 1;
		}
	else
		{
		pr->mode = WAVE_UNSIGNED;
		pr->loop_start = 0;
		pr->loop_end = 0;
		}
	}

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Load and parse the song file.  Modified to use Ethan's spiffy compress lib. */

boolean load_ssm(Compress_File *the_song)
	{
	FILE		*musicfile;
	int32		inst, tmp;

	if ((musicfile = Compress_FOpen(the_song->archive->filename, the_song->name)) == NULL)
		{
		fprintf(stderr,	"Sorry, song file doesn't exist or you don't have read access for it.\n");
		return FALSE;
		}

	/* use some space that we already have allocated */
	fread(song->header.instBlock[0].instName, 1, 6, musicfile);
	song->header.instBlock[0].instName[6] = '\0';

DEBUG(	printf("File identifier: \"%s\"\n", song->header.instBlock[0].instName);
)	if (strcmp(song->header.instBlock[0].instName, "SONGOK"))
		{
		fprintf(stderr, "Bad song record.  Please get a new copy or else.\n" \
						"The file will not be played.\n");
		fclose(musicfile);
		return FALSE;
		}
	
	song->header.length = GET_INT16L(musicfile);			/* length of song						*/
	song->header.tempo = GET_INT16L(musicfile);				/* default song tempo; a row is			*/
															/* played every tempo/50th of a sec		*/

	THRASH_BYTES(musicfile, 10);							/* reserved								*/
	for (inst = 0; inst < 15; inst++)
		{
		tmp = GET_INT8(musicfile);							/* find length of string				*/
		fread(song->header.instBlock[inst].instName, 1, tmp, musicfile);
		song->header.instBlock[inst].instName[tmp] = '\0';	/* null terminate the string			*/
		THRASH_BYTES(musicfile, (21 - tmp));				/* thrash the rest of space for string	*/
		THRASH_BYTES(musicfile, 2);							/* toast the reserved bytes 			*/
		song->header.instBlock[inst].volume = GET_INT16L(musicfile) & 0xff;	/* get volume			*/
		if (!strcmp(song->header.instBlock[inst].instName, ""))
			song->header.instBlock[inst].volume = 127;
		THRASH_BYTES(musicfile, 4);							/* reserved								*/
		}

	song->header.positions = GET_INT16L(musicfile);
	printf("Number of positions: $%02x (%d)\n", song->header.positions, song->header.positions);
	printf("Number of patterns:  $%02x (%d)\n", song->header.length/(64*14), song->header.length/(64*14));

	for (inst = 0; inst < 128; inst++)			/* use the 'inst' variable to save 4 bytes of RAM	*/
		{
		song->header.sequence[inst] = GET_INT8(musicfile);
		}

	load_patterns(musicfile);						/* load the pattern data						*/

	for (inst = 0; inst < 15; inst++)
		{
		song->header.instBlock[inst].stereo = GET_INT16L(musicfile);
		/* Some music files don't have stereo data recorded properly.  A theory that is sort of proven, but it sounds good
		 * anyway so I haven't changed it yet. */
		song->header.instBlock[inst].stereo = ((int16)((int16u)(-song->header.instBlock[inst].stereo) + 0x7fff)) >> 8;
		}

	fclose(musicfile);
VERBOSE(
	for (inst = 0; inst < 15; inst++)
		{
		printf("Instrument %2d: %s\n", inst + 1, song->header.instBlock[inst].instName);
		}
)
DEBUG(
	printf("Song length: %d\n", song->header.length);
	printf("Song tempo: %d\n", song->header.tempo);
	for (inst = 0; inst < 15; inst++)
		{
		printf("Instrument %d\n", inst + 1);
		printf("  Name: \"%s\"\n", song->header.instBlock[inst].instName);
		printf("  Volume: %d\n", song->header.instBlock[inst].volume);
		printf("  Original panning: %04x\n", (int16u)song->header.instBlock[inst].stereo);
		printf("  Converted panning: %d\n", song->header.instBlock[inst].stereo);
		}

	for (inst = 0; inst < 128; inst++)				/* use the 'inst' variable to save RAM	*/
		{
		printf("%02x  ", song->header.sequence[inst]);
		}
	printf("\n");
)
	sample_ok[0] = FALSE;
	if (upload_DOC_RAM(check_for_DOC_RAM(the_song->name)) == FALSE)	/* load DOC RAM if we have it	*/
		for (inst = 0; inst < 15; inst++)
			upload_instrument(inst + 1, song->header.instBlock[inst].instName);

	return TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Load pattern data into RAM so we can have something to play */

/* It is assumed that the file pointer is at the correct place in the file.  If it's not, things will get messed up. */
void load_patterns(FILE *musicfile)
	{
	int32	block, pat, row, channel;

	song->patterns = NEW_ARRAY(SSmith_pat, song->header.length/(64*14));
	for (block = 0; block < 3; block++)	/* load each block into RAM.  Notes, Effect1, & Effect2	*/
		{
		for (pat = 0; pat < song->header.length/(64*14); pat++)	/* number of patterns to load	*/
			{
			for (row = 0; row < 64; row++)					/* 64 rows							*/
				{
				for (channel = 0; channel < 14; channel++)	/* 14 channels						*/
					{
					song->patterns[pat][row][channel] <<= 8;
					song->patterns[pat][row][channel] += GET_INT8(musicfile);
					}
				}
			}
		}
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Ahh.  The really hacked up (several times over) playing routine.  A note of warning:  It gets confusing here.
** Someday I'll write a routine that buffers effects to make things nicer and easier to expand.
** Most of the background/foreground/signal and speed modifying keypress stuff added by Ethan.
** The reason that I don't use select to wait for the sequencer buffer to be readable is because it doesn't work properly
** on my system (Linux).  This is a known bug in Linux.  So, to work around the bug I use read().  The only problem with
** this is that if something else is sucking CPU time the player may jump a bit.  A better solution to all of this would be
** to use a timer driven playing system.  I did this.  And everyone else whose tried to do this knows why we don't =( .
*/

int32u play_ssm(void)
	{
	int32			pos, row, channel, counter;
	int32			keypress, effect, tempo2;
	int32			row_absolute = 0;
	int32u			byte;
	chnl			note;
/*	timeval			timeout;
	fd_set			readfds, writefds, exceptfds;*/


	do_oldarpeg = FALSE;
	do_newarpeg = FALSE;

	tempo = (song->header.tempo) << 1;				/* mul by 2 to compensate for 100 Hz timer			*/
	tempo1 = tempo;									/* value to add to tempo each time we need to wait	*/
	
	SEQ_START_TIMER();								/* start the 100 Hz timer							*/

	SEQ_VOLUME_MODE(gus_dev, VOL_METHOD_LINEAR);	/* set volume to linear rather than adagio			*/

	for (channel = 0; channel < 14; channel++)
		{
		GUS_VOICEOFF(gus_dev, channel);
		SEQ_BENDER_RANGE (gus_dev, channel, 8191);
/*		SEQ_SET_PATCH(gus_dev, channel, 0);*/
		SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (255 * 16383) / 100);
		SEQ_PANNING(gus_dev, channel, 0);
		instrument[channel] = 0;
		arpeg[channel].x = 0;
		arpeg[channel].y = 0;
		arpeg[channel].new = FALSE;
		arpeg[channel].old = FALSE;
		}

	SEQ_WAIT_TIME(tempo);							/* make sure we're at the correct time				*/

	do
		{
		for (pos = 0; pos < song->header.positions; pos++)
			{
TRACK(		printf("Position:% 3d   Pattern:% 3d\n", pos, song->header.sequence[pos]);
)			for (row = 0; row < 64; row++)
				{
				tempo2 = tempo1;
				if ((keypress = getchar()) != -1)
					switch (keypress)
						{
						case '+':					/* increase volume													*/
							modify_mixer_volume(1);
							break;
						case '-':					/* decrease volume													*/
							modify_mixer_volume(-1);
							break;
						case '8':					/* fast forward one position										*/
							if ((pos < song->header.positions - 1) || (repeat_song == TRUE))
								keypress = 0x08000000;
							break;
						case '6':					/* fast forward one row												*/
							if (row < 63)
								tempo2 = tempo1 >> 1;
							break;
						case '5':					/* rewind one position												*/
							if (pos > 1)
								{
								pos -= 2;
								keypress = 0x08000000;
								}
							else if (repeat_song == TRUE)
								{
								pos = song->header.positions - 2 + pos;
								keypress = 0x08000000;
								}
							break;
						case '4':					/* rewind one row													*/
							if (row > 1)
								{
								row -= 2;
								tempo2 = tempo1 >> 1;
								}
							else if (pos > 0)
								{
								pos--;
								row += 64 - 2;
								tempo2 = tempo2 >> 1;
								}
							break;
						case '>':
							return NEXT_SONG;
							break;
						case '<':
							return PREV_SONG;
							break;
						case 't':
							if (tracker_output)
								tracker_output = FALSE;
							else
								tracker_output = TRUE;
							break;
						case 'm':
							if (stereo_output == TRUE)
								{
								stereo_output = FALSE;
								for (counter = 0; counter < 14; counter++)
									{
									SEQ_PANNING(gus_dev, counter, 0);
									}
								}
							else
								{
								stereo_output = TRUE;
								for (counter = 0; counter < 14; counter++)
									{
									SEQ_PANNING(gus_dev, counter, song->header.instBlock[instrument[counter] - 1].stereo);
									}
								}
							break;
						case 'p':					/* pause player														*/
							while (getchar() == -1);
							tempo = 0;
							SEQ_START_TIMER();
							break;
						case 26:					/* ^Z, go to background												*/
							/*SEQ_STOP_TIMER();*/
							raise(SIGTSTP);
							/*SEQ_CONTINUE_TIMER();*/
							tempo = 0;				/* a hack because SEQ_STOP_TIMER and SEQ_CONTINUE_TIMER don't work	*/
							SEQ_START_TIMER();		/* reset the timer to zero, and continue playing					*/
							break;
						case 'q':					/* quit																*/
						case 3:						/* ^C																*/
							free_song();
							shutdown(0);
							exit(EXIT_SUCCESS);
							break;
						default:
							break;
						}
				if (keypress == 0x08000000)
					break;							/* continuation of "fast forward"									*/
				for (keypress=0 ; (getchar()!=EOF) && (keypress<50) ; keypress++);	/* clear keyboard buffer (hopefully)	*/
				
				if (foreground)
					{
					for (channel = 0; channel < 14; channel++)	/* play all channels									*/
						{
						effect = song->patterns[song->header.sequence[pos]][row][channel];
						note[channel] = (effect & 0xff0000) >> 16;
	
						if ( ((int8u)((effect & 0x00f000) >> 12) != instrument[channel]) && ((int8u)((effect & 0x00f000) >> 12) != 0) )
							{
							instrument[channel] = (int8u)((effect & 0x00f000) >> 12);
							GUS_VOICEOFF(gus_dev, channel);
							if (sample_ok[instrument[channel]])
								{
								SEQ_SET_PATCH(gus_dev, channel, instrument[channel]);
								volume[channel] = song->header.instBlock[instrument[channel] - 1].volume;
								SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (volume[channel] * 16383) / 100);
								if (stereo_output)
									{
									SEQ_PANNING(gus_dev, channel, song->header.instBlock[instrument[channel] - 1].stereo);
									}
								else
									{
									SEQ_PANNING(gus_dev, channel, 0);
									}
								}
							}
						else
							/* No sense in reseting instrument if it's the same one, so just reset the volume */
							{
							if ((((effect & 0x00f000) >> 12) == instrument[channel])
								&& (volume[channel] != song->header.instBlock[instrument[channel] - 1].volume))
								{
								volume[channel] = song->header.instBlock[instrument[channel] - 1].volume;
								SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (volume[channel] * 16383) / 100);
								}
							}
	
						if(note[channel] == 128)
							{
							GUS_VOICEOFF(gus_dev, channel);
							}
						else
							{
							if ((note[channel] != 0) && (sample_ok[instrument[channel]] == TRUE))
								{
								SEQ_START_NOTE(gus_dev, channel, note[channel], volume[channel]);	/* play a note	*/
								}
							}
		
						do_effect(channel, (int16u)(effect & 0xfff));
	
TRACK(					printf("%06lx ", effect & 0xffffff);
						fflush(stdout);		/* Sorry, Xterm messes up without this if asynchronous and track are true	*/
)						}
					}
TRACK(			printf("\n");
)	
				/* Handle argegiatos: the evil nasty way */
				if (do_newarpeg == TRUE)
					{
					SEQ_WAIT_TIME(tempo + (tempo2 / 3));
					
					for (channel = 0; channel < 14; channel++)
						if (arpeg[channel].new == TRUE)
							SEQ_PITCHBEND(gus_dev, channel, arpeg[channel].x);
					
					SEQ_WAIT_TIME(tempo + ((tempo2 << 1) / 3));
					
					for (channel = 0; channel < 14; channel++)
						if (arpeg[channel].new == TRUE)
							SEQ_PITCHBEND(gus_dev, channel, arpeg[channel].y);
					
					tempo += tempo2;			/* inc the amount of time we need to wait		*/
					SEQ_WAIT_TIME(tempo);		/* wait until timer reaches the time of tempo	*/
					
					if (!old_ss_arpeg)
						{
						for (channel = 0; channel < 14; channel++)
							{
							if (arpeg[channel].new == TRUE)
								{
								SEQ_PITCHBEND(gus_dev, channel, 0);
								arpeg[channel].new = FALSE;
								}
							}
						}
					else
						{
						for (channel = 0; channel < 14; channel++)
							{
							if (arpeg[channel].new == TRUE)
								{
								SEQ_PITCHBEND(gus_dev, channel, arpeg[channel].x + arpeg[channel].y);
								arpeg[channel].new = FALSE;
								}
							}
						}
					}
				else
					{
					tempo += tempo2;			/* inc the amount of time we need to wait		*/
					SEQ_WAIT_TIME(tempo);		/* wait until timer reaches the time of tempo	*/
					}
				
				/* Another hack.  Handle jump to next pattern.  Use keypress to save a variable.*/
				keypress = 0;
				for (channel = 0; channel < 14; channel++)
					if (((song->patterns[song->header.sequence[pos]][row][channel] & 0xffffff) == 0x810000) && ((pos != song->header.positions - 1) || (repeat_song == TRUE)))
						keypress = 1;	/* necessary for some FTA demo songs and others as well	*/
				if (keypress == 1)
					break;

SYNC(			SEQ_ECHO_BACK(CHAR4('\n', '\n', '\n', '\n'));	/* I can echo back anything I want							*/
				SEQ_DUMPBUF();									/* force the sound driver to read the event buffer			*/
				read(seqfd, &byte, 4);							/* will wait till we can read stuff; yes 'byte' is 4 bytes	*/
)				}
TRACK(		printf("\n");
)			}
		if (repeat_song)
			printf("Song repeating.\n");
		} while (repeat_song == TRUE);
	do_oldarpeg = FALSE;
	do_newarpeg = FALSE;
	return NEXT_SONG;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Ahh.  The wonderful routine that may or may not handle all the effects properly.  I can't seem to get anyone to tell me
** how I'm supposed to handle them exactly.  So, it's mostly intuition and a lot of listening and watching tracker output to
** come up with it.
*/

void do_effect(int32 channel, int16u effect)
	{
	switch ((effect & 0xf00) >> 8)
		{
		case FX_ARPEGIATTO:
		case FX_OLD_ARPEGIATTO:
			if ((effect & 0xff) != 0)
				{
				arpeg[channel].x = ((effect & 0xf0) >> 4) * 100;	/* x offset	*/
				arpeg[channel].y = (effect & 0xf) * 100;			/* y offset	*/
				arpeg[channel].new = TRUE;
				do_newarpeg = TRUE;
				}
			break;
		case FX_SET_VOLUME:
			volume[channel] = effect & 0xff;
			SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (volume[channel] * 16383) / 100);
			break;
		case FX_SUB_VOLUME:
			if (volume[channel] <= (effect & 0xff))
				volume[channel] = 0;
			else
				volume[channel] -= effect & 0xff;
			SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (volume[channel] * 16383) / 100);
			break;
		case FX_ADD_VOLUME:
			if (volume[channel] >= (255 - effect & 0xff))
				volume[channel] = 255;
			else
				volume[channel] += effect & 0xff;
			SEQ_CONTROL(gus_dev, channel, CTL_MAIN_VOLUME, (volume[channel] * 16383) / 100);
			break;
		case FX_SET_TEMPO:
			tempo1 = (effect & 0xff) << 1;	/* mul by 2 to compensate for the 100 Hz clock */
			break;
		default:
			break;
		}
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Change the volume */

void modify_mixer_volume(int32 delta_volume)
	{
	int32	tmp_volume;

	if (mixerfd != -1)
		{
		ioctl (mixerfd, MIXER_READ (SOUND_MIXER_SYNTH), &mixer_volume);	/* do this in case people use 'mixer' or similar program */
		mixer_volume &= 0xff;
		mixer_volume += delta_volume;
		if (mixer_volume > MIXER_MAX_VOL)
			mixer_volume = MIXER_MAX_VOL;
		else if (mixer_volume < MIXER_MIN_VOL)
			mixer_volume = MIXER_MIN_VOL;
		tmp_volume = mixer_volume * 256 + mixer_volume;
		ioctl (mixerfd, MIXER_WRITE (SOUND_MIXER_SYNTH), &tmp_volume);
		}
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Wow, bet ya can't guess what this one does. */

void alloc_channels(void)
	{
	ioctl (seqfd, SNDCTL_SEQ_SYNC, 0);

	GUS_NUMVOICES (gus_dev, 14);		/* allocate the minimum # of channels (also the # we need) */

	SEQ_DUMPBUF ();
	ioctl (seqfd, SNDCTL_SEQ_SYNC, 0);
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* This function must be provided by the user in order to dump the event buffer*/

void seqbuf_dump (void)
	{
	if (_seqbufptr)
		if (write (seqfd, _seqbuf, _seqbufptr) == -1)
			{
			perror ("write /dev/sequencer");	/* Something a normal person would write =) */
			free_song();
			shutdown(0);
			exit (-1);
			}
	_seqbufptr = 0;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Print the argument usage for the program */

void print_usage(char *argv)
	{
	printf(	"SoundSmith Linux v0.0.2 by Hemlock Solmes and The Great Druid Allanon of T.S.I\n" \
			"%s [-v<volume> -d -r -s -t -h -pl<pan%%>r<pan%%>] song\n" \
			"  -v<volume>         set master volume to <volume>\n" \
			"                     %d <= volume <= %d\n" \
			"  -d                 turn on debugging output\n" \
			"  -V                 be verbose (prints instrument names)\n" \
			"  -r                 repeat song indefinitely\n" \
			"  -m                 turn stereo playback off\n" \
			"  -t                 turn on tracker output\n" \
			"  -a                 turn on asynchronous output\n" \
			"  -o                 use the old method for the arpegiatto effect\n" \
			"  -R                 play songs in random order\n" \
			"  -pl<pan%%>r<pan%%>   set stereo panning: 100 means full right or left,\n" \
			"                     0 means centered.  \'l\' applies to all left channels,\n" \
			"                     \'r\' applies to all right channels.  This option is\n" \
			"                     stupid when stereo playback is turned off.  ****Currently\n" \
			"                     this option is unimplemented, like a lot of other things =)\n" \
			"  -I                 specify an alternate instrument directory\n" \
			"  -M                 specify an alternate music directory\n" \
			"  -h                 this help\n\n" \
			"NOTES:  When combining options it is not necessary to separate them\n" \
			"        (ie: \"%s -v4ds file\").\n\n",
			argv, MIXER_MIN_VOL, MIXER_MAX_VOL, argv);
	}



/*********************************************************************************************************************************/
/*********************************************************************************************************************************/


int main(int argc, char **argv)
	{
	FILE				*the_file;
	boolean 			random_flag = FALSE;
	int8u				songok[7];
	int32				i, rand_swap, num_option;
	int32u				val;
	Compress_File		*tmp_file;
	Compress_FileList	*filelist;
		
	if (argc >= 2)
		{
		for(i = 1; (i < argc) && (*argv[i] == '-'); i++)
			{
			argv[i]++;
			while (*argv[i] != '\0')
				{
				switch (*argv[i]++)
					{
					case 'v':
						mixer_volume = strtol(argv[i], &(argv[i]), 10);
						if (mixer_volume > MIXER_MAX_VOL)
							mixer_volume = MIXER_MAX_VOL;
						else if (mixer_volume < MIXER_MIN_VOL)
							mixer_volume = MIXER_MIN_VOL;
						break;
					case 'd':
						debugging_output = TRUE;
						break;
					case 'r':
						repeat_song = TRUE;
						break;
					case 'm':
						stereo_output = FALSE;
						break;
					case 't':
						tracker_output = TRUE;
						break;
					case 'a':
						sync_output = FALSE;
						break;
					case 'o':
						old_ss_arpeg = TRUE;
						break;
					case 'R':
						random_flag = TRUE;
						break;
					case 'V':
						verbose_flag = TRUE;
						break;
					case 'p':
						break;
					case 'I':
						ss_inst_dir = NEW_ARRAY(char, strlen(argv[i]) + 1);
						strcpy(ss_inst_dir, argv[i]);
						argv[i] += strlen(ss_inst_dir);
						break;
					case 'M':
						ss_music_dir = NEW_ARRAY(char, strlen(argv[i]) + 1);
						strcpy(ss_music_dir, argv[i]);
						argv[i] += strlen(ss_music_dir);
						break;
					default:
						argv[i]--;
						printf("Unknown option '%c'!\n", *argv[i]);
						argv[i]++;
					case 'h':
						print_usage(argv[0]);
						exit(EXIT_SUCCESS);
						break;
					}
				}
			}
		}
	else
		{
		print_usage(argv[0]);
		exit(EXIT_FAILURE);
		}
	
	num_option = i;
	
	if (argc == num_option)
		{
		print_usage(argv[0]);
		exit(EXIT_FAILURE);
		}

	signal(SIGTERM, shutdown);
	signal(SIGKILL, shutdown);
	signal(SIGABRT, shutdown);
	signal(SIGINT,  shutdown);
	old_backgrounder = signal(SIGTSTP, backgrounder);
	old_foregrounder = signal(SIGCONT, foregrounder);

	init_stuff();
	alloc_channels();
	terminal_set(0);
	
	filelist = Compress_GetList(argv + num_option, argc - num_option, (Compress_FFindFile) SS_FindMusicFile);
	
	/* Hey, look!  Another hack because I didn't want to bother changing other code elsewhere. */
	songok[6] = '\0';
	for (i=0 ; i<filelist->num_files ; i++)
		{
		the_file = Compress_FOpen(filelist->file[i]->archive->filename, filelist->file[i]->name);
		fread(songok, 1, 6, the_file);
		if (strcmp(songok, "SONGOK"))
			{
			free(filelist->file[i]->name);
			filelist->file[i]->name = NULL;
			}
		fclose(the_file);
		}	
	
	/* Randomize the songs */
	if (random_flag == TRUE)
		{
		for (i = 0; i < filelist->num_files; i++)
			{
			rand_swap = rand() % filelist->num_files;
			tmp_file                  = filelist->file[i];
			filelist->file[i]         = filelist->file[rand_swap];
			filelist->file[rand_swap] = tmp_file;
			}
		}

	/* Play the songs, this should really be done elsewhere */
	for (i=0 ; i<filelist->num_files ; i++)
		{
		ioctl(seqfd, SNDCTL_SEQ_RESETSAMPLES, &gus_dev);
		ioctl(seqfd, SNDCTL_SEQ_RESET, 0);
		song = NEW(SSmith_song);
		song->patterns = NULL;
		if (filelist->file[i]->archive->type == COMPRESS_UNCOMPRESSED)
			printf("Current song:  '%s'\n", filelist->file[i]->name);
		else
			printf("Current song:  '%s' in archive '%s'\n", filelist->file[i]->name, filelist->file[i]->archive->filename);
		if (load_ssm(filelist->file[i]))
			{
			val = play_ssm();
			if ((val == PREV_SONG) && (i > 0))
				i -= 2;
			usleep(250000);	/* .25 seconds, wait for last few events of previous song to be played	*/
			_seqbufptr = 0;
			for (rand_swap = 0; rand_swap < 14; rand_swap++)	/* once again save 4 bytes of RAM	*/
				{
				GUS_VOICEOFF(gus_dev, rand_swap);
				GUS_RAMPOFF(gus_dev, rand_swap);
				}
			SEQ_DUMPBUF();
			}
		free_song();
		printf("\n");
		}

	shutdown(0);
	exit(EXIT_SUCCESS);
	}
