/*********************************************************************************************************************************/

#define COMPRESS_UNCOMPRESSED	0
#define COMPRESS_LHA			1
#define COMPRESS_TAR			2
#define COMPRESS_ZIP			3
#define COMPRESS_GZIP			4
#define COMPRESS_NULIB			5
#define COMPRESS_TAR_GZIP		6

/*********************************************************************************************************************************/

typedef char *(*Compress_FFindFile)(char *);

typedef struct
	{
	char	*filename;	/* name of the archive file				*/
	int32u	type;		/* archive compression type				*/
	int32u	num_files;	/* number of files stored in archive	*/
	char	**names;	/* names of files stored in archive		*/
	} Compress_Archive;

typedef struct
	{
	char				*name;		/* name of file in archive	*/
	Compress_Archive	*archive;	/* pointer to archive		*/
	} Compress_File;

typedef struct
	{
	int32u			num_files;	/* number of files in list		*/
	Compress_File	**file;		/* array of files				*/
	} Compress_FileList;

/*********************************************************************************************************************************/

extern
char	*Compress_Read[7];

extern
char	*Compress_List[7];

/*********************************************************************************************************************************/

FILE				*Compress_FOpen(char *archivename, char *filename);
int32u				 Compress_GetArchiveType(char *filename);
Compress_FileList	*Compress_GetList(char **archivename, int32u num_archives, Compress_FFindFile findfile);

Compress_Archive	*Compress_GetArchiveFileList(char *filename);

char				*Compress_CommandCat(char *method, char *archivename, char *filename);

/*********************************************************************************************************************************/
