#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Globals.h"

#include "compress.h"

/*********************************************************************************************************************************/

char	*Compress_Read[7] =	{
							"",
							"lha pq ",
							"tar -xOf ",
							"unzip -p ",
							"gunzip -c ",
							"nulib p ",
							"tar -xzOf "
							};

char	*Compress_List[7] =	{
							"",
							"lha v ",
							"tar -tf ",
							"unzip -v ",
							"gunzip -l ",
							"nulib t ",
							"tar -tzf "
							};

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/

FILE *Compress_FOpen(char *archivename, char *filename)
	{
	int32u	type = Compress_GetArchiveType(archivename);
	FILE	*iFile;
	char	*command = NULL;
	char	*method = Compress_Read[type];
	
	if (type != COMPRESS_UNCOMPRESSED)
		{
		if (type == COMPRESS_GZIP)
			filename = "";
		
		command = Compress_CommandCat(method, archivename, filename);
		
		iFile = popen(command, "rb");
		free(command);
		}
	else
		iFile = fopen(archivename, "rb");
	
	if (iFile == NULL)
		perror(archivename);
	
	return iFile;
	}

Compress_Archive *Compress_GetArchiveFileList(char *filename)
	{
	FILE				*iFile;
	char				*command = NULL;
	char				*method;
	Compress_Archive	*archive = NULL;
	int32u				i,
						q,
						len;
	char				str[1024];
	
	if ((iFile = fopen(filename, "rb")) != NULL)
		{
		fclose(iFile);
		
		archive = NEW(Compress_Archive);
		
		archive->filename = NEW_ARRAY(char, strlen(filename) + 1);
		strcpy(archive->filename, filename);
		
		archive->type      = Compress_GetArchiveType(filename);
		archive->num_files = 0;
		archive->names     = NULL;
		
		if (archive->type != COMPRESS_UNCOMPRESSED)
			{
			method  = Compress_List[archive->type];
			command = Compress_CommandCat(method, filename, "");
			iFile = popen(command, "rb");
			free(command);
			
			switch (archive->type)
				{
				case COMPRESS_LHA:
					for (q=0 ; q<220 ; q++,fgetc(iFile));
					fgets(str, 1024, iFile);
					for (i=0 ; !feof(iFile) ; i++)
						{
						len = strlen(str);
						if (str[len - 1] == '\n')
							str[len - 1] = '\0';
						if (!strcmp(str, "-------------"))
							break;
						archive->names = (char **)realloc(archive->names, sizeof(char *) * (i + 1));
						archive->names[i] = NEW_ARRAY(char, len);
						strcpy(archive->names[i], str);
						for (q=0 ; q<65 ; q++,fgetc(iFile));
						fgets(str, 1023, iFile);
						}
					archive->num_files = i;
					break;
				case COMPRESS_TAR:
				case COMPRESS_TAR_GZIP:
				case COMPRESS_NULIB:
					fgets(str, 1024, iFile);
					for (i=0 ; !feof(iFile) ; i++)
						{
						len = strlen(str);
						if (str[len - 1] == '\n')
							str[len - 1] = '\0';
						archive->names = (char **)realloc(archive->names, sizeof(char *) * (i + 1));
						archive->names[i] = NEW_ARRAY(char, len);
						strcpy(archive->names[i], str);
						fgets(str, 1023, iFile);
						}
					archive->num_files = i;
					break;
				case COMPRESS_ZIP:
					for (q=0 ; q<212 ; q++,fgetc(iFile));
					fgets(str, 1024, iFile);
					for (i=0 ; !feof(iFile) ; i++)
						{
						len = strlen(str);
						if (str[len - 1] == '\n')
							str[len - 1] = '\0';
						if (!strcmp(str, "-------"))
							break;
						archive->names = (char **)realloc(archive->names, sizeof(char *) * (i + 1));
						archive->names[i] = NEW_ARRAY(char, len);
						strcpy(archive->names[i], str);
						for (q=0 ; q<58 ; q++,fgetc(iFile));
						fgets(str, 1023, iFile);
						}
					archive->num_files = i;
					break;
				case COMPRESS_GZIP:
					for (q=0 ; q<72 ; q++,fgetc(iFile));
					fgets(str, 1024, iFile);
					for (i=0 ; !feof(iFile) ; i++)
						{
						len = strlen(str);
						if (str[len - 1] == '\n')
							str[len - 1] = '\0';
						if (!strcmp(str, "(totals)"))
							break;
						archive->names = (char **)realloc(archive->names, sizeof(char *) * (i + 1));
						archive->names[i] = NEW_ARRAY(char, len);
						strcpy(archive->names[i], str);
						for (q=0 ; q<27 ; q++,fgetc(iFile));
						fgets(str, 1023, iFile);
						}
					archive->num_files = i;
					break;
				}
			
			fclose(iFile);
			}
		else
			{
			archive->num_files = 1;
			archive->names     = NEW_ARRAY(char *, 1);
			archive->names[0]  = NEW_ARRAY(char, strlen(filename) + 1);
			strcpy(archive->names[0], filename);
			}
		}
	
	return archive;
	}

/*********************************************************************************************************************************/

Compress_FileList *Compress_GetList(char **archivename, int32u num_archives, Compress_FFindFile findfile)
	{
	int32u				i, j, k;
	Compress_Archive	**archive = NEW_ARRAY(Compress_Archive *, num_archives);
	Compress_File		**file;
	int32u				num_files = 0;
	Compress_FileList	*filelist = NULL;
	char				*realarchivename;
	
	for (i=0 ; i<num_archives ; i++)
		{
		realarchivename = findfile(archivename[i]);
		if (realarchivename != NULL)
			{
			archive[i] = Compress_GetArchiveFileList(realarchivename);
			free(realarchivename);
			if (archive[i] != NULL)
				num_files += archive[i]->num_files;
			}
		}
	
	file = NEW_ARRAY(Compress_File *, num_files);
	
	k = 0;
	for (i=0 ; i<num_archives ; i++)
		{
		if (archive[i] != NULL)
			{
			for (j=0 ; j<archive[i]->num_files ; j++)
				{
				file[k] = NEW(Compress_File);
				file[k]->name    = archive[i]->names[j];
				file[k]->archive = archive[i];
				
				k++;
				}
			}
		}
	
	if (k > 0)
		{
		filelist = NEW(Compress_FileList);
		filelist->num_files = num_files;
		filelist->file      = file;
		}
	
	free(archive);
	
	return filelist;
	}

/*********************************************************************************************************************************/

int32u Compress_GetArchiveType(char *filename)
	{
	int32u	len  = strlen(filename);
	int32u	type = COMPRESS_UNCOMPRESSED;
	
	if (len >= 2)
		{
		if (!strcmp(filename + len - 2, ".Z") || !strcmp(filename + len - 2, ".z"))
			type = COMPRESS_GZIP;
		
		if (len >= 3)
			{
			if (!strcmp(filename + len - 3, ".gz"))
				type = COMPRESS_GZIP;
			
			if (len >= 4)
				{
				if (!strcmp(filename + len - 4, ".lha") || !strcmp(filename + len - 4, ".lzh"))
					type = COMPRESS_LHA;
				
				if (!strcmp(filename + len - 4, ".tar"))
					type = COMPRESS_TAR;
				
				if (!strcmp(filename + len - 4, ".zip"))
					type = COMPRESS_ZIP;
				
				if (!strcmp(filename + len - 4, ".shk"))
					type = COMPRESS_NULIB;
				
				if (!strcmp(filename + len - 4, ".tgz") || !strcmp(filename + len - 4, ".taz"))
					type = COMPRESS_TAR_GZIP;
				
				if (len >= 6)
					{
					if (!strcmp(filename + len - 6, ".tar.Z"))
						type = COMPRESS_TAR_GZIP;
					
					if (len >= 7)
						{
						if (!strcmp(filename + len - 7, ".tar.gz"))
							type = COMPRESS_TAR_GZIP;
						}
					}
				}
			}
		}
	
	return type;
	}

/*********************************************************************************************************************************/

char *Compress_CommandCat(char *method, char *archivename, char *filename)
	{
	char	*command = NULL;
	char	*nptr,
			*cptr;
	int32u	quotes = 0;
	
	nptr = archivename;
	while (*nptr != '\0')
		if (*nptr++ == '"')
			quotes++;
	
	nptr = filename;
	while (*nptr != '\0')
		if (*nptr++ == '"')
			quotes++;
	
	command = NEW_ARRAY(char, strlen(method) + strlen(archivename) + strlen(filename) + quotes + 6);
	strcpy(command, method);
	
	cptr = command + strlen(command);
	*cptr++ = '"';
	
	nptr = archivename;
	while (*nptr != '\0')
		{
		if (*nptr == '"')
			*cptr++ = '\\';
		*cptr++ = *nptr++;
		}
	
	*cptr++ = '"';
	
	if (*filename != '\0')
		{
		*cptr++ = ' ';
		*cptr++ = '"';
		
		nptr = filename;
		while (*nptr != '\0')
			{
			if (*nptr == '"')
				*cptr++ = '\\';
			*cptr++ = *nptr++;
			}
		
		*cptr++ = '"';
		}
	
	*cptr++ = '\0';
	
	return command;
	}

/*********************************************************************************************************************************/

