#include <stdio.h>
#include <stdlib.h>
#include "Globals.h"
#include "asif.h"

/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* read the FORM chunk of an ASIF file */

boolean read_FORMchunk(FILE *thefile, FORM_chunk *chunk)
	{
	fread(chunk->id, 1, 4, thefile);
	chunk->id[4] = '\0';
	chunk->size = GET_INT32H(thefile);
	if (chunk->size & 0x00000001)		/* chunks must be an even number of bytes long	*/
		chunk->size += 1;
	fread(chunk->type, 1, 4, thefile);
	chunk->type[4] = '\0';
	return TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Read the INST chunk of an ASIF file.  Get info on the instrument. */

boolean read_INSTchunk(FILE *thefile, INST_chunk *chunk)
	{
	int32	tmp;

	chunk->size = GET_INT32H(thefile);
	tmp = GET_INT8(thefile);				/* get the length of the *$^&*#%^@$ Pascal string */
	fread(chunk->name, 1, tmp, thefile);
	chunk->name[tmp] = '\0';
	chunk->samplenum = GET_INT16L(thefile);	/* this is normally messed up, why do I read it?  I always set it to 0 anyway. */
	if (chunk->samplenum != 0)				/* see */
		chunk->samplenum = 0;
	for (tmp = 0; tmp < 8; tmp++)
		{
		chunk->stage[tmp].breakpoint = GET_INT8(thefile);
		chunk->stage[tmp].increment = GET_INT16L(thefile);
		}
	chunk->releasesegment = GET_INT8(thefile);
	chunk->priorityincrement = GET_INT8(thefile);
	chunk->pitchbendrange = GET_INT8(thefile);
	chunk->vibratodepth = GET_INT8(thefile);
	chunk->vibratospeed = GET_INT8(thefile);
	chunk->updaterate = GET_INT8(thefile);
	chunk->Awavecount = GET_INT8(thefile);
	chunk->Bwavecount = GET_INT8(thefile);

	chunk->Awavelist = NEW_ARRAY(INST_wavelist, chunk->Awavecount);
	chunk->Bwavelist = NEW_ARRAY(INST_wavelist, chunk->Bwavecount);

	for (tmp = 0; tmp < chunk->Awavecount; tmp++)
		{
		chunk->Awavelist[tmp].topkey = GET_INT8(thefile);
		chunk->Awavelist[tmp].waveaddress = GET_INT8(thefile);
		chunk->Awavelist[tmp].wavesize = GET_INT8(thefile);
		chunk->Awavelist[tmp].docmode = GET_INT8(thefile);
		chunk->Awavelist[tmp].relpitch = GET_INT16L(thefile);
		}
	for (tmp = 0; tmp < chunk->Bwavecount; tmp++)
		{
		chunk->Bwavelist[tmp].topkey = GET_INT8(thefile);
		chunk->Bwavelist[tmp].waveaddress = GET_INT8(thefile);
		chunk->Bwavelist[tmp].wavesize = GET_INT8(thefile);
		chunk->Bwavelist[tmp].docmode = GET_INT8(thefile);
		chunk->Bwavelist[tmp].relpitch = GET_INT16L(thefile);
		}
	if (chunk->size & 0x00000001)
		{
		chunk->size += 1;
		THRASH_BYTES(thefile, 1);
		}
	return TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* Read the WAVE chuck.  Get the actual instrument waveform. */

boolean read_WAVEchunk(FILE *thefile, WAVE_chunk *chunk)
	{
	int32	tmp;

	chunk->chunksize = GET_INT32H(thefile);
	tmp = GET_INT8(thefile);		/* get the length of the *$^&*#%^@$ Pascal string */
	fread(chunk->name, 1, tmp, thefile);
	chunk->name[tmp] = '\0';
	chunk->wavesize = GET_INT16L(thefile);
	chunk->numsamples = GET_INT16L(thefile);
	chunk->sampletable = NEW_ARRAY(WAVE_sample, chunk->numsamples);
	for (tmp = 0; tmp < chunk->numsamples; tmp++)
		{
		chunk->sampletable[tmp].location = GET_INT16L(thefile);
		chunk->sampletable[tmp].size = GET_INT16L(thefile);
		chunk->sampletable[tmp].origfreq = GET_INT32H(thefile);
		chunk->sampletable[tmp].samprate = GET_INT32H(thefile);
		}
	chunk->data = NEW_ARRAY(int8u, chunk->wavesize);
	fread(chunk->data, 1, chunk->wavesize, thefile);
	if (chunk->chunksize & 0x00000001)
		{
		chunk->chunksize += 1;
		THRASH_BYTES(thefile, 1);
		}
	return TRUE;
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* One of the many chucks to pretty much ignore.  I might do something with all of them someday.
** The name/info chunk
*/

void read_NAMEchunk(FILE *file)
	{
	int32u	size;

	size = GET_INT32H(file);
	if (size & 0x00000001)
		size += 1;
/*	THRASH_BYTES(file, size);*/		/* the proper, but SLOW way 															*/
	fseek(file, size, SEEK_CUR);	/* the improper but FASTER way, I suppose I could use fread and that too would be fast	*/
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* The author chunk */

void read_AUTHchunk(FILE *file)
	{
	int32u	size;

	size = GET_INT32H(file);
	if (size & 0x00000001)
		size += 1;
	fseek(file, size, SEEK_CUR);	/* the improper but FASTER way */
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* The annotation/yet even more info chunk */

void read_ANNOchunk(FILE *file)
	{
	int32u	size;

	size = GET_INT32H(file);
	if (size & 0x00000001)
		size += 1;
	fseek(file, size, SEEK_CUR);	/* the improper but FASTER way */
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* The copyright chunk */

void read_COPYchunk(FILE *file)
	{
	int32u	size;

	size = GET_INT32H(file);
	if (size & 0x00000001)
		size += 1;
	fseek(file, size, SEEK_CUR);	/* the improper but FASTER way */
	}


/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
/* everyone's favorite chunk */

void read_genericchunk(FILE *file)
	{
	int32u	size;

	size = GET_INT32H(file);
	if (size & 0x00000001)
		size += 1;
	fseek(file, size, SEEK_CUR);	/* the improper but FASTER way */
	}


