/* sod2, a player for polychannel .csf music files.
 * Copyright (C) 1995 Russell Marks. See sod2.c for license details.
 *
 * sod2.h - header for sod2.c
 */


#include "config.h"


/* note modes */

#define PIANO_MODE	0
#define MULTI_MODE	1
#define RETRIGGER_MODE	2
#define OFFSET_MODE	3

/* defaults for grokfile.c:
 * You shouldn't change them, as .csf files are likely to depend
 * on these values.
 */

#define DEFAULTMODE	PIANO_MODE
#define DEFAULTVOLUME	35
#define OCTAVEFIX	2


typedef unsigned int fixed;

/* move from int to fixed (x1024) */
#define FIX_UP(x)	((x)<<10)

/* move from double/float to fixed */
#define FIX_DBL(x)	((fixed)((x)*1024.0+0.5))

/* move from fixed to int */
#define FIX_DOWN(x)	((x)>>10)

/* pattern - a few bars of notes (of size 'blocksize').
 * line - one or more patterns played simultaneously.
 */

struct sample {
  char *data;	/* signed char, because it's signed data */
  int rate;
  int len;
  };

/* NB: all timings in struct note are in fractions of bytes */
struct note {
  int notenum;		/* note number (not used while playing) */
  fixed offset;		/* offset through sample playback */
  fixed gap;		/* next-sample gap along sample */
  int counter;		/* incr'd once per sample gen'd */
  fixed sustain,release; /* for enveloping - offsets from start of note */
  fixed relsus;		/* release minus sustain */
  int vol;		/* volume - 0<=vol<=100 */
  int sample;		/* idx in samples[] of sample used by note */
  char *data;		/* ptr to sample data */
  fixed len;		/* sample len x1024 */
  int pattern;		/* these are both duplicated here... */
  int mode;		/* ...for quick reference while playing */
  };

struct pattern {
  struct note notes[MAX_BLOCKSIZE];
  int mode;
  };


extern void die(char *str);


extern int sample_maxval,sample_midval,vsr,psr;
extern int oversample;
extern struct pattern patterns[];
extern struct sample samples[];
extern struct note *active[];
extern int bsize,tempo;
extern int next_sample,last_pattern,last_line;
extern int verbose;
extern int buf_fd[];
