/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pmod.h"

#define HEADER_SIZE	0x40

void detectModuleType( FILE *file )
{
  byte *header;
  
  if ( ( header = (byte *)malloc( HEADER_SIZE ) ) == NULL )
    fatal( "detectModuleType: alloc error\n" );

  if ( fread( header, HEADER_SIZE, 1, file ) != 1 )
    fatal( "detectModuleType: read error\n" );
  if ( fseek( file, 0, SEEK_SET ) < 0 )
    fatal( "detectModuleType: seek error\n" );
  
  if ( !strncmp( header, "Extended Module: ", 17 ) )
    moduleType = MODULE_XM;
   else
  if ( !strncmp( &header[ 0x2c ], "SCRM", 4 ) )
    moduleType = MODULE_S3M;
   else
  if ( !strncmp( header, "MTM", 3 ) )
    moduleType = MODULE_MTM;
   else
  if ( header[ 0 ] == 0x69 && header[ 1 ] == 0x66 )
    moduleType = MODULE_669;
   else
    moduleType = MODULE_MOD;
    
  free( header );
}
