/*
 *  Copyright (c) 1994/95 by Jaroslav Kysela (Perex soft)
 *  Routine(s) for handle IRQ from GUS (MAX)
 */

#include "gus_dev.h"

volatile long gf1_synth_irqs = -1;

void gus_interrupt( int unused, struct pt_regs *regs )
{
  register unsigned char status;
  short loop = 1;
 
#if 0
  PRINTK( "gus_interrupt: monitor\n" );
#endif
  while ( loop ) 
    {
      loop = 0;

      status = INB( GUSP( IRQSTAT ) );
      if ( status & 0xec )		/* ignore MIDI IRQ */
        {
#if 0
          PRINTK( "gus_interrupt: gf1 irq status = 0x%x\n", status );
#endif
          if ( gf1_synth_irqs >= 0 )
            {
              gf1_synth_irqs++;
              WAKEUP( dma1 );
            }
           else
          if ( gf1_mode == GF1_MODE_SYNTH )
            gf1_synth_interrupt( status );
           else
          if ( gf1_mode == GF1_MODE_PCM )
            gf1_pcm_interrupt( status );
        }
        
      if ( use_codec && max_flag && codec_mode == CODEC_MODE_USED )
    				/* only MAX's CODEC shares IRQ with GF1 */
        {
          CLI();
          status = codec_in( CODEC_IRQ_STATUS );
          STI();
#if 0
          PRINTK( "gus_interrupt: codec irq status = 0x%x\n", status );
#endif
          if ( status & ( CODEC_PLAYBACK_IRQ | 
                          CODEC_RECORD_IRQ | 
                          CODEC_TIMER_IRQ ) )
            {
              codec_interrupt( status );
              loop = 1;
            }
        }
    }
#if 0
  PRINTK( "IRQ END\n" );
#endif
}
