#ifdef USE_X

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>

#include <Xfwf/Board.h>

#include "xstructs.h"
#include "xglobals.h"

void
callback_track_close (Widget w, XtPointer client_data, XtPointer call_data)
{
  XtPopdown (x_info.trackShell.w);
  XtVaSetValues (x_info.topShell.topBox.trackCommand, XtNsensitive, True, NULL);
}

void
TrackClose (Widget w, XEvent *event, String *parms, Cardinal *nparms)
{
  callback_track_close (w, (XtPointer)0, (XtPointer)0);
}


void
create_track (void)
{
  static XtActionsRec trackActionsTable[] =
  {
    {"trackClose", (XtActionProc)TrackClose}
  };

  x_info.trackShell.w =
    XtVaCreatePopupShell ("trackShell", topLevelShellWidgetClass,
			  x_info.topShell.w,
			  XtNtitle, "Xgmod Tracker",
			  XtNiconName, "Xgmod Tracker",
			  NULL);

  XtAppAddActions (x_info.app_context, trackActionsTable, XtNumber(trackActionsTable));

  XtOverrideTranslations (x_info.trackShell.w,
			  XtParseTranslationTable ("<Message>WM_PROTOCOLS: trackClose()"));

  x_info.trackShell.trackForm.w =
    XtVaCreateManagedWidget ("trackForm", formWidgetClass,
			     x_info.trackShell.w,
			     NULL);

  x_info.trackShell.trackForm.trackView.w =
    XtVaCreateManagedWidget ("trackView", viewportWidgetClass,
			     x_info.trackShell.trackForm.w,
			     XtNallowHoriz, True,
			     XtNforceBars, True,
			     XtNtop, XawChainTop,
			     XtNbottom, XawChainBottom,
			     XtNleft, XawChainLeft,
			     XtNright, XawChainRight,
			     NULL);


  x_info.trackShell.trackForm.trackView.trackBoard.w =
    XtVaCreateManagedWidget ("trackBoard", xfwfBoardWidgetClass,
			     x_info.trackShell.trackForm.trackView.w,
			     NULL);

  x_info.trackShell.trackForm.trackView.trackBoard.trackList =
    XtVaCreateManagedWidget ("trackList", listWidgetClass,
			     x_info.trackShell.trackForm.trackView.trackBoard.w,
			     XtNlist, empty_list,
			     XtNnumberStrings, 1,
			     XtNdefaultColumns, 1,
			     XtNforceColumns, True,
			     NULL);

  XtUninstallTranslations (x_info.trackShell.trackForm.trackView.trackBoard.trackList);

  x_info.trackShell.trackForm.closeCommand =
    XtVaCreateManagedWidget ("closeCommand", commandWidgetClass,
			     x_info.trackShell.trackForm.w,
			     XtNlabel, "Close",
			     XtNfromVert, x_info.trackShell.trackForm.trackView.w,
			     XtNtop, XawChainBottom,
			     XtNbottom, XawChainBottom,
			     XtNleft, XawChainLeft,
			     XtNright, XawChainLeft,
			     NULL);

  XtAddCallback (x_info.trackShell.trackForm.closeCommand, XtNcallback,
		 callback_track_close, (XtPointer) 0);
}
#endif
