/* Copyright (C) 1995 by Andrew Robinson */

/* This file is part of the GMOD package */

#ifndef _STDIO_H
#include <stdio.h>
#endif

/* in compress.c */
short compress_voice (short last_voice, short position, int notes_per_track,
		      int skip);

/* in cvt_period.c */
void period_to_note (int period, int *note, int *pitchbend);

/* in effects.c */
void set_speed (int parm, unsigned char clock_speed);
void set_volslide (int channel, int amount, char type);
void set_slideto (int channel, int rate, int note, unsigned char type,
		  unsigned char mod_type);
void set_arpeg (int channel, int amount);
void set_vibrato (int channel, int amount);
void set_tremolo (int channel, int amount);
void set_tremor (int channel, int amount);
void set_panning (int channel, signed char panning, unsigned char hw_flag,
		  signed char pan_factor);

/* in init.c */
void init_voices (void);

/* int load_669.c */
int load_669_module (FILE * mod_fd, char *name, struct song_info *song_char,
		     struct options_info options, char *buffer);

/* in load_mod.c */
int load_module (char *name, struct song_info *song_char,
		 struct options_info options);

/* in load_mtm.c */
int load_mtm_module (FILE * mod_fd, char *name, struct song_info *song_char,
		     struct options_info options, char *buffer);

/* in load_s3m.c */
int load_s3m_module (FILE * mod_fd, char *name, struct song_info *song_char,
		     struct options_info options, char *buffer,
		     char *command);

/* in load_ult.c */
int load_ult_module (FILE * mod_fd, char *name, struct song_info *song_char,
		     struct options_info options, char *buffer);

/* in message.c */
void init_message_q (void);
void get_message (char *message, unsigned long timestamp);
void put_message (char *message, unsigned long timestamp);

/* in misc.c */
int panning (int ch);
void sync_time (void);
unsigned short intelize (unsigned short v);
int gus_mem_free (int);
unsigned char vol_log_to_lin (unsigned char volume);
void free_patterns (unsigned int nr_samples);
void stop_all_channels (unsigned char song_end);
void remove_noprint (char *string);

/* in parse.c */
int parse_args (int argc, char *argv[], struct options_info *options);

/* in patch_load.c */
void patch_load (FILE * mod_fd, struct patch_info *patch, int sample_num);

/* in play_mod.c */
int play_module (int start_position, struct song_info *song_char,
		 struct options_info options);

/* in play_note.c */
int play_note (int channel, int position, int pattern, struct note_info *pat,
	       struct song_info *song_char, struct effect_info *effects,
	       struct options_info *options);

/* in play_voice.c */
void lets_play_voice (int channel, struct voice_info *v,
		      struct song_info *song_char, int tick_no);

/* in proc_input.c */
unsigned int proc_input (void);

/* in signals.c */
void timer_set (int mode);
void timer_handler (int sig);

/* in terminal.c */
void terminal_set (int mode);
