
/* Copyright (C) 1995 by Andrew Robinson */

/*
*	gmod.c	- Module player for GUS and Linux.
*		(C) Hannu Savolainen, 1993
*
*	NOTE!	This program doesn't try to be a complete module player.
*		It's just a too I used while developing the driver. In
*		addition it can be used as an example on programming
*		the VoxWare Sound Driver with GUS.
*/

/*
* Many modifications have been done by Andrew J. Robinson.
* Refer to the ChangeLog for details.
*/


#ifndef USE_X
#include <sys/time.h>
#endif
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#ifdef USE_LOCAL
#include "soundcard.h"
#else
#include <sys/soundcard.h>
#endif

#ifdef USE_X
#include <X11/Intrinsic.h>
#include "xdefines.h"
#include "xstructs.h"
#include "xglobals.h"
#endif

#include "defines.h"
#include "structs.h"
#include "protos.h"
#include "globals.h"

void
seqbuf_dump ()
{
  int result, offset = 0;
  int outcount;
  extern int driver_version;
#ifndef USE_X
  fd_set read_fds, write_fds;

  FD_ZERO (&read_fds);
  FD_ZERO (&write_fds);
#else
  XtInputMask mask;
#endif

  while (_seqbufptr && dump_enabled)
    {
#ifdef USE_X
      callback_arg = INPUTS_X;

      while (callback_arg == INPUTS_X)
	{
	  /* give priority to AlternateInput events */

	  mask = XtAppPending (x_info.app_context);
	  if (mask & XtIMAlternateInput)
	    mask = XtIMAlternateInput;
	  else
	    mask = (XtIMXEvent | XtIMAlternateInput);

	  XtAppProcessEvent (x_info.app_context, mask);
	}
#else
      FD_SET (0, &read_fds);	/* standard input */
      FD_SET (seqfd, &read_fds);
      FD_SET (seqfd, &write_fds);
      select (seqfd + 1, &read_fds, &write_fds, NULL, NULL);
#endif

#ifdef USE_X
      if (callback_arg == INPUTS_WRITE)
#else
      if (FD_ISSET (seqfd, &write_fds))
#endif
	{
	  if (driver_version <= 2)
	    {
	      ioctl (seqfd, SNDCTL_SEQ_GETOUTCOUNT, &outcount);
	      outcount *= 8;
	      if (outcount > _seqbufptr)
		outcount = _seqbufptr;
	    }
	  else
	    outcount = _seqbufptr;

	  if ((result = write (seqfd, _seqbuf + offset, outcount)) == -1)
	    {
	      if (errno != EAGAIN)
		{
		  perror ("write /dev/sequencer");
		  exit (ERR_SEQUENCER);
		}
	    }
	  else if (result != _seqbufptr)
	    {
	      _seqbufptr -= result;
	      offset += result;
	    }
	  else
	    _seqbufptr = 0;
	}

#ifdef USE_X
      if (callback_arg == INPUTS_READ)
#else
      if (FD_ISSET (seqfd, &read_fds))
#endif
	proc_input ();

#ifndef USE_X
      if (FD_ISSET (0, &read_fds))
	timer_handler (-1);
#endif
    }

  _seqbufptr = 0;
}
