/* Copyright (C) 1995 by Andrew Robinson */
/* This file is part of the GMOD package */

#include <string.h>
#include <stdlib.h>

#include "defines.h"
#include "structs.h"
#include "globals.h"

short
compress_voice (short last_voice, short position, int notes_per_track,
		int skip)
{
  int voice;

  for (voice = 0; voice < last_voice; voice++)
    {
      if (voice == position)
	{
	  voice += (skip - 1);
	}
      else if ((pattern_table[voice] != NULL) &&
	       !bcmp (pattern_table[voice],
		      pattern_table[position], sizeof (struct note_info) *
		      notes_per_track))
	  {
	    free (pattern_table[position]);
	    pattern_table[position] = NULL;
	    return voice;
	  }
    }

  return position;
}
