/*
 * Slide Widget public include file
 *
 * (c) 1995 by Martin Denn <mdenn@unix-ag.uni-kl.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _Slide_h
#define _Slide_h

/*
 * This include not needed unless the application includes Intrinsic.h
 * after this file.   Anyway, it doesn't hurt.
 */
#include <X11/Core.h>

/* Resources:
 * Name		     Class		RepType		Default Value
 * ----		     -----		-------		-------------
 * (from RectObj)
 * ancestorSensitive
 * x		    Position		Int		0
 * y		    Position		Int		0
 * width	    Dimension		Dimension	0
 * height	    Dimension		Dimension	0
 * borderWidth	    BorderWidth		Int
 * sensitive	    Sensitive
 *
 * (from WindowObj)
 * screen	    Screen		Pointer		XtCopyScreen
 * depth	    Depth		Int		XtCopyFromParent
 * colormap	    Colormap	        Pointer	        XtCopyFromParent
 * background	    Background		Pixel		White
 * backgroundPixmap    Pixmap		Pixmap		XtUnspecifiedPixmap
 * borderColor	    BorderColor		Pixel		Black
 * borderPixmap	    BorderPixmap	Pixmap		XtUnspecifiedPixmap
 * mappedWhenManaged   MappedWhenManaged	Boolean		True
 * translations
 * accelerators
 *
 * (from Core)
 * none
 *
 * (from Slide)
 * slideColor	    SlideColor		Pixel		White
 * common	    Common		Boolean		True
 * leftValue	    LeftValue		Int		0
 * rightValue	    RightValue		Int		0
 * numberOfLEDs	    NumberOfLEDs	Int		16
 * pixmap	    Pixmap		Pixmap		NULL
 * slideBackground  SlideBackground	Pixel		Black
 * callback	    Callback		Callback	NULL
 * rBExists	    RBExists		Boolean		False
 * rBOn		    RBOn		Boolean		False
 * rBColor	    RBColor		Pixel		Black
 * rBBackColor	    RBBackColor		Pixel		White
 * rBCallback	    RBCallback		Callback	NULL
 */

 
#define XtNslideColor "slideColor"
#define XtNcommon "common"
#define XtNleftValue "leftValue"
#define XtNrightValue "rightValue"
#define XtNnumberOfLEDs "numberOfLEDs"
#define XtNslideBackground "slideBackground"
#define	XtNrBExists "rBExists"
#define XtNrBOn "rBOn"
#define XtNrBColor "rBColor"
#define XtNrBBackColor "rBBackColor"
#define XtNrBCallback "rBCallback"

#define XtCSlideColor "SlideColor"
#define XtCCommon "Common"
#define XtCLeftValue "LeftValue"
#define XtCRightValue "RightValue"
#define XtCNumberOfLEDs "NumberOfLEDs"
#define XtCSlideBackground "slideBackground"
#define	XtCRBExists "RBExists"
#define XtCRBOn "RBOn"
#define XtCRBColor "RBColor"
#define XtCRBBackColor "RBBackColor"
#define XtCRBCallback "RBCallback"

/* Data type returned by XtNCallback */
typedef struct 
{
    int lvalue, rvalue;
} SlideInfo; 

/* Class record constants */

extern WidgetClass slideWidgetClass;

typedef struct _SlideClassRec *SlideWidgetClass;
typedef struct _SlideRec      *SlideWidget;

#endif /* _Slide_h */
/* DON'T ADD STUFF AFTER THIS #endif */
