/* 
   CAM - Cpu's Audio Mixer for Linux 
 
   AUTHOR: Jan 'TWP' VANDENBERGHE (jvdbergh@wins.uia.ac.be) 
*/ 
 
/* 
     This program is free software; you can redistribute it and/or 
     modify it under the terms of the GNU General Public License 
     as published by the Free Software Foundation; either version 2 
     of the License, or (at your option) any later version. 
 
     This program is distributed in the hope that it will be useful, 
     but WITHOUT ANY WARRANTY; without even the implied warranty of 
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
     GNU General Public License for more details. 
 
     You should have received a copy of the GNU General Public License 
     along with this program; if not, write to the Free Software 
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/ 
 
#define DEV_COUNT SOUND_MIXER_NRDEVICES 
#define DIST 3 
#define X_POS 12 + ( 40 * ( dev_nr / ( DEV_COUNT / 2 ) ) ) 
#define Y_POS 3 + (dev_nr % ( DEV_COUNT / 2 ) ) * DIST 
 
#define STEREO ((1 << dev_nr) & stereodevs)  /* is device a stereo device */ 
#define DEV_EXIST ((1 << dev_nr) & devmask) /* does device exists */ 
#define DEV_REC ((1 << dev_nr) & recmask) /* is device is a record device */ 
#define REC_ON ((1 << dev_nr) & recsrc) /* is record on */ 
 
void Adjust(int temp[2],int dev_nr); 
void ctrl_slide(void); 
void init_sound(); 
void set_sound( int argc, char *argv[]); 
