#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

int mdev;

#define TRK (0<<6)
#define DAT (1<<6)
#define CMD (2<<6)
#define RES (3<<6)


char start[] = {
  RES,					/* reset device */
  CMD+1, 0x34,			    	/* send timing byte always */
  CMD+1, 0x8e,				/* conductor off */
  CMD+1, 0x8c,				/* don't send measures while recording */
  CMD+1, 0x98, CMD+1, 0x9a, CMD+1, 0x9c, CMD+1, 0x9e, /* channel ref off */
  CMD+1, 0xec, DAT+1, 0x7f, CMD+1, 0xb8, CMD+1, 0x2a /* start record/play */
};

char chrd1[] = { TRK+5, 6, 0x18, 0x99, 0x4c, 0x7f, 
    /*              ^     ^     ^     ^    ^-- veloc
     *              I     I     I     +-- key nr
     *              I     I     +-- Noteon, channel 1
     *              I     +-- wait 0x18 Ticks, then play
     *              +-- put following 4 Bytes to Track
     */

		 TRK+5, 5, 0x18,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x18,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x18,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x18,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x18,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x18,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 6, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 5, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 4, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 3, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 2, 0x00,  0xb0, 0x40, 0x00,
		 TRK+5, 1, 0x00,  0xb0, 0x40, 0x7f,
		 TRK+5, 0, 0x00,  0xb0, 0x40, 0x00,
                 TRK+5, 6, 0x00,  0x99, 0x4d, 0x7f, 
/*
                 TRK+3, 0x00,       0x59, 0x5f, 
*/
                 TRK+4, 5, 0x18,       0x4c, 0,
                 TRK+4, 4, 0x18,       0x4d, 0,
/*
                 TRK+3, 0x00,       0x59, 0,
*/
		 TRK+5, 3, 120, 0x99, 0x4c, 0x7f,
		 TRK+5, 2, 122,  0x99, 0x4d, 0x7f,
                 TRK+4, 0, 0x00,       0x4c, 0,
                 TRK+4, 0, 0x00,       0x4d, 0,

		 TRK+5, 0, 170, 0x99, 0x4c, 0x7f,
		 TRK+5, 0, 0x00,  0x99, 0x4d, 0x7f,
                 TRK+4, 0, 0x18,       0x4c, 0,
                 TRK+4, 0, 0x00,       0x4d, 0,

		 TRK+5, 0, 170, 0x99, 0x4c, 0x7f,
		 TRK+5, 0, 0x00,  0x99, 0x4d, 0x7f,
                 TRK+4, 0, 0x18,       0x4c, 0,
                 TRK+4, 0, 0x00,       0x4d, 0,

		 TRK+5, 0, 170, 0x99, 0x4c, 0x7f,
		 TRK+5, 0, 0x00,  0x99, 0x4d, 0x7f,
                 TRK+4, 0, 0x18,       0x4c, 0,
                 TRK+4, 0, 0x00,       0x4d, 0,

		 TRK+5, 0, 170, 0x99, 0x4c, 0x7f,
		 TRK+5, 0, 0x00,  0x99, 0x4d, 0x7f,
                 TRK+4, 0, 0x18,       0x4c, 0,
                 TRK+4, 0, 0x00,       0x4d, 0,

                 };

char noteon[] = { TRK+4, 0x18, 0x91, 0x40, 0x7f,
                  TRK+3, 0x05,       0x44, 0x7f,
                  TRK+3, 0x05,       0x47, 0x7f
                  };

char noteof[] = { TRK+4, 0x18, 0x91, 0x40, 0x0,
                  TRK+3, 0x0,        0x44, 0x0,
                  TRK+3, 0x0,        0x47, 0x0 
                  };


int dwrite(int dev, char *buf, int len)
{
  int written = 0;
  while (len > written)
  {
    int bytes = write(dev, buf + written, len - written);
    if (bytes < 0)
    {
      int i;
      printf("Error %d writing: ", bytes);
      for (i = 0; i < len; i++)
        printf("%02x ", buf[i]);
      printf("at Positon %d\n", written);
      exit(1);
    }
    written += bytes;
    usleep(1000 * 100);	/* do something useful here */
  }
  return len;
}

#define MIDINET_SERVICE "midinet"

int main(void)
{
  int i, j;
  int dev;

  char *midinethost;

        midinethost = getenv("MIDINETHOST");
        if (!midinethost || !strlen(midinethost)) {
                midinethost = "localhost";
        }
        dev = midinetconnect( midinethost, MIDINET_SERVICE);

  if (dev < 0)
  {
    printf("Device %d\n", dev);
    return 1;
  }

  dwrite(dev, start, sizeof(start));
      dwrite(dev, chrd1, sizeof(chrd1));
/*
  for (i = 0; i < 2; i++)
  {
    dwrite(dev, noteon, sizeof(noteon));
    for (j = 0; j < 5; j++)
      dwrite(dev, chrd1, sizeof(chrd1));
    dwrite(dev, noteof, sizeof(noteof));
  }
*/
  printf("Done, press <cr>\n");
  getchar();
  close(dev);
  return 0;
}
